/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.mapping;

import coldfusion.orm.mapping.CFCPersistenceMetadata;
import coldfusion.orm.mapping.OneToManyField;
import coldfusion.sql.DBMetaData;
import coldfusion.sql.ForeignKeyMetaData;
import coldfusion.sql.TableMetaData;
import java.sql.SQLException;
import java.util.Map;

public class ManyToManyField
extends OneToManyField {
    private boolean missingRowIgnored;
    private String foreignKeyName;

    public boolean isMissingRowIgnored() {
        return this.missingRowIgnored;
    }

    public void setMissingRowIgnored(boolean missingRowIgnored) {
        this.missingRowIgnored = missingRowIgnored;
    }

    @Override
    public void resolve(CFCPersistenceMetadata cfcPmd, Map<String, CFCPersistenceMetadata> cfcMetaDataMap, DBMetaData dbMetaData) {
        if (this.fkColumns != null && this.inverseJoinColumn != null) {
            return;
        }
        CFCPersistenceMetadata targetCfcPmd = cfcMetaDataMap.get(this.targetComponent);
        if (targetCfcPmd == null) {
            return;
        }
        ManyToManyField targetManyToManyField = (ManyToManyField)targetCfcPmd.getRelationField(cfcPmd.getCfcName(), 4);
        if (targetManyToManyField != null) {
            if (this.fkColumns == null && targetManyToManyField.getInverseJoinColumn() != null) {
                this.fkColumns = targetManyToManyField.getInverseJoinColumn();
            }
            if (this.inverseJoinColumn == null && targetManyToManyField.getFkColumns() != null) {
                this.inverseJoinColumn = targetManyToManyField.getFkColumns();
            }
            if (this.fkColumns != null && this.inverseJoinColumn != null) {
                return;
            }
        }
        try {
            TableMetaData linkTableMetadata = null;
            if (dbMetaData != null) {
                linkTableMetadata = dbMetaData.getTableMetaData(this.linkTable, this.linkTableSchema, this.linkTableCatalog);
            }
            if (linkTableMetadata != null) {
                Map fkMap = linkTableMetadata.getForeignKeys();
                for (String fkCol : fkMap.keySet()) {
                    ForeignKeyMetaData fkMetadata = (ForeignKeyMetaData)fkMap.get(fkCol);
                    String pktableName = fkMetadata.getPktableName();
                    if (this.fkColumns == null && pktableName.equalsIgnoreCase(cfcPmd.getTableName())) {
                        this.fkColumns = new String[]{fkCol};
                        continue;
                    }
                    if (this.inverseJoinColumn != null || !pktableName.equalsIgnoreCase(targetCfcPmd.getTableName())) continue;
                    this.inverseJoinColumn = new String[]{fkCol};
                }
                if (targetManyToManyField != null) {
                    if (targetManyToManyField.getFkColumns() == null) {
                        targetManyToManyField.setFkColumns(this.inverseJoinColumn);
                    }
                    if (targetManyToManyField.getInverseJoinColumn() == null) {
                        targetManyToManyField.setInverseJoinColumn(this.fkColumns);
                    }
                }
                return;
            }
            TableMetaData thisTableMetadata = null;
            TableMetaData thatTableMetadata = null;
            if (dbMetaData != null) {
                thisTableMetadata = dbMetaData.getTableMetaData(cfcPmd.getTableName(), cfcPmd.getSchema(), cfcPmd.getCatalog());
                thatTableMetadata = dbMetaData.getTableMetaData(targetCfcPmd.getTableName(), targetCfcPmd.getSchema(), targetCfcPmd.getCatalog());
            }
            if (thisTableMetadata == null && thatTableMetadata == null) {
                this.fkColumns = this.generateFKColumnNames(cfcPmd, null);
                this.inverseJoinColumn = this.generateFKColumnNames(targetCfcPmd, null);
                if (targetManyToManyField != null) {
                    targetManyToManyField.setFkColumns(this.inverseJoinColumn);
                    targetManyToManyField.setInverseJoinColumn(this.fkColumns);
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean isResolved() {
        return this.fkColumns != null && this.inverseJoinColumn != null;
    }

    @Override
    public int getRelationType() {
        return 4;
    }

    public void setForeignKeyName(String foreignKeyName) {
        this.foreignKeyName = foreignKeyName;
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }
}

