/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.mapping;

import coldfusion.filter.FusionContext;
import coldfusion.orm.ORMSettings;
import coldfusion.orm.db.SQLToJavaTypes;
import coldfusion.orm.mapping.CFCPersistenceMetadata;
import coldfusion.orm.mapping.CollectionField;
import coldfusion.orm.mapping.EmbeddedField;
import coldfusion.orm.mapping.IDField;
import coldfusion.orm.mapping.IDGenerator;
import coldfusion.orm.mapping.ManyToManyField;
import coldfusion.orm.mapping.ManyToOneField;
import coldfusion.orm.mapping.NamingStrategy;
import coldfusion.orm.mapping.OneToManyField;
import coldfusion.orm.mapping.OneToOneField;
import coldfusion.orm.mapping.PropertyField;
import coldfusion.orm.mapping.RelationField;
import coldfusion.orm.mapping.TimeStampField;
import coldfusion.orm.mapping.VersionField;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.MetadataUtils;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.sql.ColumnMetaData;
import coldfusion.sql.DBMetaData;
import coldfusion.sql.ForeignKeyMetaData;
import coldfusion.sql.TableMetaData;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.Key;
import coldfusion.util.RB;
import coldfusion.util.RuntimeWrapper;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class CFPropertyBinder {
    private AttributeCollection metadata;
    private String cfcName;
    private CFCPersistenceMetadata cfcPmd;
    private DBMetaData dbMetaData;
    private ORMSettings ormSettings;
    private NamingStrategy namingStrategy;
    private TableMetaData tableMetaData;
    private boolean metadataCloned = false;
    private static final String ARRAY = "array";
    private static final String STRUCT = "struct";
    private static Set<String> cascadeOptions = new HashSet<String>();
    private static Set<String> cacheStrategies = new HashSet<String>();
    private String cfcpackage;
    private static final String EXTENDS = "EXTENDS";
    private static final Set<String> numericTypes = new HashSet<String>();

    public CFPropertyBinder(String pathToCFC, Map<String, DBMetaData> dbMetaDataMap, ORMSettings ormsettings, NamingStrategy namingStrategy) throws Exception {
        this.ormSettings = ormsettings;
        this.namingStrategy = namingStrategy;
        NeoPageContext pageContext = FusionContext.getCurrent().pageContext;
        try {
            this.metadata = (AttributeCollection)MetadataUtils.getBasicComponentMetadata((File)VFSFileFactory.getFileObject((String)pathToCFC), (NeoPageContext)pageContext, null);
        }
        catch (Throwable throwable) {
            throw new RuntimeWrapper(throwable);
        }
        String dataSource = (String)this.metadata.get((Object)"datasource");
        this.dbMetaData = this.getDBMetaData(dataSource, dbMetaDataMap);
        this.cfcName = (String)this.metadata.get((Object)"name");
        int lastIndex = this.cfcName.lastIndexOf(46);
        if (lastIndex != -1) {
            this.cfcpackage = this.cfcName.substring(0, lastIndex);
        }
    }

    private DBMetaData getDBMetaData(String dataSource, Map<String, DBMetaData> dbMetaDataMap) {
        if (dbMetaDataMap == null) {
            return null;
        }
        if (dataSource == null) {
            dataSource = this.ormSettings.getDataSource();
        }
        if (this.ormSettings.getDBCreateOption(dataSource) == 2) {
            return null;
        }
        DBMetaData dbMetaData = dbMetaDataMap.get(dataSource);
        if (dbMetaData == null) {
            try {
                dbMetaData = new DBMetaData(dataSource);
                dbMetaDataMap.put(dataSource, dbMetaData);
            }
            catch (SQLException e) {
                throw new RuntimeWrapper((Throwable)e);
            }
        }
        return dbMetaData;
    }

    public String getCFCName() {
        return this.cfcName;
    }

    public boolean isPersistent() {
        String persistentStr = (String)this.metadata.get((Object)"persistent");
        return this.toBoolean(persistentStr);
    }

    public boolean hasPersistentField() {
        Object[] props = (Object[])this.metadata.get((Object)"properties");
        if (props == null) {
            return false;
        }
        for (Object prop : props) {
            AttributeCollection attr = (AttributeCollection)prop;
            String persistentStr = (String)attr.get((Object)"persistent");
            if (persistentStr != null && !Cast._boolean((String)persistentStr)) continue;
            return true;
        }
        return false;
    }

    public synchronized CFCPersistenceMetadata getCFCPersistenceMetadata() {
        if (this.cfcPmd == null) {
            this.buildCFCPersistenceMetadata();
        }
        return this.cfcPmd;
    }

    private CFCPersistenceMetadata buildCFCPersistenceMetadata() {
        if (!this.isPersistent()) {
            return null;
        }
        Map<String, String> parentCFCMap = this.getParentCFCName();
        boolean hasPersistentField = this.hasPersistentField();
        this.cfcPmd = new CFCPersistenceMetadata();
        if (parentCFCMap != null && parentCFCMap.get("persistent") != null) {
            this.cfcPmd.setParentCfcName(parentCFCMap.get("name"));
        }
        this.readCFCData();
        if (!hasPersistentField && parentCFCMap == null) {
            this.generatePropertiesFromDB();
            if (this.cfcPmd == null) {
                return null;
            }
        }
        if (this.metadata.get((Object)"discriminatorValue") == null && this.metadata.get((Object)"joinColumn") == null) {
            this.readPropertiesFromMappedSuperClass(this.metadata);
        }
        if (!this.hasPersistentField()) {
            return this.cfcPmd;
        }
        this.readProperties();
        this.addIdFieldIfNotDefined();
        return this.cfcPmd;
    }

    private void addIdFieldIfNotDefined() {
        if (this.cfcPmd.getIdField() == null && this.cfcPmd.getParentCfcName() == null) {
            IDField idField = this.getIdFieldFromPropertyFields();
            if (idField != null) {
                this.cfcPmd.addIdField(idField);
            } else {
                if (this.dbMetaData != null && this.tableMetaData == null) {
                    if (this.cfcPmd.getSchema() == null && this.cfcPmd.getCatalog() == null) {
                        throw new AttributeValidationException(RB.getString((Object)this, (String)"undefinedId_NoTable", (Object)this.cfcName, (Object)this.cfcPmd.getTableName()));
                    }
                    if (this.cfcPmd.getCatalog() == null) {
                        throw new AttributeValidationException(RB.getString((Object)this, (String)"undefinedId_NoTableSchema", (Object)this.cfcName, (Object)this.cfcPmd.getTableName(), (Object)this.cfcPmd.getSchema()));
                    }
                    throw new AttributeValidationException(RB.getString((Object)this, (String)"undefinedId_NoTableSchemaCatalog", (Object)this.cfcName, (Object)this.cfcPmd.getTableName(), (Object)this.cfcPmd.getSchema(), (Object)this.cfcPmd.getCatalog()));
                }
                throw new AttributeValidationException(RB.getString((Object)this, (String)"idNotDefined", (Object)this.cfcName));
            }
        }
    }

    private IDField getIdFieldFromPropertyFields() {
        Object[] propsArray;
        List<PropertyField> propertyFields = this.cfcPmd.getPropertyFields();
        PropertyField idPropField = null;
        for (PropertyField field : propertyFields) {
            if (!field.getName().equalsIgnoreCase("id")) continue;
            idPropField = field;
            break;
        }
        if (idPropField == null) {
            return null;
        }
        for (Object o : propsArray = (Object[])this.metadata.get((Object)"properties")) {
            IDGenerator idGenerator;
            Map props = (Map)o;
            String propertyName = (String)props.get("name");
            if (!propertyName.equalsIgnoreCase("id")) continue;
            String fieldType = (String)props.get("fieldType");
            if (fieldType != null) break;
            propertyFields.remove(idPropField);
            IDField idField = new IDField();
            idField.setName(idPropField.getName());
            idField.setColumn(idPropField.getColumn());
            idField.setDataType(idPropField.getDataType());
            if (idPropField.getLength() > 0) {
                idField.setLength(idPropField.getLength());
            }
            if ((idGenerator = this.createIdGenerator(props)) != null) {
                idField.setGenerator(idGenerator);
            }
            return idField;
        }
        return null;
    }

    private void readCFCData() {
        String whereString;
        String cacheStrategy;
        String rowId;
        String lazyStr;
        String optimisticLock;
        String batchSizeStr;
        String discCol;
        String selectBeforeUpdateStr;
        String readOnlyStr;
        String dynamicUpdateStr;
        String dynamicInsertStr;
        this.cfcPmd.setCfcName(this.cfcName);
        String mappedSuperClassStr = (String)this.metadata.get((Object)"mappedSuperClass");
        if (this.toBoolean(mappedSuperClassStr)) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"persistentMappedSuperClass", (Object)this.cfcName));
        }
        String datasource = (String)this.metadata.get((Object)"datasource");
        if (datasource == null) {
            datasource = this.ormSettings.getDataSource();
        }
        this.cfcPmd.setDatasource(datasource);
        String entityName = (String)this.metadata.get((Object)"entityname");
        if (entityName == null || entityName.trim().length() == 0) {
            entityName = this.getUnqualifiedName(this.cfcName);
        }
        this.cfcPmd.setEntityName(entityName);
        String tableName = (String)this.metadata.get((Object)"table");
        tableName = tableName != null && tableName.trim().length() > 0 ? this.getDBUnescapedName(tableName) : entityName;
        this.cfcPmd.setTableName(this.namingStrategy.getTableName(tableName));
        String schema = (String)this.metadata.get((Object)"schema");
        schema = schema == null ? this.ormSettings.getDefaultSchema(datasource) : schema;
        this.cfcPmd.setSchema(schema);
        String catalog = (String)this.metadata.get((Object)"catalog");
        catalog = catalog == null ? this.ormSettings.getDefaultCatalog(datasource) : catalog;
        this.cfcPmd.setCatalog(catalog);
        if (this.dbMetaData != null) {
            try {
                this.tableMetaData = this.dbMetaData.getTableMetaData(this.cfcPmd.getTableName(), this.cfcPmd.getSchema(), this.cfcPmd.getCatalog());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (this.tableMetaData == null && this.ormSettings.getDBCreateOption(datasource) == 0) {
                if (this.cfcPmd.getSchema() == null && this.cfcPmd.getCatalog() == null) {
                    throw new AttributeValidationException(RB.getString((Object)this, (String)"tableNotFound", (Object)this.cfcPmd.getTableName(), (Object)this.cfcName));
                }
                if (this.cfcPmd.getCatalog() == null) {
                    throw new AttributeValidationException(RB.getString((Object)this, (String)"tableNotFoundSchema", (Object)this.cfcPmd.getTableName(), (Object)this.cfcPmd.getSchema(), (Object)this.cfcName));
                }
                throw new AttributeValidationException(RB.getString((Object)this, (String)"tableNotFoundSchemaCatalog", (Object)this.cfcPmd.getTableName(), (Object)this.cfcPmd.getSchema(), (Object)this.cfcPmd.getCatalog(), (Object)this.cfcName));
            }
        }
        if ((dynamicInsertStr = (String)this.metadata.get((Object)"dynamicInsert")) != null) {
            this.cfcPmd.setDynamicInsert(this.toBoolean(dynamicInsertStr, "dynamicInsert", null));
        }
        if ((dynamicUpdateStr = (String)this.metadata.get((Object)"dynamicUpdate")) != null) {
            this.cfcPmd.setDynamicUpdate(this.toBoolean(dynamicUpdateStr, "dynamicUpdate", null));
        }
        if ((readOnlyStr = (String)this.metadata.get((Object)"readOnly")) != null) {
            this.cfcPmd.setReadOnly(this.toBoolean(readOnlyStr, "readOnly", null));
        }
        if ((selectBeforeUpdateStr = (String)this.metadata.get((Object)"selectBeforeUpdate")) != null) {
            this.cfcPmd.setSelectBeforeUpdate(this.toBoolean(selectBeforeUpdateStr, "selectBeforeUpdate", null));
        }
        if ((discCol = (String)this.metadata.get((Object)"discriminatorColumn")) != null && discCol.length() > 0) {
            discCol = this.getDBUnescapedName(discCol);
            this.cfcPmd.setDiscriminatorColumn(this.namingStrategy.getColumnName(discCol));
        }
        this.cfcPmd.setDiscriminatorValue((String)this.metadata.get((Object)"discriminatorValue"));
        String joinColumn = (String)this.metadata.get((Object)"joinColumn");
        if (joinColumn != null && joinColumn.length() > 0) {
            joinColumn = this.getDBUnescapedName(joinColumn);
            this.cfcPmd.setJoinColumn(this.namingStrategy.getColumnName(joinColumn));
        }
        if ((batchSizeStr = (String)this.metadata.get((Object)"batchSize")) != null) {
            int batchSize = this.toInt(batchSizeStr, "batchSize", null);
            if (batchSize <= 0) {
                throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidBatchSize", (Object)batchSize, (Object)this.cfcName));
            }
            this.cfcPmd.setBatchSize(batchSize);
        }
        if ((optimisticLock = (String)this.metadata.get((Object)"optimisticLock")) != null) {
            if ((optimisticLock = optimisticLock.toLowerCase()).equals("none") || optimisticLock.equals("version") || optimisticLock.equals("dirty") || optimisticLock.equals("all")) {
                this.cfcPmd.setOptimisticLock(optimisticLock);
            } else {
                throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidOptimisticLock", (Object)optimisticLock, (Object)this.cfcName));
            }
        }
        if ((lazyStr = (String)this.metadata.get((Object)"lazy")) != null) {
            this.cfcPmd.setLazy(this.toBoolean(lazyStr, "lazy", null));
        }
        if ((rowId = (String)this.metadata.get((Object)"rowid")) != null) {
            this.cfcPmd.setRowId(rowId);
        }
        if ((cacheStrategy = (String)this.metadata.get((Object)"cacheUse")) != null && !(cacheStrategy = cacheStrategy.toLowerCase()).equals("none")) {
            this.validateCacheStrategy(cacheStrategy, null);
            this.cfcPmd.setCacheStrategy(cacheStrategy);
            String cacheName = (String)this.metadata.get((Object)"cacheName");
            if (cacheName != null && cacheName.length() != 0) {
                this.cfcPmd.setCacheName(cacheName);
            }
        }
        if ((whereString = (String)this.metadata.get((Object)"where")) != null) {
            this.cfcPmd.setWhereString(whereString);
        }
        String saveMapping = (String)this.metadata.get((Object)"saveMapping");
        this.cfcPmd.setSaveMapping(saveMapping);
    }

    private String getUnqualifiedName(String cfcName) {
        int index = cfcName.lastIndexOf(46);
        if (index == -1) {
            return cfcName;
        }
        return cfcName.substring(index + 1);
    }

    private Map<String, String> getParentCFCName() {
        String parentCFCName;
        Object parentMetaDataObj = this.metadata.get((Object)EXTENDS);
        if (parentMetaDataObj == null) {
            return null;
        }
        AttributeCollection parentMetadata = null;
        if (parentMetaDataObj instanceof AttributeCollection) {
            parentMetadata = (AttributeCollection)parentMetaDataObj;
            parentCFCName = (String)parentMetadata.get((Object)"NAME");
        } else {
            parentCFCName = this.getQualifiedCFCName((String)parentMetaDataObj);
        }
        if ("WEB-INF.cftags.component".equalsIgnoreCase(parentCFCName)) {
            return null;
        }
        if (parentMetadata == null) {
            try {
                TemplateProxy parentCFC = TemplateProxyFactory.createTemplateProxyForMetaData((String)parentCFCName, (NeoPageContext)FusionContext.getCurrent().pageContext, null);
                parentMetadata = (AttributeCollection)parentCFC.getRuntimeMetadata();
            }
            catch (Throwable th) {
                throw new CFCLoadException(th, RB.getString((Object)this, (String)"parentCFCLoadError", (Object)parentCFCName, (Object)this.cfcName));
            }
        }
        if (parentMetadata != null) {
            boolean persistent = this.toBoolean((String)parentMetadata.get((Object)"persistent"));
            boolean mappedSuperClass = this.toBoolean((String)parentMetadata.get((Object)"mappedSuperClass"));
            if (persistent || mappedSuperClass) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", parentCFCName);
                if (persistent) {
                    map.put("persistent", "true");
                }
                return map;
            }
        }
        return null;
    }

    private void readProperties() {
        Object[] propsArray;
        for (Object o : propsArray = (Object[])this.metadata.get((Object)"properties")) {
            Map props = (Map)o;
            String fieldType = (String)props.get("fieldType");
            String persistentStr = (String)props.get("persistent");
            if (persistentStr != null && !"true".equalsIgnoreCase(persistentStr) && !"yes".equalsIgnoreCase(persistentStr)) continue;
            this.bindProperty(props, fieldType);
        }
    }

    private void bindProperty(Map<String, String> props, String fieldType) {
        if (fieldType != null && fieldType.indexOf(44) != -1) {
            String[] fieldTypes = fieldType.trim().split(",");
            if (fieldTypes.length == 1) {
                fieldType = fieldTypes[0];
            } else {
                fieldTypes[0] = fieldTypes[0].trim();
                fieldTypes[1] = fieldTypes[1].trim();
                if (fieldTypes[0].equalsIgnoreCase("id") && fieldTypes[1].equalsIgnoreCase("many-to-one") || fieldTypes[0].equalsIgnoreCase("many-to-one") && fieldTypes[1].equalsIgnoreCase("id")) {
                    ManyToOneField manyToOne = this.createManyToOneField(props);
                    this.cfcPmd.addIdField(manyToOne);
                    return;
                }
            }
        }
        if (fieldType == null) {
            fieldType = this.getFieldTypeFromDB(props);
        }
        if ((fieldType = fieldType.toLowerCase()).equals("id")) {
            this.cfcPmd.addIdField(this.createIdField(props));
        } else if (fieldType.equals("column")) {
            this.cfcPmd.addPropertyField(this.createPropertyField(props));
        } else if (fieldType.equals("embedded")) {
            this.cfcPmd.addEmbeddedField(this.createEmbeddedField(props));
        } else if (fieldType.equals("version")) {
            this.cfcPmd.setVersion(this.createVersionField(props));
        } else if (fieldType.equals("timestamp")) {
            this.cfcPmd.setTimestamp(this.createTimeStampField(props));
        } else if (fieldType.equals("one-to-one")) {
            this.cfcPmd.addRelationField(this.createOneToOneField(props));
        } else if (fieldType.equals("many-to-one")) {
            this.cfcPmd.addRelationField(this.createManyToOneField(props));
        } else if (fieldType.equals("one-to-many")) {
            this.cfcPmd.addRelationField(this.createOneToManyField(props));
        } else if (fieldType.equals("many-to-many")) {
            this.cfcPmd.addRelationField(this.createManyToManyField(props));
        } else if (fieldType.equals("collection")) {
            this.cfcPmd.addCollectionField(this.createCollectionField(props));
        } else {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidFieldType", (Object)fieldType, (Object)props.get("name"), (Object)this.cfcName));
        }
    }

    private String getFieldTypeFromDB(Map<String, String> props) {
        if (this.tableMetaData != null) {
            String colName = props.get("column");
            colName = colName == null ? props.get("name") : this.getDBUnescapedName(colName);
            ColumnMetaData colMetaData = this.tableMetaData.getColumnMetaData(colName = this.namingStrategy.getColumnName(colName));
            if (colMetaData != null && colMetaData.isPK()) {
                return "id";
            }
        }
        return "column";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IDField createIdField(Map<String, String> props) {
        String sqlType;
        IDGenerator generator;
        ColumnMetaData colMetaData;
        IDField field = new IDField();
        field.setName(props.get("name"));
        String column = props.get("column");
        column = column == null || column.trim().length() == 0 ? props.get("name") : this.getDBUnescapedName(column);
        column = this.namingStrategy.getColumnName(column);
        ColumnMetaData columnMetaData = colMetaData = this.tableMetaData == null ? null : this.tableMetaData.getColumnMetaData(column);
        if (colMetaData != null) {
            column = colMetaData.getName();
        }
        field.setColumn(column);
        String dataType = props.get("ormType");
        if (dataType == null || dataType.length() == 0) {
            if (colMetaData == null) {
                String genClass = props.get("generator");
                if ("native".equals(genClass) || "identity".equals(genClass) || "increment".equals(genClass)) {
                    dataType = "int";
                } else {
                    dataType = props.get("TYPE");
                    if (dataType == null || dataType.length() == 0) {
                        dataType = "string";
                    } else if (dataType.equals("numeric")) {
                        dataType = "int";
                    }
                }
            } else {
                dataType = this.getDataTypeFromDB(colMetaData);
            }
        }
        field.setDataType(dataType);
        String unsavedValue = props.get("unsavedValue");
        field.setUnsavedValue(unsavedValue);
        String lengthStr = props.get("length");
        if (lengthStr != null) {
            int length = this.toInt(lengthStr, "length", props.get("name"));
            if (length <= 0) throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidLength", (Object)length, (Object)props.get("name"), (Object)this.cfcName));
            field.setLength(length);
        } else if (colMetaData != null) {
            field.setLength(colMetaData.getColumnSize());
        }
        if ((generator = this.createIdGenerator(props)) != null) {
            field.setGenerator(generator);
        }
        if ((sqlType = props.get("sqltype")) == null) return field;
        field.setSqlType(sqlType);
        return field;
    }

    private String getDataTypeFromDB(ColumnMetaData colMetaData) {
        return colMetaData == null ? null : SQLToJavaTypes.getPreferredJavaType(colMetaData.getSqlType(), colMetaData.getColumnSize(), colMetaData.getDecimalDigits());
    }

    private IDGenerator createIdGenerator(Map<String, String> props) {
        String genClass = props.get("generator");
        IDGenerator generator = null;
        if (genClass != null) {
            generator = new IDGenerator(genClass);
            String paramsStr = props.get("params");
            Map<String, String> params = null;
            if (paramsStr != null && paramsStr.trim().length() > 0) {
                params = this.parseParams(paramsStr, props.get("name"));
                for (String key : params.keySet()) {
                    generator.addParam(key, params.get(key));
                }
            }
            if (genClass.equals("sequence")) {
                String sequenceName;
                if (params == null || !params.containsKey("sequence")) {
                    sequenceName = props.get("sequence");
                    if (sequenceName == null) {
                        throw new PropertyAttributeMissingException("sequence", props.get("name"), this.cfcName);
                    }
                    generator.addParam("sequence", sequenceName);
                }
                if (params != null && params.containsKey("sequence")) {
                    generator.removeParam("sequence");
                    sequenceName = params.get("sequence");
                    if (sequenceName == null) {
                        throw new PropertyAttributeMissingException("sequence", props.get("name"), this.cfcName);
                    }
                    generator.addParam("sequence_name", sequenceName);
                }
            } else if (genClass.equals("select")) {
                if (params == null || !params.containsKey("key")) {
                    String selectKey = props.get("selectKey");
                    if (selectKey == null) {
                        throw new PropertyAttributeMissingException("selectKey", props.get("name"), this.cfcName);
                    }
                    generator.addParam("key", selectKey);
                }
            } else if (genClass.equals("foreign") && (params == null || !params.containsKey("property"))) {
                String property = props.get("property");
                if (property == null) {
                    throw new PropertyAttributeMissingException("property", props.get("name"), this.cfcName);
                }
                generator.addParam("property", property);
            }
        }
        return generator;
    }

    private Map<String, String> parseParams(String paramsStr, String propertyName) {
        try {
            return Utils.parseStructString((String)paramsStr);
        }
        catch (Exception e) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidParams", (Object)propertyName, (Object)this.cfcName));
        }
    }

    private PropertyField createPropertyField(Map<String, String> props) {
        String tableName;
        String sqlType;
        String defaultVal;
        String optimisticLock;
        String unique;
        String notNull;
        String uniqueKeyName;
        String indexName;
        String generated;
        String scale;
        String precision;
        String lengthStr;
        String updateStr;
        String dataType;
        PropertyField field = new PropertyField();
        String name = props.get("name");
        field.setName(name);
        String formula = props.get("formula");
        field.setFormula(formula);
        ColumnMetaData colMetaData = null;
        if (formula == null) {
            String column = props.get("column");
            column = column == null || column.length() == 0 ? name : this.getDBUnescapedName(column);
            column = this.namingStrategy.getColumnName(column);
            ColumnMetaData columnMetaData = colMetaData = this.tableMetaData == null ? null : this.tableMetaData.getColumnMetaData(column);
            if (colMetaData != null) {
                column = colMetaData.getName();
            }
            field.setColumn(column);
        }
        if ((dataType = props.get("ormType")) == null || dataType.length() == 0) {
            dataType = this.getDataTypeFromDB(colMetaData);
        }
        if (dataType == null) {
            dataType = props.get("TYPE");
            String string = dataType = dataType == null ? "string" : dataType.toLowerCase();
            if (dataType.equals("numeric")) {
                dataType = "double";
            }
        }
        field.setDataType(dataType);
        String insertStr = props.get("insert");
        if (insertStr != null) {
            field.setInsertable(this.toBoolean(insertStr, "insert", name));
        }
        if ((updateStr = props.get("update")) != null) {
            field.setUpdatable(this.toBoolean(updateStr, "update", name));
        }
        if ((lengthStr = props.get("length")) != null) {
            int length = this.toInt(lengthStr, "length", name);
            if (length > 0) {
                field.setLength(length);
            } else {
                throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidLength", (Object)length, (Object)name, (Object)this.cfcName));
            }
        }
        if ((precision = props.get("precision")) != null) {
            field.setPrecision(this.toInt(precision, "precision", name));
        }
        if ((scale = props.get("scale")) != null) {
            field.setScale(this.toInt(scale, "scale", name));
        }
        if ((generated = props.get("generated")) != null && generated.length() != 0) {
            if (!((generated = generated.toLowerCase()).equals("never") || generated.equals("always") || generated.equals("insert"))) {
                throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidGenerated", (Object)generated, (Object)name, (Object)this.cfcName));
            }
            field.setGenerated(generated);
        }
        if ((indexName = props.get("index")) != null && indexName.trim().length() != 0) {
            field.setIndexName(indexName);
        }
        if ((uniqueKeyName = props.get("uniqueKey")) != null && uniqueKeyName.trim().length() != 0) {
            field.setUniqueKeyName(uniqueKeyName);
        }
        if ((notNull = props.get("notnull")) != null) {
            field.setNotNull(this.toBoolean(notNull, "notnull", name));
        } else if (colMetaData != null) {
            field.setNotNull(!colMetaData.isNullable());
        }
        String lazy = props.get("lazy");
        if (lazy != null) {
            field.setLazy(this.toBoolean(lazy, "lazy", name));
        }
        if ((unique = props.get("unique")) != null) {
            field.setUnique(this.toBoolean(unique, "unique", name));
        }
        if ((optimisticLock = props.get("optimisticLock")) != null) {
            field.setOptimisticLock(this.toBoolean(optimisticLock, "optimisticLock", name));
        }
        if ((defaultVal = props.get("dbDefault")) != null) {
            field.setDefault(defaultVal);
        }
        if ((sqlType = props.get("sqltype")) != null) {
            field.setSQLType(sqlType);
        }
        if ((tableName = props.get("table")) != null && tableName.length() > 0) {
            tableName = this.getDBUnescapedName(tableName);
            tableName = this.namingStrategy.getTableName(tableName);
            field.setTable(tableName);
            field.setSchema(props.get("schema"));
            field.setCatalog(props.get("catalog"));
            field.setMappedBy(props.get("mappedBy"));
            String joinColumn = props.get("joinColumn");
            if (joinColumn != null) {
                joinColumn = this.getDBUnescapedName(joinColumn);
                joinColumn = this.namingStrategy.getColumnName(joinColumn);
            }
            if (this.dbMetaData != null) {
                TableMetaData tableMetaData = null;
                try {
                    tableMetaData = this.dbMetaData.getTableMetaData(tableName, props.get("schema"), props.get("catalog"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (tableMetaData == null && this.ormSettings.getDBCreateOption(this.cfcPmd.getDatasource()) == 0) {
                    throw new AttributeValidationException(RB.getString((Object)this, (String)"joinTableNotFound", (Object)tableName, (Object)name, (Object)this.cfcName));
                }
                if (joinColumn == null && tableMetaData != null) {
                    Map fks = tableMetaData.getForeignKeys();
                    for (ForeignKeyMetaData fkMetaData : fks.values()) {
                        if (!fkMetaData.getPktableName().equalsIgnoreCase(this.cfcPmd.getTableName())) continue;
                        joinColumn = fkMetaData.getFkColName();
                        break;
                    }
                }
            }
            if (joinColumn == null) {
                throw new AttributeValidationException(RB.getString((Object)this, (String)"joinColumnMissingForJoinMapping", (Object)name, (Object)this.cfcName));
            }
            field.setJoinColumn(joinColumn);
        }
        return field;
    }

    private EmbeddedField createEmbeddedField(Map<String, String> props) {
        Object[] propsArray;
        AttributeCollection embedMetadata;
        EmbeddedField field = new EmbeddedField();
        String name = props.get("name");
        field.setName(name);
        String embeddedCfcName = props.get("cfc");
        if (embeddedCfcName == null) {
            throw new PropertyAttributeMissingException("cfc", name, embeddedCfcName);
        }
        embeddedCfcName = this.getQualifiedCFCName(embeddedCfcName);
        field.setCfcName(embeddedCfcName);
        try {
            NeoPageContext pageContext = FusionContext.getCurrent().pageContext;
            File cfcFile = TemplateProxyFactory.getTemplateFile((String)embeddedCfcName, (NeoPageContext)pageContext);
            embedMetadata = (AttributeCollection)MetadataUtils.getComponentMetadata((File)cfcFile, (NeoPageContext)pageContext, null);
        }
        catch (Throwable th) {
            throw new CFCLoadException(th, RB.getString((Object)this, (String)"embeddedCFCLoadError", (Object)embeddedCfcName, (Object)name, (Object)this.cfcName));
        }
        String embedded = (String)embedMetadata.get((Object)"embedded");
        if (embedded != null && !Cast._boolean((String)embedded)) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidEmbeddedField", (Object)embeddedCfcName, (Object)name, (Object)this.cfcName));
        }
        for (Object o : propsArray = (Object[])embedMetadata.get((Object)"properties")) {
            String persistentStr;
            Map embedProps = (Map)o;
            String fieldType = (String)embedProps.get("fieldType");
            if (fieldType == null) {
                fieldType = "column";
            }
            if ((persistentStr = (String)embedProps.get("persistent")) != null && !"true".equalsIgnoreCase(persistentStr) && !"yes".equalsIgnoreCase(persistentStr)) continue;
            if (fieldType.equals("column")) {
                field.addPropertyField(this.createPropertyField(embedProps));
                continue;
            }
            if (fieldType.equals("one-to-one")) {
                field.addRelationField(this.createOneToOneField(props));
                continue;
            }
            if (fieldType.equals("many-to-one")) {
                field.addRelationField(this.createManyToOneField(props));
                continue;
            }
            if (fieldType.equals("one-to-many")) {
                field.addRelationField(this.createOneToManyField(props));
                continue;
            }
            if (fieldType.equals("many-to-many")) {
                field.addRelationField(this.createManyToManyField(props));
                continue;
            }
            if (fieldType.equals("collection")) {
                field.addCollectionField(this.createCollectionField(props));
                continue;
            }
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidFieldType", (Object)fieldType, (Object)props.get("name"), (Object)embeddedCfcName));
        }
        return field;
    }

    private VersionField createVersionField(Map<String, String> props) {
        String insert;
        ColumnMetaData colMetadata;
        if (this.cfcPmd.getVersion() != null || this.cfcPmd.getTimestamp() != null) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"nonUniqueVersionTimeStamp", (Object)props.get("name"), (Object)this.cfcName));
        }
        VersionField version = new VersionField();
        version.setName(props.get("name"));
        String column = props.get("column");
        column = column == null || column.length() == 0 ? props.get("name") : this.getDBUnescapedName(column);
        column = this.namingStrategy.getColumnName(column);
        ColumnMetaData columnMetaData = colMetadata = this.tableMetaData == null ? null : this.tableMetaData.getColumnMetaData(column);
        if (colMetadata != null) {
            column = colMetadata.getName();
        }
        version.setColumn(column);
        String dataType = props.get("ormType");
        if (dataType != null) {
            if (!((dataType = dataType.toLowerCase()).equals("long") || dataType.equals("int") || dataType.equals("integer") || dataType.equals("short") || dataType.equals("timestamp"))) {
                throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidVersionDataType", (Object)dataType, (Object)this.cfcName));
            }
        } else {
            dataType = colMetadata != null ? this.getDataTypeFromDB(colMetadata) : "int";
        }
        version.setDataType(dataType);
        String generated = props.get("generated");
        if (generated != null) {
            version.setGenerated(this.toBoolean(generated, "generated", props.get("name")));
        }
        if ((insert = props.get("insert")) != null) {
            version.setInsertEnabled(this.toBoolean(insert, "insert", props.get("name")));
        }
        return version;
    }

    private TimeStampField createTimeStampField(Map<String, String> props) {
        String source;
        ColumnMetaData colMetadata;
        if (this.cfcPmd.getVersion() != null || this.cfcPmd.getTimestamp() != null) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"nonUniqueVersionTimeStamp", (Object)props.get("name"), (Object)this.cfcName));
        }
        TimeStampField field = new TimeStampField();
        field.setName(props.get("name"));
        String column = props.get("column");
        column = column == null || column.length() == 0 ? props.get("name") : this.getDBUnescapedName(column);
        column = this.namingStrategy.getColumnName(column);
        ColumnMetaData columnMetaData = colMetadata = this.tableMetaData == null ? null : this.tableMetaData.getColumnMetaData(column);
        if (colMetadata != null) {
            column = colMetadata.getName();
        }
        field.setColumn(column);
        String generated = props.get("generated");
        if (generated != null) {
            field.setGenerated(this.toBoolean(generated, "generated", props.get("name")));
        }
        if ((source = props.get("source")) != null) {
            if (source.equalsIgnoreCase("vm") || source.equalsIgnoreCase("db")) {
                field.setSource(source);
            } else {
                throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidTimestampSource", (Object)source, (Object)props.get("name"), (Object)this.cfcName));
            }
        }
        return field;
    }

    private void populateRelationField(RelationField field, Map<String, String> props) {
        String cascade;
        String mappedBy;
        String name = props.get("name");
        field.setName(name);
        String targetComponent = props.get("cfc");
        if (targetComponent == null) {
            throw new PropertyAttributeMissingException("cfc", name, this.cfcName);
        }
        String targetCFC = this.getQualifiedCFCName(targetComponent);
        this.validateTargetCFC(targetCFC, name);
        field.setTargetComponent(targetCFC);
        String fkcolumn = props.get("fkcolumn");
        if (fkcolumn != null && fkcolumn.length() > 0) {
            field.setFkColumns(this.getColumnArray(fkcolumn));
        }
        if ((mappedBy = props.get("mappedBy")) != null && mappedBy.length() > 0) {
            field.setMappedBy(mappedBy);
        }
        if ((cascade = props.get("cascade")) != null) {
            this.validateCascadeOption(cascade, name);
            field.setCascade(cascade);
        }
        String fetch = props.get("fetch");
        this.validateFetchValue(fetch, name);
        field.setFetch(fetch);
        String linkTable = props.get("linkTable");
        if (linkTable != null && linkTable.length() > 0) {
            linkTable = this.getDBUnescapedName(linkTable);
            linkTable = this.namingStrategy.getTableName(linkTable);
            field.setLinkTable(linkTable);
            String linkTableCatalog = props.get("linkCatalog");
            linkTableCatalog = linkTableCatalog == null ? this.ormSettings.getDefaultCatalog(this.cfcPmd.getDatasource()) : linkTableCatalog;
            field.setLinkTableCatalog(linkTableCatalog);
            field.setLinkTableSchema(props.get("linkSchema"));
            String inverseJoinColumn = props.get("inverseJoinColumn");
            if (inverseJoinColumn != null && inverseJoinColumn.trim().length() != 0) {
                field.setInverseJoinColumn(this.getColumnArray(inverseJoinColumn));
            }
        }
    }

    private String[] getColumnArray(String fkcolumn) {
        StringTokenizer tokenizer = new StringTokenizer(fkcolumn, ",");
        String[] fkColumns = new String[tokenizer.countTokens()];
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            String column = tokenizer.nextToken().trim();
            column = this.getDBUnescapedName(column);
            column = this.namingStrategy.getColumnName(column);
            fkColumns[count++] = column;
        }
        return fkColumns;
    }

    private RelationField createOneToOneField(Map<String, String> props) {
        String sqlType;
        String missingRowIgnored;
        String lazy;
        OneToOneField field = new OneToOneField();
        this.populateRelationField(field, props);
        String name = props.get("name");
        if (field.getMappedBy() != null && field.getFkColumns() != null) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidMappedBy", (Object)name, (Object)this.cfcName));
        }
        String constrained = props.get("constrained");
        if (constrained != null) {
            field.setConstrained(this.toBoolean(constrained, "constrained", props.get("name")));
        }
        if ((lazy = props.get("lazy")) != null) {
            field.setLazy(this.toBoolean(lazy, "lazy", props.get("name")) ? "proxy" : "false");
        }
        field.setForeignKeyName(props.get("foreignKeyName"));
        String inverse = props.get("INVERSE");
        if (inverse != null) {
            field.setInverse(this.toBoolean(inverse, "INVERSE", props.get("name")));
        }
        if ((missingRowIgnored = props.get("missingRowIgnored")) != null) {
            field.setMissingRowIgnored(this.toBoolean(missingRowIgnored, "missingRowIgnored", props.get("name")));
        }
        if ((sqlType = props.get("sqltype")) != null) {
            field.setSqlType(sqlType);
        }
        return field;
    }

    private void validateTargetCFC(String targetCFC, String relationName) {
        Map metadata;
        NeoPageContext pageContext = FusionContext.getCurrent().pageContext;
        try {
            metadata = (Map)MetadataUtils.getComponentMetadata((String)targetCFC, (NeoPageContext)pageContext, null);
        }
        catch (Throwable throwable) {
            throw new CFCLoadException(throwable, RB.getString((Object)this, (String)"relationCFCLoadError", (Object)targetCFC, (Object)relationName, (Object)this.cfcName));
        }
        String persistentStr = (String)metadata.get("persistent");
        boolean persistent = this.toBoolean(persistentStr);
        if (!persistent) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"targetNotPersistent", (Object)targetCFC, (Object)relationName, (Object)this.cfcName));
        }
    }

    private void validateFetchValue(String fetch, String propertyName) {
        if (fetch == null) {
            return;
        }
        if (!fetch.equals("join") && !fetch.equals("select")) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidFetch", (Object)fetch, (Object)propertyName, (Object)this.cfcName));
        }
    }

    private void validateCascadeOption(String cascade, String propertyName) {
        String[] options;
        for (String option : options = cascade.split(",")) {
            if (cascadeOptions.contains(option = option.trim().toLowerCase())) continue;
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidCascade", (Object)option, (Object)propertyName, (Object)this.cfcName));
        }
    }

    private void validateCacheStrategy(String cacheStrategy, String propertyName) {
        if (!cacheStrategies.contains(cacheStrategy)) {
            if (propertyName == null) {
                throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidCacheUse", (Object)cacheStrategy, (Object)this.cfcName));
            }
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidCacheUseRelation", (Object)cacheStrategy, (Object)propertyName, (Object)this.cfcName));
        }
    }

    private ManyToOneField createManyToOneField(Map<String, String> props) {
        String sqlType;
        String fkName;
        String uniqueKey;
        String indexName;
        String optimisticLock;
        String lazy;
        String updatable;
        String insertStr;
        String unique;
        String notNull;
        ManyToOneField field = new ManyToOneField();
        this.populateRelationField(field, props);
        String name = props.get("name");
        String missingRowIgnored = props.get("missingRowIgnored");
        if (missingRowIgnored != null) {
            field.setMissingRowIgnored(this.toBoolean(missingRowIgnored, "missingRowIgnored", props.get("name")));
        }
        if ((notNull = props.get("notnull")) != null) {
            field.setNotNull(this.toBoolean(notNull, "notnull", name));
        }
        if ((unique = props.get("unique")) != null) {
            field.setUnique(this.toBoolean(unique, "unique", name));
        }
        if ((insertStr = props.get("insert")) != null) {
            field.setInsertable(this.toBoolean(insertStr, "insert", name));
        }
        if ((updatable = props.get("update")) != null) {
            field.setUpdatable(this.toBoolean(updatable, "update", name));
        }
        if ((lazy = props.get("lazy")) != null) {
            field.setLazy(this.toBoolean(lazy, "lazy", name) ? "proxy" : "false");
        }
        if ((optimisticLock = props.get("optimisticLock")) != null) {
            field.setOptimisticLock(this.toBoolean(optimisticLock, "optimisticLock", name));
        }
        if ((indexName = props.get("index")) != null && indexName.trim().length() != 0) {
            field.setIndexName(indexName);
        }
        if ((uniqueKey = props.get("uniqueKey")) != null && uniqueKey.trim().length() != 0) {
            field.setUniqueKeyName(uniqueKey);
        }
        if ((fkName = props.get("foreignKeyName")) != null && fkName.trim().length() != 0) {
            field.setForeignKeyName(fkName);
        }
        if ((sqlType = props.get("sqltype")) != null) {
            field.setSqlType(sqlType);
        }
        return field;
    }

    private RelationField createOneToManyField(Map<String, String> props) {
        OneToManyField field = new OneToManyField();
        this.populateOneToManyRelation(field, props);
        return field;
    }

    private void populateOneToManyRelation(OneToManyField field, Map<String, String> props) {
        String onDelete;
        String where;
        String cacheStrategy;
        String readOnly;
        String lazy;
        String inverse;
        String cascade;
        String batchSizeStr;
        String name = props.get("name");
        this.populateRelationField(field, props);
        String collectionType = props.get("TYPE");
        if (collectionType == null) {
            collectionType = ARRAY;
        }
        if (!collectionType.equalsIgnoreCase(ARRAY) && !collectionType.equalsIgnoreCase(STRUCT)) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidCollectionType", (Object)collectionType, (Object)name, (Object)this.cfcName));
        }
        field.setCollectionType(collectionType);
        field.setOrderBy(props.get("orderBy"));
        if (collectionType.equalsIgnoreCase(STRUCT)) {
            String keyColumn = props.get("structKeyColumn");
            if (keyColumn == null) {
                throw new PropertyAttributeMissingException("structKeyColumn", props.get("name"), this.cfcName);
            }
            field.setStructKeyColumn(keyColumn);
            String keyDataType = props.get("structKeyType");
            if (keyDataType != null) {
                field.setStructKeyDataType(keyDataType);
            }
        }
        if ((batchSizeStr = props.get("batchSize")) != null) {
            int batchSize = this.toInt(batchSizeStr, "batchSize", props.get("name"));
            if (batchSize <= 0) {
                throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidRelationBatchSize", (Object)batchSize, (Object)props.get("name"), (Object)this.cfcName));
            }
            field.setBatchSize(Cast._int((long)batchSize));
        }
        if ((cascade = props.get("cascade")) != null) {
            this.validateCascadeOption(cascade, name);
            field.setCascade(cascade);
        }
        if ((inverse = props.get("INVERSE")) != null) {
            field.setInverse(this.toBoolean(inverse, "INVERSE", props.get("name")));
        }
        if (!((lazy = props.get("lazy")) == null || lazy.equalsIgnoreCase("true") || lazy.equalsIgnoreCase("false") || lazy.equalsIgnoreCase("extra"))) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidLazy", (Object)lazy, (Object)props.get("name"), (Object)this.cfcName));
        }
        field.setLazy(lazy);
        String optimisticLock = props.get("optimisticLock");
        if (optimisticLock != null) {
            field.setOptimisticLock(this.toBoolean(optimisticLock, "optimisticLock", props.get("name")));
        }
        if ((readOnly = props.get("readOnly")) != null) {
            field.setReadOnly(this.toBoolean(readOnly, "readOnly", props.get("name")));
        }
        if ((cacheStrategy = props.get("cacheUse")) != null && !(cacheStrategy = cacheStrategy.toLowerCase()).equals("none")) {
            this.validateCacheStrategy(cacheStrategy, null);
            field.setCacheStrategy(cacheStrategy);
            String cacheName = props.get("cacheName");
            if (cacheName != null && cacheName.length() != 0) {
                field.setCacheName(cacheName);
            }
        }
        if ((where = props.get("where")) != null && where.length() > 0) {
            field.setWhereString(where);
        }
        if ((onDelete = props.get("onDelete")) != null) {
            if (!(onDelete = onDelete.toLowerCase()).equals("none") && !field.isInverse()) {
                throw new AttributeValidationException(RB.getString((Object)this, (String)"onDeleteWithoutInverse", (Object)props.get("name"), (Object)this.cfcName));
            }
            field.setOnDelete(onDelete);
        }
    }

    private RelationField createManyToManyField(Map<String, String> props) {
        ManyToManyField field = new ManyToManyField();
        this.populateOneToManyRelation(field, props);
        if (field.getLinkTable() == null) {
            throw new PropertyAttributeMissingException("linkTable", field.getName(), this.cfcName);
        }
        String missingRowIgnored = props.get("missingRowIgnored");
        if (missingRowIgnored != null) {
            field.setMissingRowIgnored(this.toBoolean(missingRowIgnored, "missingRowIgnored", props.get("name")));
        }
        field.setForeignKeyName(props.get("foreignKeyName"));
        return field;
    }

    private String getQualifiedCFCName(String cfcName) {
        if (((String)cfcName).indexOf(46) == -1 && this.cfcpackage != null) {
            cfcName = this.cfcpackage + "." + (String)cfcName;
        }
        return cfcName;
    }

    private CollectionField createCollectionField(Map<String, String> props) {
        String cacheStrategy;
        String batchSizeStr;
        String optimisticLock;
        CollectionField field = new CollectionField();
        String fieldName = props.get("name");
        field.setName(fieldName);
        String table = props.get("table");
        if (table == null) {
            throw new PropertyAttributeMissingException("table", fieldName, this.cfcName);
        }
        table = this.getDBUnescapedName(table);
        table = this.namingStrategy.getTableName(table);
        field.setTable(table);
        field.setCatalog(props.get("catalog"));
        field.setSchema(props.get("schema"));
        String collectionType = props.get("TYPE");
        if (collectionType == null) {
            collectionType = ARRAY;
        }
        if (!collectionType.equalsIgnoreCase(ARRAY) && !collectionType.equalsIgnoreCase(STRUCT)) {
            throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidCollectionType", (Object)collectionType, (Object)fieldName, (Object)this.cfcName));
        }
        field.setCollectionType(collectionType);
        String fkcolumn = props.get("fkcolumn");
        if (fkcolumn != null) {
            fkcolumn = this.getDBUnescapedName(fkcolumn);
            fkcolumn = this.namingStrategy.getColumnName(fkcolumn);
        }
        TableMetaData joinedTableMetatdata = null;
        if (this.dbMetaData != null) {
            try {
                joinedTableMetatdata = this.dbMetaData.getTableMetaData(table, props.get("schema"), props.get("catalog"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (joinedTableMetatdata == null && this.ormSettings.getDBCreateOption(this.cfcPmd.getDatasource()) == 0) {
                throw new AttributeValidationException(RB.getString((Object)this, (String)"joinTableNotFound", (Object)table, (Object)props.get("name"), (Object)this.cfcName));
            }
            if (fkcolumn == null && joinedTableMetatdata != null) {
                Map fkMap = joinedTableMetatdata.getForeignKeys();
                for (ForeignKeyMetaData fkMetaData : fkMap.values()) {
                    if (!fkMetaData.getPktableName().equalsIgnoreCase(this.cfcPmd.getTableName())) continue;
                    fkcolumn = fkMetaData.getFkColName();
                    break;
                }
            }
        }
        if (fkcolumn == null) {
            throw new PropertyAttributeMissingException("fkcolumn", fieldName, this.cfcName);
        }
        field.setColumn(fkcolumn);
        field.setMappedBy(props.get("mappedBy"));
        String elementCol = props.get("elementColumn");
        if (elementCol == null) {
            throw new PropertyAttributeMissingException("elementColumn", fieldName, this.cfcName);
        }
        elementCol = this.getDBUnescapedName(elementCol);
        elementCol = this.namingStrategy.getColumnName(elementCol);
        field.setElementColumn(elementCol);
        String elementDataType = props.get("elementType");
        if (elementDataType == null && joinedTableMetatdata != null) {
            ColumnMetaData elementColMetaData = joinedTableMetatdata.getColumnMetaData(elementCol);
            elementDataType = this.getDataTypeFromDB(elementColMetaData);
        }
        if (elementDataType != null) {
            field.setElementDataType(elementDataType);
        }
        if (collectionType.equalsIgnoreCase(STRUCT)) {
            String structKeyColumn = props.get("structKeyColumn");
            if (structKeyColumn == null) {
                throw new PropertyAttributeMissingException("structKeyColumn", fieldName, this.cfcName);
            }
            structKeyColumn = this.getDBUnescapedName(structKeyColumn);
            structKeyColumn = this.namingStrategy.getColumnName(structKeyColumn);
            field.setStructKeyColumn(structKeyColumn);
            String structKeyDataType = props.get("structKeyType");
            if (structKeyDataType == null && joinedTableMetatdata != null) {
                ColumnMetaData structKeyColMetaData = joinedTableMetatdata.getColumnMetaData(structKeyColumn);
                structKeyDataType = this.getDataTypeFromDB(structKeyColMetaData);
            }
            if (structKeyDataType != null) {
                field.setStructKeyDataType(structKeyDataType);
            }
        }
        field.setOrderBy(props.get("orderBy"));
        String readOnly = props.get("readOnly");
        if (readOnly != null) {
            field.setReadOnly(this.toBoolean(readOnly, "readOnly", fieldName));
        }
        if ((optimisticLock = props.get("optimisticLock")) != null) {
            field.setOptimisticLock(this.toBoolean(optimisticLock, "optimisticLock", fieldName));
        }
        if ((batchSizeStr = props.get("batchSize")) != null) {
            int batchSize = this.toInt(batchSizeStr, "batchSize", fieldName);
            if (batchSize <= 0) {
                throw new AttributeValidationException(RB.getString((Object)this, (String)"invalidBatchSize", (Object)batchSize, (Object)fieldName, (Object)this.cfcName));
            }
            field.setBatchSize(batchSize);
        }
        if ((cacheStrategy = props.get("cacheUse")) != null && !(cacheStrategy = cacheStrategy.toLowerCase()).equals("none")) {
            this.validateCacheStrategy(cacheStrategy, null);
            field.setCacheStrategy(cacheStrategy);
            String cacheName = props.get("cacheName");
            if (cacheName != null && cacheName.length() != 0) {
                field.setCacheName(cacheName);
            }
        }
        return field;
    }

    private int toInt(String value, String attrName, String property) {
        try {
            return Cast._int((String)value);
        }
        catch (Exception e) {
            if (property != null) {
                throw new AttributeValidationException(RB.getString((Object)this, (String)"intConversion", (Object)attrName, (Object)value, (Object)property, (Object)this.cfcName));
            }
            throw new AttributeValidationException(RB.getString((Object)this, (String)"intConversionCFC", (Object)attrName, (Object)value, (Object)this.cfcName));
        }
    }

    private boolean toBoolean(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"));
    }

    private boolean toBoolean(String value, String attrName, String propName) {
        try {
            return Cast._boolean((String)value);
        }
        catch (Exception e) {
            if (propName != null) {
                throw new AttributeValidationException(RB.getString((Object)this, (String)"booleanConversion", (Object)attrName, (Object)value, (Object)propName, (Object)this.cfcName));
            }
            throw new AttributeValidationException(RB.getString((Object)this, (String)"booleanConversionCFC", (Object)attrName, (Object)value, (Object)this.cfcName));
        }
    }

    private String getDBUnescapedName(String name) {
        char quote = '`';
        if (name.length() <= 2) {
            return name;
        }
        if (name.charAt(0) == quote && name.charAt(name.length() - 1) == quote) {
            return name.substring(1, name.length() - 1);
        }
        return name;
    }

    private void generatePropertiesFromDB() {
        Object[] props = (Object[])this.metadata.get((Object)"properties");
        if (this.tableMetaData == null || props != null && props.length > 0) {
            this.cfcPmd = null;
            return;
        }
        if (this.cfcPmd.getDiscriminatorColumn() != null || this.cfcPmd.getDiscriminatorValue() != null) {
            this.cfcPmd = null;
            return;
        }
        Map columns = this.tableMetaData.getColumns();
        ArrayList<AttributeCollection> propList = new ArrayList<AttributeCollection>();
        for (String column : columns.keySet()) {
            AttributeCollection property = new AttributeCollection();
            property.put(Key.NAME, (Object)column);
            ColumnMetaData colMetaData = (ColumnMetaData)columns.get(column);
            String dataType = this.getDataTypeFromDB(colMetaData);
            dataType = dataType == null ? "string" : dataType;
            property.put((Object)"ormType", (Object)dataType);
            if (colMetaData.isPK()) {
                property.put((Object)"fieldType", (Object)"id");
            } else {
                property.put((Object)"fieldType", (Object)"column");
            }
            propList.add(property);
        }
        this.metadata.put((Object)"properties", (Object)propList.toArray());
    }

    private void readPropertiesFromMappedSuperClass(AttributeCollection childMetadata) {
        AttributeCollection parentMetadata = this.getParentMetadata(childMetadata);
        if (parentMetadata == null) {
            return;
        }
        String parentCFCName = (String)parentMetadata.get((Object)"NAME");
        if ("WEB-INF.cftags.component".equalsIgnoreCase(parentCFCName)) {
            return;
        }
        String mappedSuperClassStr = (String)parentMetadata.get((Object)"mappedSuperClass");
        if (!this.toBoolean(mappedSuperClassStr)) {
            this.readPropertiesFromMappedSuperClass(parentMetadata);
            return;
        }
        Object[] parentPropertiesArray = (Object[])parentMetadata.get((Object)"properties");
        if (parentPropertiesArray == null || parentPropertiesArray.length == 0) {
            this.readPropertiesFromMappedSuperClass(parentMetadata);
            return;
        }
        Object[] propsArray = (Object[])this.metadata.get((Object)"properties");
        LinkedList<Map> mergedPropList = new LinkedList<Map>();
        CaseInsensitiveMap childPropertyMap = new CaseInsensitiveMap();
        if (propsArray != null && propsArray.length > 0) {
            for (int i = 0; i < propsArray.length; ++i) {
                Map properties = (Map)propsArray[i];
                String propsName = (String)properties.get("name");
                mergedPropList.add(properties);
                childPropertyMap.put(propsName, properties);
            }
        }
        int parentPropertyIndex = 0;
        for (int i = 0; i < parentPropertiesArray.length; ++i) {
            Map parentProperties = (Map)parentPropertiesArray[i];
            String propsName = (String)parentProperties.get("name");
            String persistentStr = (String)parentProperties.get("persistent");
            if (persistentStr != null && !"true".equalsIgnoreCase(persistentStr) && !"yes".equalsIgnoreCase(persistentStr) || childPropertyMap.containsKey(propsName)) continue;
            mergedPropList.add(parentPropertyIndex++, parentProperties);
        }
        Object[] mergedPropsArray = mergedPropList.toArray();
        if (!this.metadataCloned) {
            try {
                this.metadata = (AttributeCollection)this.metadata.clone();
                this.metadataCloned = true;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        this.metadata.put(Key.PROPERTIES, (Object)mergedPropsArray);
        this.readPropertiesFromMappedSuperClass(parentMetadata);
    }

    private AttributeCollection getParentMetadata(AttributeCollection metadata) {
        Object parentMetaDataObj = metadata.get((Object)EXTENDS);
        if (parentMetaDataObj == null) {
            return null;
        }
        if (parentMetaDataObj instanceof AttributeCollection) {
            return (AttributeCollection)parentMetaDataObj;
        }
        String parentCFCName = this.getQualifiedCFCName((String)parentMetaDataObj);
        try {
            TemplateProxy parentCFC = TemplateProxyFactory.createTemplateProxyForMetaData((String)parentCFCName, (NeoPageContext)FusionContext.getCurrent().pageContext, null);
            return (AttributeCollection)parentCFC.getRuntimeMetadata();
        }
        catch (Throwable th) {
            throw new CFCLoadException(th, RB.getString((Object)this, (String)"parentCFCLoadError", (Object)parentCFCName, (Object)this.cfcName));
        }
    }

    static {
        cascadeOptions.add("delete");
        cascadeOptions.add("save-update");
        cascadeOptions.add("refresh");
        cascadeOptions.add("delete-orphan");
        cascadeOptions.add("merge");
        cascadeOptions.add("all");
        cascadeOptions.add("all-delete-orphan");
        cacheStrategies.add("read-only");
        cacheStrategies.add("nonstrict-read-write");
        cacheStrategies.add("read-write");
        cacheStrategies.add("transactional");
        numericTypes.add("byte");
        numericTypes.add("short");
        numericTypes.add("int");
        numericTypes.add("integer");
        numericTypes.add("long");
        numericTypes.add("float");
        numericTypes.add("double");
    }

    public static class AttributeValidationException
    extends RuntimeException {
        public AttributeValidationException(String message) {
            super(message);
        }
    }

    public static class CFCLoadException
    extends ApplicationException {
        private String msg;

        public CFCLoadException(Throwable ex, String msg) {
            super(ex);
            this.msg = msg;
        }

        public String getMessage() {
            return this.msg;
        }

        public String getDetail() {
            return this.rootCause.getMessage();
        }
    }

    public static class PropertyAttributeMissingException
    extends NeoException {
        public String attributeName;
        public String propertyName;
        public String cfcName;

        public PropertyAttributeMissingException(String attributeName, String propertyName, String cfcName) {
            this.attributeName = attributeName;
            this.propertyName = propertyName;
            this.cfcName = cfcName;
        }
    }
}

