/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.EmptyListValidator;
import coldfusion.gcp.storage.request.StorageBucketGetOptionBuilder;
import com.google.cloud.storage.Storage;
import java.util.Collections;

public enum StorageBucketGetOptionConsumer {
    INSTANCE;

    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<StorageBucketGetOptionBuilder> consumerMap = new ConsumerMap();

    private StorageBucketGetOptionConsumer() {
        this.consumerMap.put((Object)"fields", new ConsumerValidator((bucketGetOptionBuilder, value) -> {
            String[] fields = this.cast.getStringArrayProperty(value);
            Storage.BucketField[] bucketField = new Storage.BucketField[fields.length];
            for (int i = 0; i < bucketField.length; ++i) {
                bucketField[i] = Storage.BucketField.valueOf((String)fields[i]);
            }
            bucketGetOptionBuilder.setFields(bucketField);
        }, Collections.singletonList(new EmptyListValidator("fields"))));
        this.consumerMap.put((Object)"metaGenerationMatch", new ConsumerValidator((bucketGetOptionBuilder, value) -> {
            Long metagenerationMatch = this.cast.getLongProperty(value);
            bucketGetOptionBuilder.setMetagenerationMatch(metagenerationMatch);
        }, Collections.emptyList()));
        this.consumerMap.put((Object)"metaGenerationNotMatch", new ConsumerValidator((bucketGetOptionBuilder, value) -> {
            Long metagenerationNotMatch = this.cast.getLongProperty(value);
            bucketGetOptionBuilder.setMetagenerationNotMatch(metagenerationNotMatch);
        }, Collections.emptyList()));
        this.consumerMap.put((Object)"userProject", new ConsumerValidator((bucketGetOptionBuilder, value) -> {
            String userProject = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)userProject, (String)"userProject");
            bucketGetOptionBuilder.setUserProject(userProject);
        }, Collections.emptyList()));
    }

    public ConsumerMap<StorageBucketGetOptionBuilder> getConsumerMap() {
        return this.consumerMap;
    }
}

