/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.gcp.storage.util.Validator;
import com.google.cloud.storage.BucketInfo;
import java.util.Collections;

public class IamConfigurationConsumer
extends ConsumerMap<BucketInfo.IamConfiguration.Builder> {
    private static final long serialVersionUID = -5112713971995146790L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static IamConfigurationConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IamConfigurationConsumer getInstance() {
        if (instance != null) return instance;
        Class<IamConfigurationConsumer> clazz = IamConfigurationConsumer.class;
        synchronized (IamConfigurationConsumer.class) {
            instance = new IamConfigurationConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private IamConfigurationConsumer() {
        this.put("isUniformBucketLevelAccessEnabled", new ConsumerValidator((iamConfigBuilder, val) -> {
            boolean isUniformBucketLevelAccessEnabled = Validator.getBooleanProperty(val, "isUniformBucketLevelAccessEnabled");
            iamConfigBuilder.setIsUniformBucketLevelAccessEnabled(Boolean.valueOf(isUniformBucketLevelAccessEnabled));
        }, Collections.emptyList()));
        this.put("publicAccessPrevention", new ConsumerValidator((iamConfigBuilder, val) -> {
            String publicAccessPrevention = this.cast.getStringProperty(val);
            ValidationUtil.validNonEmptyString((String)publicAccessPrevention, (String)"publicAccessPrevention");
            iamConfigBuilder.setPublicAccessPrevention(BucketInfo.PublicAccessPrevention.valueOf((String)publicAccessPrevention));
        }, Collections.emptyList()));
    }
}

