/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.icc.IccReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.photoshop.PhotoshopDirectory;
import com.drew.metadata.xmp.XmpReader;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotoshopReader
implements JpegSegmentMetadataReader {
    @NotNull
    private static final String JPEG_SEGMENT_PREAMBLE = "Photoshop 3.0";

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APPD);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> iterable, @NotNull Metadata metadata, @NotNull JpegSegmentType jpegSegmentType) {
        int n = JPEG_SEGMENT_PREAMBLE.length();
        for (byte[] byArray : iterable) {
            if (byArray.length < n + 1 || !JPEG_SEGMENT_PREAMBLE.equals(new String(byArray, 0, n))) continue;
            this.extract(new SequentialByteArrayReader(byArray, n + 1), byArray.length - n - 1, metadata);
        }
    }

    public void extract(@NotNull SequentialReader sequentialReader, int n, @NotNull Metadata metadata) {
        PhotoshopDirectory photoshopDirectory = new PhotoshopDirectory();
        metadata.addDirectory(photoshopDirectory);
        int n2 = 0;
        while (n2 < n) {
            try {
                String string = sequentialReader.getString(4);
                if (!string.equals("8BIM")) {
                    throw new ImageProcessingException("Expecting 8BIM marker");
                }
                n2 += 4;
                int n3 = sequentialReader.getUInt16();
                n2 += 2;
                short s = sequentialReader.getUInt8();
                if (s < 0 || s + ++n2 > n) {
                    throw new ImageProcessingException("Invalid string length");
                }
                sequentialReader.skip(s);
                if ((n2 += s) % 2 != 0) {
                    sequentialReader.skip(1L);
                    ++n2;
                }
                int n4 = sequentialReader.getInt32();
                n2 += 4;
                byte[] byArray = sequentialReader.getBytes(n4);
                if ((n2 += n4) % 2 != 0) {
                    sequentialReader.skip(1L);
                    ++n2;
                }
                if (n3 == 1028) {
                    new IptcReader().extract(new SequentialByteArrayReader(byArray), metadata, byArray.length);
                } else if (n3 == 1039) {
                    new IccReader().extract(new ByteArrayReader(byArray), metadata);
                } else if (n3 == 1058 || n3 == 1059) {
                    new ExifReader().extract(new ByteArrayReader(byArray), metadata);
                } else if (n3 == 1060) {
                    new XmpReader().extract(byArray, metadata);
                } else {
                    photoshopDirectory.setByteArray(n3, byArray);
                }
                if (n3 < 4000 || n3 > 4999) continue;
                PhotoshopDirectory._tagNameMap.put(n3, String.format("Plug-in %d Data", n3 - 4000 + 1));
            }
            catch (Exception exception) {
                photoshopDirectory.addError(exception.getMessage());
                return;
            }
        }
    }
}

