/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.handlers;

import coldfusion.cloud.Executor;
import coldfusion.cloud.gcp.pubsub.exception.PubSubApiException;
import coldfusion.cloud.gcp.pubsub.exception.PubSubException;
import coldfusion.cloud.gcp.pubsub.handlers.AbstractSubscriberMessageHandler;
import coldfusion.cloud.gcp.pubsub.handlers.PubSubSubscriberMessageReceiver;
import coldfusion.cloud.gcp.pubsub.impl.PubSubClientImpl;
import coldfusion.cloud.gcp.pubsub.model.AckReplyConsumerWrapper;
import coldfusion.cloud.gcp.pubsub.model.PubSubMessage;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.filter.FusionContext;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.Closure;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.async.CallableUDFMethod;
import coldfusion.util.RB;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.pubsub.v1.PubsubMessage;

public class SubscriberMessageHandler
extends AbstractSubscriberMessageHandler<MessageReceiver> {
    public SubscriberMessageHandler(final Closure onSuccess, final Closure onError, FusionContext fcontext, final NeoPageContext pageContext, final RequestMonitorData rmd) {
        super(fcontext, pageContext, rmd);
        this.receiver = new PubSubSubscriberMessageReceiver(){

            public void receiveMessage(PubsubMessage message, AckReplyConsumer ackReplyConsumer) {
                this.onSuccess(message, ackReplyConsumer);
            }

            @Override
            public void onSuccess(PubsubMessage message, AckReplyConsumer ackReplyConsumer) {
                try {
                    Object[] args = new Object[]{PubSubServiceUtils.deserialize(new PubSubMessage(message)), new AckReplyConsumerWrapper(ackReplyConsumer)};
                    CallableUDFMethod callable = new CallableUDFMethod((UDFMethod)onSuccess, args, SubscriberMessageHandler.this.fusionContext, pageContext, rmd);
                    Executor.getInstance().submit(callable);
                }
                catch (Throwable ex) {
                    this.onError(message, ex);
                }
            }

            @Override
            public void onError(PubsubMessage message, Throwable throwable) {
                try {
                    Object[] args = new Object[]{PubSubServiceUtils.deserialize(new PubSubMessage(message)), throwable};
                    CallableUDFMethod callable = new CallableUDFMethod((UDFMethod)onError, args, SubscriberMessageHandler.this.fusionContext, pageContext, rmd);
                    Executor.getInstance().submit(callable);
                }
                catch (Throwable e) {
                    if (throwable instanceof ApiException) {
                        ApiException apiException = (ApiException)throwable;
                        throw new PubSubApiException(apiException.getMessage(), apiException);
                    }
                    throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIBER_MESSAGE_HANDLER_ERROR"), e);
                }
            }
        };
    }

    @Override
    public MessageReceiver getMessageHandler() {
        return (MessageReceiver)this.receiver;
    }
}

