/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.request.TopicMetadataSchemaSettingsRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.GenericEnumValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.cloud.validator.Validator;
import com.google.pubsub.v1.Encoding;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum TopicMetadataSchemaSettingsRequestConsumer {
    INSTANCE;

    private static final long serialVersionUID = 542814826770259604L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<TopicMetadataSchemaSettingsRequest> consumerMap = new ConsumerMap();
    private final List<Validator> validators = Arrays.asList(NotNullValidator.INSTANCE, new GenericEnumValidator(Encoding.class, "schemaEncoding"));

    private TopicMetadataSchemaSettingsRequestConsumer() {
        this.consumerMap.put((Object)"schemaName", new ConsumerValidator((schemaSettingsRequest, value) -> schemaSettingsRequest.setSchemaName(this.cast.getStringProperty(value)), Collections.singletonList(NotNullValidator.INSTANCE)));
        this.consumerMap.put((Object)"schemaEncoding", new ConsumerValidator((schemaSettingsRequest, value) -> {
            String schemaEncoding = PubSubServiceUtils.toUppercase(this.cast.getStringProperty(value));
            schemaSettingsRequest.setSchemaEncoding(Encoding.valueOf((String)schemaEncoding));
        }, this.validators));
    }

    public ConsumerMap<TopicMetadataSchemaSettingsRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

