/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.consumer.TopicMetadataSchemaSettingsRequestConsumer;
import coldfusion.cloud.gcp.pubsub.request.TopicMetadataRequest;
import coldfusion.cloud.gcp.pubsub.request.TopicMetadataSchemaSettingsRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.gcp.validator.GCPLabelValidator;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.CFStructValidator;
import coldfusion.cloud.validator.EmptyListValidator;
import coldfusion.cloud.validator.NonEmptyStringValidator;
import com.google.protobuf.util.Durations;
import com.google.pubsub.v1.MessageStoragePolicy;
import java.util.Collections;
import java.util.List;

public enum TopicMetadataRequestConsumer {
    INSTANCE;

    private static final long serialVersionUID = -2091599165301668162L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<TopicMetadataRequest> consumerMap = new ConsumerMap();

    private TopicMetadataRequestConsumer() {
        this.consumerMap.put((Object)"kmsKeyName", new ConsumerValidator((topicMetadataRequest, value) -> topicMetadataRequest.setKmsKeyName(this.cast.getStringProperty(value)), Collections.singletonList(NonEmptyStringValidator.INSTANCE)));
        this.consumerMap.put((Object)"messageRetentionDuration", new ConsumerValidator((topicMetadataRequest, value) -> {
            long seconds = this.cast.getDurationProperty(value, "messageRetentionDuration").getSeconds();
            PubSubServiceUtils.validateDurationRange(seconds, 600L, 2678400L, "messageRetentionDuration", (String)value, "10M", "744h");
            topicMetadataRequest.setMessageRetentionDuration(Durations.fromSeconds((long)seconds));
        }, Collections.emptyList()));
        this.consumerMap.put((Object)"messageStoragePolicy", new ConsumerValidator((topicMetadataRequest, values) -> {
            List regionsList = this.cast.getStringListProperty(values);
            MessageStoragePolicy messageStoragePolicy = MessageStoragePolicy.newBuilder().addAllAllowedPersistenceRegions((Iterable)regionsList).build();
            topicMetadataRequest.setMessageStoragePolicy(messageStoragePolicy);
        }, Collections.singletonList(new EmptyListValidator("messageStoragePolicy"))));
        this.consumerMap.put((Object)"schemaSettings", new ConsumerValidator((topicMetadataRequest, value) -> {
            TopicMetadataSchemaSettingsRequest schemaSettingsRequest = new TopicMetadataSchemaSettingsRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)schemaSettingsRequest, this.cast.getMapProperty(value, "schemaSettings"), TopicMetadataSchemaSettingsRequestConsumer.INSTANCE.getConsumerMap());
            topicMetadataRequest.setSchemaSettings(schemaSettingsRequest);
        }, Collections.singletonList(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"labels", new ConsumerValidator((topicMetadataRequest, value) -> topicMetadataRequest.setLabels(this.cast.getGCPLabelsMapProperty(value, "labels")), Collections.singletonList(GCPLabelValidator.INSTANCE)));
    }

    public ConsumerMap<TopicMetadataRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

