/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.consumer.FlowControlSettingsRequestConsumer;
import coldfusion.cloud.gcp.pubsub.request.FlowControlSettingsRequest;
import coldfusion.cloud.gcp.pubsub.request.PublisherBatchingSettingsRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.CFBooleanValidator;
import coldfusion.cloud.validator.CFNonNegativeLongValidator;
import coldfusion.cloud.validator.CFStructValidator;
import java.time.Duration;
import java.util.Collections;

public enum PublisherBatchingSettingsConsumer {
    INSTANCE;

    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<PublisherBatchingSettingsRequest> consumerMap = new ConsumerMap();

    private PublisherBatchingSettingsConsumer() {
        this.consumerMap.put((Object)"delayThreshold", new ConsumerValidator((batchingSettingsBuilder, value) -> {
            if (!PubSubServiceUtils.isNullOrEmpty(value)) {
                Duration duration = this.cast.getDurationProperty(value, "delayThreshold");
                batchingSettingsBuilder.setDelayThreshold(duration);
            }
        }, Collections.emptyList()));
        this.consumerMap.put((Object)"elementCountThreshold", new ConsumerValidator((batchingSettingsBuilder, value) -> {
            if (!PubSubServiceUtils.isNullOrEmpty(value)) {
                batchingSettingsBuilder.setElementCountThreshold(this.cast.getLongProperty(value));
            }
        }, Collections.singletonList(new CFNonNegativeLongValidator("elementCountThreshold"))));
        this.consumerMap.put((Object)"flowControlSettings", new ConsumerValidator((batchingSettingsBuilder, value) -> {
            FlowControlSettingsRequest flowControlSettings = batchingSettingsBuilder.getFlowControlSettings();
            ValidatorFiller.INSTANCE.fillObject((Object)flowControlSettings, this.cast.getMapProperty(value, "flowControlSettings"), FlowControlSettingsRequestConsumer.INSTANCE.getConsumerMap());
        }, Collections.singletonList(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"enable", new ConsumerValidator((batchingSettingsBuilder, value) -> batchingSettingsBuilder.setEnabled(this.cast.getBooleanProperty(value)), Collections.singletonList(CFBooleanValidator.INSTANCE)));
        this.consumerMap.put((Object)"requestByteThreshold", new ConsumerValidator((batchingSettingsBuilder, value) -> {
            if (!PubSubServiceUtils.isNullOrEmpty(value)) {
                batchingSettingsBuilder.setRequestByteThreshold(this.cast.getLongProperty(value));
            }
        }, Collections.singletonList(new CFNonNegativeLongValidator("requestByteThreshold"))));
    }

    public ConsumerMap<PublisherBatchingSettingsRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

