/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.sharepoint;

import coldfusion.tagext.net.sharepoint.SharepointException;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public class SharepointExceptions {
    private static SharepointExceptions attribExceptions = new SharepointExceptions();

    public static void throwNTLMDomainNotSpecifiedException() {
        throw attribExceptions.new NTLMDomainNotSpecifiedException();
    }

    public static void throwBasicAuthAttributeException() {
        throw attribExceptions.new InvalidBasicAuthAttributeException();
    }

    public static void throwInvalidAuthTypeException() {
        throw attribExceptions.new InvalidAuthTypeException();
    }

    public static void throwInvalidCredentialsException() {
        throw attribExceptions.new InvalidCredentialsException();
    }

    public static void throwInvalidLoginKeysException() {
        throw attribExceptions.new InvalidLoginKeysException();
    }

    public static void throwUnsupportedActionException(String action) {
        SharepointExceptions sharepointExceptions = attribExceptions;
        Objects.requireNonNull(sharepointExceptions);
        throw sharepointExceptions.new UnsupportedActionException(action);
    }

    public static void throwInvalidObjectInStructException() {
        throw attribExceptions.new InvalidObjectInStructException();
    }

    public static void throwUnsupportedRespFormatException() {
        throw attribExceptions.new UnsupportedResponseFormatException();
    }

    public static void throwInvalidInputTypeException(String param, String type) {
        SharepointExceptions sharepointExceptions = attribExceptions;
        Objects.requireNonNull(sharepointExceptions);
        throw sharepointExceptions.new InvalidInputTypeException(param, type);
    }

    public static void throwInvalidInputTypeException(String param, String type, Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        SharepointExceptions sharepointExceptions = attribExceptions;
        Objects.requireNonNull(sharepointExceptions);
        throw sharepointExceptions.new InvalidInputTypeException(param, type, e);
    }

    public static void throwCorruptDocumentException(String msg) {
        SharepointExceptions sharepointExceptions = attribExceptions;
        Objects.requireNonNull(sharepointExceptions);
        throw sharepointExceptions.new CorruptDocumentException(msg);
    }

    public static void throwGenericSharepointException(String className, String msg) {
        SharepointExceptions sharepointExceptions = attribExceptions;
        Objects.requireNonNull(sharepointExceptions);
        throw sharepointExceptions.new GenericSharepointException(className, msg);
    }

    public static void throwGenericSharepointException(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        SharepointExceptions sharepointExceptions = attribExceptions;
        Objects.requireNonNull(sharepointExceptions);
        throw sharepointExceptions.new GenericSharepointException(e);
    }

    public static void throwInvalidParamsException(String[] params, String action) {
        SharepointExceptions sharepointExceptions = attribExceptions;
        Objects.requireNonNull(sharepointExceptions);
        throw sharepointExceptions.new InvalidParamsException(params, action);
    }

    public static void throwExcessParamsException(String action) {
        SharepointExceptions sharepointExceptions = attribExceptions;
        Objects.requireNonNull(sharepointExceptions);
        throw sharepointExceptions.new ExcessParamsException(action);
    }

    public static void throwUnimplementedActionException() {
        throw attribExceptions.new UnimplementedActionException();
    }

    public class NTLMDomainNotSpecifiedException
    extends SharepointException {
    }

    public class InvalidBasicAuthAttributeException
    extends SharepointException {
    }

    public class InvalidAuthTypeException
    extends SharepointException {
    }

    public class InvalidCredentialsException
    extends SharepointException {
    }

    public class InvalidLoginKeysException
    extends SharepointException {
    }

    public class UnsupportedActionException
    extends SharepointException {
        public String action;

        public UnsupportedActionException(String action) {
            this.action = action;
        }
    }

    public class InvalidObjectInStructException
    extends SharepointException {
    }

    public class UnsupportedResponseFormatException
    extends SharepointException {
    }

    public class InvalidInputTypeException
    extends SharepointException {
        public String param;
        public String type;

        public InvalidInputTypeException(String param, String type) {
            this.type = type;
            this.param = param;
        }

        public InvalidInputTypeException(String param, String type, Throwable e) {
            super(e);
            this.type = type;
            this.param = param;
        }
    }

    public class CorruptDocumentException
    extends SharepointException {
        public String errormessage;

        public CorruptDocumentException(String msg) {
            this.errormessage = msg;
        }
    }

    public class GenericSharepointException
    extends SharepointException {
        public String errormessage;

        public GenericSharepointException(String className, String msg) {
            if (msg == null) {
                msg = "";
            }
            this.errormessage = className + " : " + msg;
        }

        public GenericSharepointException(Throwable e) {
            super(e);
            this.errormessage = e.getClass().getName();
            String msg = e.getMessage();
            if (msg != null) {
                this.errormessage = this.errormessage + " : " + msg;
            }
        }
    }

    public class InvalidParamsException
    extends SharepointException {
        public String paramNames;
        public String action;

        public InvalidParamsException(String[] params, String action) {
            StringBuffer paramStr = new StringBuffer();
            for (String str : params) {
                paramStr = paramStr.append(str).append(",");
            }
            this.paramNames = paramStr.substring(0, paramStr.length() - 1);
            this.action = action;
        }
    }

    public class ExcessParamsException
    extends SharepointException {
        public String action;

        public ExcessParamsException(String action) {
            this.action = action;
        }
    }

    public class UnimplementedActionException
    extends SharepointException {
    }
}

