/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopSpan;
import io.opentracing.noop.NoopTracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.solr.common.SolrException;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.servlet.ExceptionWhileTracing;
import org.apache.solr.servlet.PathExcluder;
import org.apache.solr.servlet.RateLimitManager;
import org.apache.solr.servlet.RequestRateLimiter;
import org.apache.solr.servlet.ServletInputStreamWrapper;
import org.apache.solr.servlet.ServletOutputStreamWrapper;
import org.apache.solr.servlet.SolrAuthenticationException;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.apache.solr.util.tracing.HttpServletCarrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServletUtils {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static String CLOSE_STREAM_MSG = "Attempted close of http request or response stream - in general you should not do this, you may spoil connection reuse and possibly disrupt a client. If you must close without actually needing to close, use a CloseShield*Stream. Closing or flushing the response stream commits the response and prevents us from modifying it. Closing the request stream prevents us from guaranteeing ourselves that streams are fully read for proper connection reuse.Let the container manage the lifecycle of these streams when possible.";

    private ServletUtils() {
    }

    public static String getPathAfterContext(HttpServletRequest request) {
        return request.getServletPath() + (request.getPathInfo() != null ? request.getPathInfo() : "");
    }

    public static HttpServletRequest closeShield(HttpServletRequest request, boolean retry) {
        if (!retry) {
            return new HttpServletRequestWrapper(request){

                public ServletInputStream getInputStream() throws IOException {
                    return new ServletInputStreamWrapper(super.getInputStream()){

                        @Override
                        public void close() {
                            assert (!Thread.currentThread().getStackTrace()[2].getClassName().matches("org\\.apache\\.(?:solr|lucene).*")) : CLOSE_STREAM_MSG;
                            this.stream = ClosedServletInputStream.CLOSED_SERVLET_INPUT_STREAM;
                        }
                    };
                }
            };
        }
        return request;
    }

    public static HttpServletResponse closeShield(HttpServletResponse response, boolean retry) {
        if (!retry) {
            return new HttpServletResponseWrapper(response){

                public ServletOutputStream getOutputStream() throws IOException {
                    return new ServletOutputStreamWrapper(super.getOutputStream()){

                        @Override
                        public void close() {
                            assert (!Thread.currentThread().getStackTrace()[2].getClassName().matches("org\\.apache\\.(?:solr|lucene).*")) : CLOSE_STREAM_MSG;
                            this.stream = ClosedServletOutputStream.CLOSED_SERVLET_OUTPUT_STREAM;
                        }
                    };
                }
            };
        }
        return response;
    }

    static boolean excludedPath(List<Pattern> excludePatterns, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestPath = ServletUtils.getPathAfterContext(request);
        if (excludePatterns != null) {
            for (Pattern p : excludePatterns) {
                Matcher matcher = p.matcher(requestPath);
                if (!matcher.lookingAt()) continue;
                if (chain != null) {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                return true;
            }
        }
        return false;
    }

    static boolean excludedPath(List<Pattern> excludePatterns, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return ServletUtils.excludedPath(excludePatterns, request, response, null);
    }

    static void configExcludes(PathExcluder excluder, String patternConfig) {
        if (patternConfig != null) {
            String[] excludeArray = patternConfig.split(",");
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            excluder.setExcludePatterns(patterns);
            for (String element : excludeArray) {
                patterns.add(Pattern.compile(element));
            }
        }
    }

    static void rateLimitRequest(RateLimitManager rateLimitManager, HttpServletRequest request, HttpServletResponse response, Runnable limitedExecution) throws ServletException, IOException {
        try (RequestRateLimiter.SlotReservation accepted = rateLimitManager.handleRequest(request);){
            if (accepted == null) {
                response.sendError(SolrException.ErrorCode.TOO_MANY_REQUESTS.code, "Too many requests for this request type. Please try after some time or increase the quota for this request type");
                return;
            }
            ServletUtils.traceHttpRequestExecution2(request, response, limitedExecution);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e.getMessage());
        }
    }

    private static void traceHttpRequestExecution2(HttpServletRequest request, HttpServletResponse response, Runnable tracedExecution) throws ServletException, IOException {
        Tracer tracer = ServletUtils.getTracer(request);
        Span span = ServletUtils.buildSpan(tracer, request);
        Thread currentThread = Thread.currentThread();
        String oldThreadName = currentThread.getName();
        request.setAttribute(SolrDispatchFilter.ATTR_TRACING_SPAN, (Object)span);
        try (Scope scope = tracer.scopeManager().activate(span);){
            assert (scope != null);
            MDCLoggingContext.setTracerId(span.context().toTraceId());
            String traceId = MDCLoggingContext.getTraceId();
            if (traceId != null) {
                currentThread.setName(oldThreadName + "-" + traceId);
            }
            tracedExecution.run();
        }
        catch (ExceptionWhileTracing e) {
            if (e.e instanceof SolrAuthenticationException) {
                return;
            }
            if (e.e instanceof ServletException) {
                throw (ServletException)e.e;
            }
            if (e.e instanceof IOException) {
                throw (IOException)e.e;
            }
            if (e.e instanceof RuntimeException) {
                throw (RuntimeException)e.e;
            }
            throw new RuntimeException(e.e);
        }
        finally {
            currentThread.setName(oldThreadName);
            span.setTag((Tag)Tags.HTTP_STATUS, (Object)response.getStatus());
            span.finish();
        }
    }

    private static Tracer getTracer(HttpServletRequest req) {
        return (Tracer)req.getAttribute(SolrDispatchFilter.ATTR_TRACING_TRACER);
    }

    protected static Span buildSpan(Tracer tracer, HttpServletRequest request) {
        if (tracer instanceof NoopTracer) {
            return NoopSpan.INSTANCE;
        }
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan("http.request").asChildOf(tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new HttpServletCarrier(request))).withTag((Tag)Tags.SPAN_KIND, (Object)"server").withTag((Tag)Tags.HTTP_METHOD, (Object)request.getMethod()).withTag((Tag)Tags.HTTP_URL, (Object)request.getRequestURL().toString());
        if (request.getQueryString() != null) {
            spanBuilder.withTag("http.params", request.getQueryString());
        }
        spanBuilder.withTag((Tag)Tags.DB_TYPE, (Object)"solr");
        return spanBuilder.start();
    }

    static void consumeInputFully(HttpServletRequest req, HttpServletResponse response) {
        try {
            ServletInputStream is = req.getInputStream();
            while (!is.isFinished() && is.read() != -1) {
            }
        }
        catch (IOException e) {
            if (req.getHeader("Expect") != null && response.isCommitted()) {
                log.debug("No input stream to consume from client");
            }
            log.info("Could not consume full client request", (Throwable)e);
        }
    }

    public static class ClosedServletOutputStream
    extends ServletOutputStream {
        public static final ClosedServletOutputStream CLOSED_SERVLET_OUTPUT_STREAM = new ClosedServletOutputStream();

        public void write(int b) throws IOException {
            throw new IOException("write(" + b + ") failed: stream is closed");
        }

        public void flush() throws IOException {
            throw new IOException("flush() failed: stream is closed");
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener arg0) {
            throw new RuntimeException("setWriteListener() failed: stream is closed");
        }
    }

    public static class ClosedServletInputStream
    extends ServletInputStream {
        public static final ClosedServletInputStream CLOSED_SERVLET_INPUT_STREAM = new ClosedServletInputStream();

        public int read() {
            return -1;
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return false;
        }

        public void setReadListener(ReadListener arg0) {
        }
    }
}

