/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.solr.client.solrj.io.graph.Traversal;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.handler.GraphHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;

public class GraphMLResponseWriter
implements QueryResponseWriter {
    @Override
    public String getContentType(SolrQueryRequest req, SolrQueryResponse res) {
        return "application/xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void write(Writer writer, SolrQueryRequest req, SolrQueryResponse res) throws IOException {
        e1 = res.getException();
        if (e1 != null) {
            e1.printStackTrace(new PrintWriter(writer));
            return;
        }
        stream = (TupleStream)req.getContext().get("stream");
        if (stream instanceof GraphHandler.DummyErrorStream) {
            d = (GraphHandler.DummyErrorStream)stream;
            e = d.getException();
            e.printStackTrace(new PrintWriter(writer));
            return;
        }
        traversal = (Traversal)req.getContext().get("traversal");
        printWriter = new PrintWriter(writer);
        try {
            stream.open();
            tuple = null;
            edgeCount = 0;
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\" ");
            printWriter.println("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
            printWriter.print("xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns ");
            printWriter.println("http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">");
            printWriter.println("<graph id=\"G\" edgedefault=\"directed\">");
            block3: while (true) {
                tuple = stream.read();
                if (tuple.EOF) break;
                id = tuple.getString("node");
                if (traversal.isMultiCollection()) {
                    id = tuple.getString("collection") + "." + (String)id;
                }
                printWriter.write("<node id=\"" + this.xmlEscape((String)id) + "\"");
                outfields = new ArrayList<String>();
                for (String key : tuple.getFields().keySet()) {
                    if (key.equals("node") || key.equals("ancestors") || key.equals("collection")) continue;
                    outfields.add(key);
                }
                if (outfields.size() > 0) {
                    printWriter.println(">");
                    for (String nodeAttribute : outfields) {
                        o = tuple.get(nodeAttribute);
                        if (o == null) continue;
                        printWriter.println("<data key=\"" + this.xmlEscape(nodeAttribute) + "\">" + this.xmlEscape(o.toString()) + "</data>");
                    }
                    printWriter.println("</node>");
                } else {
                    printWriter.println("/>");
                }
                if ((ancestors = tuple.getStrings("ancestors")) == null) continue;
                var13_15 = ancestors.iterator();
                while (true) {
                    if (var13_15.hasNext()) ** break;
                    continue block3;
                    ancestor = (String)var13_15.next();
                    printWriter.write("<edge id=\"" + ++edgeCount + "\" ");
                    printWriter.write(" source=\"" + this.xmlEscape(ancestor) + "\" ");
                    printWriter.println(" target=\"" + this.xmlEscape((String)id) + "\"/>");
                }
                break;
            }
            printWriter.write("</graph></graphml>");
        }
        finally {
            stream.close();
        }
    }

    private String xmlEscape(String s) {
        if (s.contains(">")) {
            s = s.replace(">", "&gt;");
        }
        if (s.contains("<")) {
            s = s.replace("<", "&lt;");
        }
        if (s.contains("\"")) {
            s = s.replace("\"", "&quot;");
        }
        if (s.contains("'")) {
            s = s.replace("'", "&apos;");
        }
        if (s.contains("&")) {
            s = s.replace("&", "&amp;");
        }
        return s;
    }
}

