/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.logging.log4j2;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.message.Message;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.logging.CircularList;
import org.apache.solr.logging.ListenerConfig;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.logging.LoggerInfo;

@SuppressForbidden(reason="class is specific to log4j2")
public class Log4j2Watcher
extends LogWatcher<LogEvent> {
    private static final String LOG4J2_WATCHER_APPENDER = "Log4j2WatcherAppender";
    public static final Logger log = LogManager.getLogger(Log4j2Watcher.class);
    protected Log4j2Appender appender = null;

    @Override
    public String getName() {
        return "Log4j2";
    }

    @Override
    public List<String> getAllLevels() {
        return Arrays.asList(Level.ALL.toString(), Level.TRACE.toString(), Level.DEBUG.toString(), Level.INFO.toString(), Level.WARN.toString(), Level.ERROR.toString(), Level.FATAL.toString(), Level.OFF.toString());
    }

    @Override
    public void setLogLevel(String loggerName, String level) {
        assert (loggerName != null);
        assert (level != null);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = this.getLoggerConfig(ctx, loggerName);
        assert (loggerConfig != null);
        boolean madeChanges = false;
        Level _level = null;
        if (level != null && !"unset".equals(level) && !"null".equals(level)) {
            try {
                _level = Level.valueOf((String)level);
            }
            catch (IllegalArgumentException iae) {
                log.error("{} is not a valid log level! Valid values are: {}", (Object)level, this.getAllLevels());
            }
        }
        if (loggerName.equals(loggerConfig.getName()) || this.isRootLogger(loggerName)) {
            loggerConfig.setLevel(_level);
            madeChanges = true;
        } else {
            LoggerConfig explicitConfig = new LoggerConfig(loggerName, _level, true);
            explicitConfig.setParent(loggerConfig);
            config.addLogger(loggerName, explicitConfig);
            madeChanges = true;
        }
        if (madeChanges) {
            ctx.updateLoggers();
            if (log.isInfoEnabled()) {
                log.info("Setting log level to '{}' for logger: {}", (Object)_level, (Object)loggerName);
            }
        }
    }

    protected boolean isRootLogger(String loggerName) {
        return "root".equals(loggerName);
    }

    protected LoggerConfig getLoggerConfig(LoggerContext ctx, String loggerName) {
        Configuration config = ctx.getConfiguration();
        return this.isRootLogger(loggerName) ? config.getLoggerConfig("") : config.getLoggerConfig(loggerName);
    }

    @Override
    public Collection<LoggerInfo> getAllLoggers() {
        String name;
        Logger root = LogManager.getRootLogger();
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        LoggerConfig rootConfig = ctx.getConfiguration().getRootLogger();
        HashMap<String, Log4j2Info> map = new HashMap<String, Log4j2Info>(ctx.getLoggers().size());
        map.put("root", new Log4j2Info("root", root.getLevel(), null != rootConfig.getExplicitLevel()));
        Map configs = ctx.getConfiguration().getLoggers();
        for (Map.Entry config : configs.entrySet()) {
            name = (String)config.getKey();
            org.apache.logging.log4j.core.Logger logger = ctx.getLogger(name);
            if (logger == root || root.equals(logger) || this.isRootLogger(name) || "".equals(name)) continue;
            map.putIfAbsent(name, new Log4j2Info(name, logger.getLevel(), null != ((LoggerConfig)config.getValue()).getExplicitLevel()));
        }
        for (Logger logger : ctx.getLoggers()) {
            int dot;
            name = logger.getName();
            if (logger == root || root.equals(logger) || this.isRootLogger(name) || "".equals(name)) continue;
            map.putIfAbsent(name, new Log4j2Info(name, logger.getLevel(), false));
            while ((dot = name.lastIndexOf(46)) >= 0) {
                name = name.substring(0, dot);
                map.putIfAbsent(name, new Log4j2Info(name, logger.getLevel(), false));
            }
        }
        return map.values();
    }

    @Override
    public void setThreshold(String level) {
        Log4j2Appender app = this.getAppender();
        Level current = app.getThreshold();
        app.setThreshold(Level.toLevel((String)level));
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        LoggerConfig config = this.getLoggerConfig(ctx, "root");
        config.removeAppender(app.getName());
        config.addAppender((Appender)app, app.getThreshold(), app.getFilter());
        ((LoggerContext)LogManager.getContext((boolean)false)).updateLoggers();
        if (log.isInfoEnabled()) {
            log.info("Updated watcher threshold from {} to {} ", (Object)current, (Object)level);
        }
    }

    @Override
    public String getThreshold() {
        return String.valueOf(this.getAppender().getThreshold());
    }

    protected Log4j2Appender getAppender() {
        if (this.appender == null) {
            throw new IllegalStateException("No appenders configured! Must call registerListener(ListenerConfig) first.");
        }
        return this.appender;
    }

    @Override
    public void registerListener(ListenerConfig cfg) {
        if (this.history != null) {
            throw new IllegalStateException("History already registered");
        }
        this.history = new CircularList(cfg.size);
        Level threshold = cfg.threshold != null ? Level.toLevel((String)cfg.threshold) : Level.WARN;
        ThresholdFilter filter = ThresholdFilter.createFilter((Level)threshold, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        LoggerConfig config = this.getLoggerConfig(ctx, "root");
        this.appender = new Log4j2Appender(this, filter, threshold);
        config.removeAppender(this.appender.getName());
        if (!this.appender.isStarted()) {
            this.appender.start();
        }
        config.addAppender((Appender)this.appender, threshold, (Filter)filter);
        ctx.updateLoggers();
    }

    @Override
    public SolrDocument toSolrDocument(LogEvent event) {
        Map contextMap;
        SolrDocument doc = new SolrDocument();
        doc.setField("time", (Object)new Date(event.getTimeMillis()));
        doc.setField("level", (Object)event.getLevel().toString());
        doc.setField("logger", (Object)event.getLoggerName());
        Message message = event.getMessage();
        doc.setField("message", (Object)message.getFormattedMessage());
        Throwable t = message.getThrowable();
        if (t != null) {
            StringWriter trace = new StringWriter();
            t.printStackTrace(new PrintWriter(trace));
            doc.setField("trace", (Object)trace.toString());
        }
        if ((contextMap = event.getContextMap()) != null) {
            for (Map.Entry entry : contextMap.entrySet()) {
                doc.setField((String)entry.getKey(), entry.getValue());
            }
        }
        if (!doc.containsKey((Object)"core")) {
            doc.setField("core", (Object)"");
        }
        return doc;
    }

    @SuppressForbidden(reason="class is specific to log4j2")
    protected static class Log4j2Appender
    extends AbstractAppender {
        private Log4j2Watcher watcher;
        private ThresholdFilter filter;
        private Level threshold;

        Log4j2Appender(Log4j2Watcher watcher, ThresholdFilter filter, Level threshold) {
            super(Log4j2Watcher.LOG4J2_WATCHER_APPENDER, (Filter)filter, null);
            this.watcher = watcher;
            this.filter = filter;
            this.threshold = threshold;
        }

        public void append(LogEvent logEvent) {
            this.watcher.add(logEvent, logEvent.getTimeMillis());
        }

        public Level getThreshold() {
            return this.threshold;
        }

        public void setThreshold(Level threshold) {
            this.threshold = threshold;
            this.removeFilter((Filter)this.filter);
            this.filter = ThresholdFilter.createFilter((Level)threshold, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY);
            this.addFilter((Filter)this.filter);
        }
    }

    @SuppressForbidden(reason="class is specific to log4j2")
    protected static class Log4j2Info
    extends LoggerInfo {
        private final boolean isSet;

        public Log4j2Info(String name, Level level, boolean isSet) {
            super(name);
            if (level != null) {
                this.level = level.toString();
            }
            this.isSet = isSet;
        }

        @Override
        public String getLevel() {
            return this.level != null ? this.level : null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isSet() {
            return this.isSet;
        }
    }
}

