/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.client.api.endpoint.CreateCollectionBackupApi;
import org.apache.solr.client.api.model.CreateCollectionBackupRequestBody;
import org.apache.solr.client.api.model.CreateCollectionBackupResponseBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionAdminParams;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.BackupAPIBase;
import org.apache.solr.handler.admin.api.CreateCollection;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.jersey.SolrJacksonMapper;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.common.StringUtils;

public class CreateCollectionBackup
extends BackupAPIBase
implements CreateCollectionBackupApi {
    private final ObjectMapper objectMapper = SolrJacksonMapper.getObjectMapper();

    @Inject
    public CreateCollectionBackup(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse createCollectionBackup(String collectionName, String backupName, CreateCollectionBackupRequestBody requestBody) throws Exception {
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required request body");
        }
        if (StringUtils.isBlank((String)backupName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: 'backupName'");
        }
        if (collectionName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: 'collection'");
        }
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        CreateCollectionBackup.recordCollectionForLogAndTracing(collectionName, this.solrQueryRequest);
        collectionName = this.resolveAndValidateAliasIfEnabled(collectionName, Boolean.TRUE.equals(requestBody.followAliases));
        requestBody.location = this.getAndValidateBackupLocation(requestBody.repository, requestBody.location);
        if (requestBody.incremental == null) {
            requestBody.incremental = Boolean.TRUE;
        }
        if (requestBody.backupStrategy == null) {
            requestBody.backupStrategy = "copy-files";
        }
        if (!CollectionAdminParams.INDEX_BACKUP_STRATEGIES.contains(requestBody.backupStrategy)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown index backup strategy " + requestBody.backupStrategy);
        }
        ZkNodeProps remoteMessage = CreateCollectionBackup.createRemoteMessage(collectionName, backupName, requestBody);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.BACKUP, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        SolrJerseyResponse response = (SolrJerseyResponse)this.objectMapper.convertValue((Object)remoteResponse.getResponse(), CreateCollectionBackupResponseBody.class);
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, String backupName, CreateCollectionBackupRequestBody requestBody) {
        Map remoteMessage = Utils.reflectToMap((Object)requestBody);
        remoteMessage.put("operation", CollectionParams.CollectionAction.BACKUP.toLower());
        remoteMessage.put("collection", collectionName);
        remoteMessage.put("name", backupName);
        if (!StringUtils.isBlank((String)requestBody.backupStrategy)) {
            remoteMessage.put("indexBackup", remoteMessage.remove("backupStrategy"));
        }
        if (!StringUtils.isBlank((String)requestBody.snapshotName)) {
            remoteMessage.put("commitName", remoteMessage.remove("snapshotName"));
        }
        return new ZkNodeProps(remoteMessage);
    }

    public static CreateCollectionBackupRequestBody createRequestBodyFromV1Params(SolrParams params) {
        CreateCollectionBackupRequestBody requestBody = new CreateCollectionBackupRequestBody();
        requestBody.location = params.get("location");
        requestBody.repository = params.get("repository");
        requestBody.followAliases = params.getBool("followAliases");
        requestBody.backupStrategy = params.get("indexBackup");
        requestBody.snapshotName = params.get("commitName");
        requestBody.incremental = params.getBool("incremental");
        requestBody.backupConfigset = params.getBool("backupConfigset");
        requestBody.maxNumBackupPoints = params.getInt("maxNumBackupPoints");
        requestBody.extraProperties = CreateCollection.copyPrefixedPropertiesWithoutPrefix(params, new HashMap<String, String>(), "property.");
        requestBody.async = params.get("async");
        return requestBody;
    }

    public static SolrJerseyResponse invokeFromV1Params(SolrQueryRequest req, SolrQueryResponse rsp, CoreContainer coreContainer) throws Exception {
        req.getParams().required().check(new String[]{"name", "collection"});
        String collectionName = req.getParams().get("collection");
        String backupName = req.getParams().get("name");
        CreateCollectionBackupRequestBody requestBody = CreateCollectionBackup.createRequestBodyFromV1Params(req.getParams());
        CreateCollectionBackup createBackupApi = new CreateCollectionBackup(coreContainer, req, rsp);
        return createBackupApi.createCollectionBackup(collectionName, backupName, requestBody);
    }
}

