/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.api.ApiSupport;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.RequestHandlers;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.jersey.APIConfigProvider;
import org.apache.solr.jersey.APIConfigProviderBinder;
import org.apache.solr.jersey.JerseyApplications;
import org.apache.solr.pkg.PackagePluginHolder;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginBag<T>
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, PluginHolder<T>> registry;
    private final Map<String, PluginHolder<T>> immutableRegistry;
    private String def;
    private final Class<T> klass;
    private SolrCore core;
    private final SolrConfig.SolrPluginInfo meta;
    private final boolean loadV2ApisIfPresent;
    private final ApiBag apiBag;
    private final ResourceConfig jerseyResources;
    private final JaxrsResourceToHandlerMappings jaxrsResourceRegistry;

    public JaxrsResourceToHandlerMappings getJaxrsRegistry() {
        return this.jaxrsResourceRegistry;
    }

    public PluginBag(Class<T> klass, SolrCore core, boolean needThreadSafety) {
        if (klass == SolrRequestHandler.class && V2ApiUtils.isEnabled()) {
            this.loadV2ApisIfPresent = true;
            this.apiBag = new ApiBag(core != null);
            this.jaxrsResourceRegistry = new JaxrsResourceToHandlerMappings();
            this.jerseyResources = core == null ? new JerseyApplications.CoreContainerApp() : new JerseyApplications.SolrCoreApp();
        } else {
            this.loadV2ApisIfPresent = false;
            this.apiBag = null;
            this.jerseyResources = null;
            this.jaxrsResourceRegistry = null;
        }
        this.core = core;
        this.klass = klass;
        this.registry = needThreadSafety ? new ConcurrentHashMap() : new HashMap();
        this.immutableRegistry = Collections.unmodifiableMap(this.registry);
        this.meta = SolrConfig.classVsSolrPluginInfo.get(klass.getName());
        if (this.meta == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Plugin : " + klass.getName());
        }
    }

    public PluginBag(Class<T> klass, SolrCore core) {
        this(klass, core, false);
    }

    public static void initInstance(Object inst, PluginInfo info) {
        if (inst instanceof PluginInfoInitialized) {
            ((PluginInfoInitialized)inst).init(info);
        } else if (inst instanceof NamedListInitializedPlugin) {
            ((NamedListInitializedPlugin)inst).init(info.initArgs);
        } else if (inst instanceof SolrRequestHandler) {
            ((SolrRequestHandler)inst).init(info.initArgs);
        }
        if (inst instanceof SearchComponent) {
            ((SearchComponent)inst).setName(info.name);
        }
        if (inst instanceof RequestHandlerBase) {
            ((RequestHandlerBase)inst).setPluginInfo(info);
        }
    }

    public Set<String> checkContains(Collection<String> names) {
        if (names == null || names.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String s : names) {
            if (this.registry.containsKey(s)) continue;
            result.add(s);
        }
        return result;
    }

    public PluginHolder<T> createPlugin(PluginInfo info) {
        if ("lazy".equals(info.attributes.get("startup")) && this.meta.options.contains((Object)SolrConfig.PluginOpts.LAZY)) {
            if (log.isDebugEnabled()) {
                log.debug("{} : '{}' created with startup=lazy ", (Object)this.meta.getCleanTag(), (Object)info.name);
            }
            return new LazyPluginHolder(this.meta, info, this.core, this.core.getResourceLoader());
        }
        if (info.pkgName != null) {
            PackagePluginHolder holder = new PackagePluginHolder(info, this.core, this.meta);
            return holder;
        }
        Object inst = SolrCore.createInstance(info.className, this.meta.clazz, this.meta.getCleanTag(), null, this.core.getResourceLoader());
        PluginBag.initInstance(inst, info);
        return new PluginHolder(info, inst);
    }

    boolean alias(String src, String target) {
        if (src == null) {
            return false;
        }
        PluginHolder<T> a = this.registry.get(src);
        if (a == null) {
            return false;
        }
        PluginHolder<T> b = this.registry.get(target);
        if (b != null) {
            return false;
        }
        this.registry.put(target, a);
        return true;
    }

    public T get(String name) {
        PluginHolder<T> result = this.registry.get(name);
        return result == null ? null : (T)result.get();
    }

    public T get(String name, boolean useDefault) {
        T result = this.get(name);
        if (useDefault && result == null) {
            return this.get(this.def);
        }
        return result;
    }

    public Set<String> keySet() {
        return this.immutableRegistry.keySet();
    }

    public T put(String name, T plugin) {
        if (plugin == null) {
            return null;
        }
        PluginHolder<T> pluginHolder = new PluginHolder<T>(null, plugin);
        pluginHolder.registerAPI = false;
        PluginHolder<T> old = this.put(name, pluginHolder);
        return old == null ? null : (T)old.get();
    }

    public PluginHolder<T> put(String name, PluginHolder<T> plugin) {
        String registerAt;
        Boolean registerApi = null;
        Boolean disableHandler = null;
        if (plugin.pluginInfo != null && (registerAt = plugin.pluginInfo.attributes.get("registerPath")) != null) {
            List strs = StrUtils.splitSmart((String)registerAt, (char)',');
            disableHandler = !strs.contains("/solr");
            registerApi = strs.contains("/v2");
        }
        if (this.loadV2ApisIfPresent) {
            if (plugin.isLoaded()) {
                SolrRequestHandler inst = plugin.get();
                if (inst instanceof ApiSupport) {
                    ApiSupport apiSupport = (ApiSupport)((Object)inst);
                    if (registerApi == null) {
                        registerApi = apiSupport.registerV2();
                    }
                    if (disableHandler == null) {
                        disableHandler = apiSupport.registerV1() == false;
                    }
                    if (registerApi.booleanValue() && V2ApiUtils.isEnabled()) {
                        Collection<Class<? extends JerseyResource>> jerseyApis;
                        Collection<Api> apis = apiSupport.getApis();
                        if (apis != null) {
                            Map<String, String> nameSubstitutes = Collections.singletonMap("handlerName", name);
                            for (Api api : apis) {
                                this.apiBag.register(api, nameSubstitutes);
                            }
                        }
                        if ((jerseyApis = apiSupport.getJerseyResources()) != null) {
                            for (Class clazz : jerseyApis) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Registering jersey resource class: {}", (Object)clazz.getName());
                                }
                                this.jerseyResources.register(clazz);
                                if (!(apiSupport instanceof RequestHandlerBase)) continue;
                                this.jaxrsResourceRegistry.put(clazz, (RequestHandlerBase)apiSupport);
                            }
                            if (apiSupport instanceof APIConfigProvider) {
                                this.jerseyResources.register((Object)new APIConfigProviderBinder((APIConfigProvider)((Object)apiSupport)));
                            }
                        }
                    }
                }
            } else if (registerApi != null && registerApi.booleanValue()) {
                this.apiBag.registerLazy(plugin, plugin.pluginInfo);
            }
        }
        if (disableHandler == null) {
            disableHandler = Boolean.FALSE;
        }
        PluginHolder<SolrRequestHandler> old = null;
        if (!disableHandler.booleanValue()) {
            old = this.registry.put(name, plugin);
        }
        if (plugin.pluginInfo != null && plugin.pluginInfo.isDefault()) {
            this.setDefault(name);
        }
        if (plugin.isLoaded()) {
            this.registerMBean(plugin.get(), this.core, name);
        }
        if (old != null && old != plugin) {
            PluginBag.closeQuietly(old);
        }
        return old;
    }

    void setDefault(String def) {
        if (!this.registry.containsKey(def)) {
            return;
        }
        if (this.def != null) {
            log.warn("Multiple defaults for : {}", (Object)this.meta.getCleanTag());
        }
        this.def = def;
    }

    public Map<String, PluginHolder<T>> getRegistry() {
        return this.immutableRegistry;
    }

    public boolean contains(String name) {
        return this.registry.containsKey(name);
    }

    String getDefault() {
        return this.def;
    }

    T remove(String name) {
        PluginHolder<T> removed = this.registry.remove(name);
        return removed == null ? null : (T)removed.get();
    }

    void init(Map<String, T> defaults, SolrCore solrCore) {
        this.init(defaults, solrCore, solrCore.getSolrConfig().getPluginInfos(this.klass.getName()));
    }

    void init(Map<String, T> defaults, SolrCore solrCore, List<PluginInfo> infos) {
        this.core = solrCore;
        for (PluginInfo pluginInfo : infos) {
            PluginHolder<T> old;
            PluginHolder<T> o = this.createPlugin(pluginInfo);
            String name = pluginInfo.name;
            if (this.meta.clazz.equals(SolrRequestHandler.class)) {
                name = RequestHandlers.normalize(pluginInfo.name);
            }
            if ((old = this.put(name, o)) == null) continue;
            log.warn("Multiple entries of {} with name {}", (Object)this.meta.getCleanTag(), (Object)name);
        }
        if (infos.size() > 0 && log.isDebugEnabled()) {
            log.debug("[{}] Initialized {} plugins of type {}: {}", new Object[]{solrCore.getName(), infos.size(), this.meta.getCleanTag(), infos.stream().map(i -> i.name).collect(Collectors.toList())});
        }
        for (Map.Entry entry : defaults.entrySet()) {
            if (this.contains((String)entry.getKey())) continue;
            this.put((String)entry.getKey(), new PluginHolder(null, entry.getValue()));
        }
    }

    public boolean isLoaded(String name) {
        PluginHolder<T> result = this.registry.get(name);
        if (result == null) {
            return false;
        }
        return result.isLoaded();
    }

    private void registerMBean(Object inst, SolrCore core, String pluginKey) {
        if (core == null) {
            return;
        }
        if (inst instanceof SolrInfoBean) {
            SolrInfoBean mBean = (SolrInfoBean)inst;
            String name = inst instanceof SolrRequestHandler ? pluginKey : mBean.getName();
            core.registerInfoBean(name, mBean);
        }
    }

    @Override
    public void close() {
        for (Map.Entry<String, PluginHolder<T>> e : this.registry.entrySet()) {
            try {
                e.getValue().close();
            }
            catch (Exception exp) {
                log.error("Error closing plugin {} of type : {}", new Object[]{e.getKey(), this.meta.getCleanTag(), exp});
            }
        }
    }

    public static void closeQuietly(Object inst) {
        try {
            if (inst != null && inst instanceof AutoCloseable) {
                ((AutoCloseable)inst).close();
            }
        }
        catch (Exception e) {
            log.error("Error closing {}", inst, (Object)e);
        }
    }

    public Api v2lookup(String path, String method, Map<String, String> parts) {
        if (this.apiBag == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "this should not happen, looking up for v2 API at the wrong place");
        }
        return this.apiBag.lookup(path, method, parts);
    }

    public ApiBag getApiBag() {
        return this.apiBag;
    }

    public ResourceConfig getJerseyEndpoints() {
        return this.jerseyResources;
    }

    public static class JaxrsResourceToHandlerMappings
    extends HashMap<Class<? extends JerseyResource>, RequestHandlerBase> {
    }

    public class LazyPluginHolder<T>
    extends PluginHolder<T> {
        private volatile T lazyInst;
        private final SolrConfig.SolrPluginInfo pluginMeta;
        protected SolrException solrException;
        private final SolrCore core;
        protected ResourceLoader resourceLoader;

        LazyPluginHolder(SolrConfig.SolrPluginInfo pluginMeta, PluginInfo pluginInfo, SolrCore core, ResourceLoader loader) {
            super(pluginInfo);
            this.pluginMeta = pluginMeta;
            this.core = core;
            this.resourceLoader = loader;
        }

        @Override
        public boolean isLoaded() {
            return this.lazyInst != null;
        }

        @Override
        public T get() {
            if (this.lazyInst != null) {
                return this.lazyInst;
            }
            if (this.solrException != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unrecoverable error", (Throwable)this.solrException);
            }
            if (this.createInst()) {
                PluginBag.this.registerMBean(this.lazyInst, this.core, this.pluginInfo.name);
            }
            return this.lazyInst;
        }

        private synchronized boolean createInst() {
            if (this.lazyInst != null) {
                return false;
            }
            if (log.isInfoEnabled()) {
                log.info("Going to create a new {} with {} ", (Object)this.pluginMeta.getCleanTag(), (Object)this.pluginInfo);
            }
            Class<?> clazz = this.pluginMeta.clazz;
            Object localInst = null;
            localInst = SolrCore.createInstance(this.pluginInfo.className, clazz, this.pluginMeta.getCleanTag(), null, this.resourceLoader);
            PluginBag.initInstance(localInst, this.pluginInfo);
            if (localInst instanceof SolrCoreAware) {
                SolrResourceLoader.assertAwareCompatibility(SolrCoreAware.class, localInst);
                ((SolrCoreAware)localInst).inform(this.core);
            }
            if (localInst instanceof ResourceLoaderAware) {
                SolrResourceLoader.assertAwareCompatibility(ResourceLoaderAware.class, localInst);
                try {
                    ((ResourceLoaderAware)localInst).inform((ResourceLoader)this.core.getResourceLoader());
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "error initializing component", (Throwable)e);
                }
            }
            this.lazyInst = localInst;
            return true;
        }
    }

    public static class PluginHolder<T>
    implements Supplier<T>,
    AutoCloseable {
        protected volatile T inst;
        protected final PluginInfo pluginInfo;
        boolean registerAPI = false;

        public PluginHolder(T inst, SolrConfig.SolrPluginInfo info) {
            this.inst = inst;
            this.pluginInfo = new PluginInfo(info.tag, Collections.singletonMap("class", inst.getClass().getName()));
        }

        public PluginHolder(PluginInfo info) {
            this.pluginInfo = info;
        }

        public PluginHolder(PluginInfo info, T inst) {
            this.inst = inst;
            this.pluginInfo = info;
        }

        public Optional<T> getInstance() {
            return Optional.ofNullable(this.inst);
        }

        @Override
        public T get() {
            return this.inst;
        }

        public boolean isLoaded() {
            return this.inst != null;
        }

        @Override
        public void close() {
            T myInst;
            if (this.isLoaded() && (myInst = this.get()) instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)myInst).close();
                }
                catch (Exception e) {
                    log.error("Error closing {}", this.inst, (Object)e);
                }
            }
        }

        public String getClassName() {
            if (this.isLoaded()) {
                return this.inst.getClass().getName();
            }
            if (this.pluginInfo != null) {
                return this.pluginInfo.className;
            }
            return null;
        }

        public PluginInfo getPluginInfo() {
            return this.pluginInfo;
        }

        public String toString() {
            return String.valueOf(this.inst);
        }
    }
}

