/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.PerReplicaStatesOps;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeMutator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected SolrZkClient zkClient;

    public NodeMutator(SolrCloudManager cloudManager) {
        this.zkClient = SliceMutator.getZkClient(cloudManager);
    }

    public List<ZkWriteCommand> downNode(ClusterState clusterState, ZkNodeProps message) {
        String nodeName = message.getStr("node_name");
        log.debug("DownNode state invoked for node: {}", (Object)nodeName);
        ArrayList<ZkWriteCommand> zkWriteCommands = new ArrayList<ZkWriteCommand>();
        Map collections = clusterState.getCollectionsMap();
        for (Map.Entry entry : collections.entrySet()) {
            Optional<ZkWriteCommand> zkWriteCommand;
            String collectionName = (String)entry.getKey();
            DocCollection docCollection = (DocCollection)entry.getValue();
            if (docCollection.isPerReplicaState() || !(zkWriteCommand = NodeMutator.computeCollectionUpdate(nodeName, collectionName, docCollection, this.zkClient)).isPresent()) continue;
            zkWriteCommands.add(zkWriteCommand.get());
        }
        return zkWriteCommands;
    }

    public static Optional<ZkWriteCommand> computeCollectionUpdate(String nodeName, String collectionName, DocCollection docCollection, SolrZkClient client) {
        boolean needToUpdateCollection = false;
        ArrayList<String> downedReplicas = new ArrayList<String>();
        LinkedHashMap<String, Slice> slicesCopy = new LinkedHashMap<String, Slice>(docCollection.getSlicesMap());
        List replicasOnNode = docCollection.getReplicas(nodeName);
        if (replicasOnNode == null || replicasOnNode.isEmpty()) {
            return Optional.empty();
        }
        for (Replica replica : replicasOnNode) {
            if (replica.getState() == Replica.State.DOWN) continue;
            log.debug("Update replica state for {} to {}", (Object)replica, (Object)Replica.State.DOWN);
            needToUpdateCollection = true;
            downedReplicas.add(replica.getName());
            slicesCopy.computeIfPresent(replica.getShard(), (name, slice) -> slice.copyWith(replica.copyWith(Replica.State.DOWN)));
        }
        if (needToUpdateCollection) {
            if (docCollection.isPerReplicaState()) {
                PerReplicaStates prs = client == null ? docCollection.getPerReplicaStates() : PerReplicaStatesOps.fetch((String)docCollection.getZNode(), (SolrZkClient)client, (PerReplicaStates)docCollection.getPerReplicaStates());
                return Optional.of(new ZkWriteCommand(collectionName, docCollection.copyWithSlices(slicesCopy), PerReplicaStatesOps.downReplicas(downedReplicas, (PerReplicaStates)prs), false));
            }
            return Optional.of(new ZkWriteCommand(collectionName, docCollection.copyWithSlices(slicesCopy)));
        }
        return Optional.empty();
    }
}

