/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.common.util.NamedList;
import org.noggit.CharArr;
import org.noggit.JSONWriter;

public class StatusTool
extends ToolBase {
    public static final Option OPTION_MAXWAITSECS = Option.builder().longOpt("max-wait-secs").argName("SECS").hasArg().required(false).desc("Wait up to the specified number of seconds to see Solr running.").build();

    public StatusTool() {
        this(CLIO.getOutStream());
    }

    public StatusTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "status";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder().argName("URL").longOpt("solr-url").hasArg().required(false).desc("Address of the Solr Web application, defaults to: " + SolrCLI.getDefaultSolrUrl() + ".").build(), Option.builder((String)"maxWaitSecs").argName("SECS").hasArg().required(false).desc("Wait up to the specified number of seconds to see Solr running.").build());
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        if (cli.getOptions().length == 0 && cli.getArgs().length == 0 || cli.hasOption("h") || cli.hasOption("help")) {
            Options options = new Options();
            options.addOption(OPTION_MAXWAITSECS);
            new HelpFormatter().printHelp("status", options);
            return;
        }
        int maxWaitSecs = Integer.parseInt(SolrCLI.getOptionWithDeprecatedAndDefault(cli, "max-wait-secs", "maxWaitSecs", "0"));
        String solrUrl = SolrCLI.normalizeSolrUrl(cli);
        if (maxWaitSecs > 0) {
            int solrPort = new URL(solrUrl).getPort();
            this.echo("Waiting up to " + maxWaitSecs + " seconds to see Solr running on port " + solrPort);
            try {
                this.waitToSeeSolrUp(solrUrl, maxWaitSecs, TimeUnit.SECONDS);
                this.echo("Started Solr server on port " + solrPort + ". Happy searching!");
            }
            catch (TimeoutException timeout) {
                throw new Exception("Solr at " + solrUrl + " did not come online within " + maxWaitSecs + " seconds!");
            }
        }
        try {
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(this.getStatus(solrUrl));
            this.echo(arr.toString());
        }
        catch (Exception exc) {
            if (SolrCLI.exceptionIsAuthRelated(exc)) {
                throw exc;
            }
            if (SolrCLI.checkCommunicationError(exc)) {
                CLIO.err("Solr at " + solrUrl + " not online.");
            }
            throw new Exception("Failed to get system information from " + solrUrl + " due to: " + exc);
        }
    }

    public Map<String, Object> waitToSeeSolrUp(String solrUrl, long maxWait, TimeUnit unit) throws Exception {
        long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(maxWait, unit);
        while (System.nanoTime() < timeout) {
            try {
                return this.getStatus(solrUrl);
            }
            catch (Exception exc) {
                if (SolrCLI.exceptionIsAuthRelated(exc)) {
                    throw exc;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interrupted) {
                    timeout = 0L;
                }
            }
        }
        throw new TimeoutException("Did not see Solr at " + solrUrl + " come online within " + TimeUnit.SECONDS.convert(maxWait, unit) + " seconds!");
    }

    public Map<String, Object> getStatus(String solrUrl) throws Exception {
        Map<String, Object> status;
        if (!((String)solrUrl).endsWith("/")) {
            solrUrl = (String)solrUrl + "/";
        }
        try (SolrClient solrClient = SolrCLI.getSolrClient((String)solrUrl);){
            NamedList systemInfo = solrClient.request((SolrRequest)new GenericSolrRequest(SolrRequest.METHOD.GET, "/admin/info/system"));
            status = this.reportStatus((NamedList<Object>)systemInfo, solrClient);
        }
        return status;
    }

    public Map<String, Object> reportStatus(NamedList<Object> info, SolrClient solrClient) throws Exception {
        LinkedHashMap<String, Object> status = new LinkedHashMap<String, Object>();
        String solrHome = (String)info.get("solr_home");
        status.put("solr_home", solrHome != null ? solrHome : "?");
        status.put("version", info.findRecursive(new String[]{"lucene", "solr-impl-version"}));
        status.put("startTime", info.findRecursive(new String[]{"jvm", "jmx", "startTime"}).toString());
        status.put("uptime", SolrCLI.uptime((Long)info.findRecursive(new String[]{"jvm", "jmx", "upTimeMS"})));
        String usedMemory = (String)info.findRecursive(new String[]{"jvm", "memory", "used"});
        String totalMemory = (String)info.findRecursive(new String[]{"jvm", "memory", "total"});
        status.put("memory", usedMemory + " of " + totalMemory);
        if ("solrcloud".equals(info.get("mode"))) {
            String zkHost = (String)info.get("zkHost");
            status.put("cloud", this.getCloudStatus(solrClient, zkHost));
        }
        return status;
    }

    protected Map<String, String> getCloudStatus(SolrClient solrClient, String zkHost) throws Exception {
        LinkedHashMap<String, String> cloudStatus = new LinkedHashMap<String, String>();
        cloudStatus.put("ZooKeeper", zkHost != null ? zkHost : "?");
        NamedList json = solrClient.request((SolrRequest)new CollectionAdminRequest.ClusterStatus());
        List liveNodes = (List)json.findRecursive(new String[]{"cluster", "live_nodes"});
        cloudStatus.put("liveNodes", String.valueOf(liveNodes.size()));
        Map collections = ((NamedList)json.findRecursive(new String[]{"cluster", "collections"})).asMap();
        cloudStatus.put("collections", String.valueOf(collections.size()));
        return cloudStatus;
    }
}

