/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import coldfusion.document.CFFontFace;
import coldfusion.log.CFLogs;
import coldfusion.util.SoftCache;
import com.lowagie.text.FontFactory;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import macromedia.fonts.FontFace;
import macromedia.fonts.FontManager;

public class CFFontManager
extends FontManager {
    static FontFaceCache fontCache = new FontFaceCache();
    public static int FontPointSize = 20;

    public static boolean isUsableFont(String path) {
        boolean rc = false;
        if (path != null) {
            int dotPosition = path.lastIndexOf(46);
            String fileExtension = null;
            if (dotPosition > 0 && ((fileExtension = path.substring(dotPosition)).equalsIgnoreCase(".ttf") || fileExtension.equalsIgnoreCase(".ttc"))) {
                rc = true;
            }
        }
        return rc;
    }

    public FontFace getEntryFromSystem(String familyName, int style) {
        return (FontFace)fontCache.get(new FontKey(familyName, style));
    }

    public FontFace getEntryFromLocation(URL location, int style) {
        return CFFontManager.getFontFaceEntryFromLocation(location, style);
    }

    static FontFace getFontFaceEntryFromLocation(URL location, int style) {
        InputStream is = null;
        try {
            if (location != null && location instanceof URL) {
                URL url = location;
                if (url.getProtocol().toLowerCase().indexOf("file") > -1) {
                    File f = new File(url.getFile());
                    is = new FileInputStream(f);
                } else {
                    is = url.openStream();
                }
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
        }
        Font font = null;
        try {
            font = Font.createFont(0, is);
            font = font.deriveFont(style, FontPointSize);
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
        }
        return new CFFontFace(font);
    }

    public void initialize(Properties parm1) {
    }

    static class FontFaceCache
    extends SoftCache {
        FontFaceCache() {
        }

        protected Object fetch(Object fontKey) {
            int index;
            FontKey key = (FontKey)fontKey;
            String familyName = key.familyName;
            int style = key.style;
            Font font = new Font(familyName, style, FontPointSize);
            if (font.getFamily().equalsIgnoreCase(familyName)) {
                return new CFFontFace(font);
            }
            String path = FontFactory.getFontPath((String)familyName, (int)style);
            if (path != null && (index = path.indexOf(",")) > 0) {
                path = path.substring(0, index);
            }
            if (!CFFontManager.isUsableFont(path)) {
                font = new Font("Serif", style, FontPointSize);
                return new CFFontFace(font);
            }
            FontFace face = null;
            try {
                File file = new File(path);
                face = CFFontManager.getFontFaceEntryFromLocation(file.toURL(), style);
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error((Throwable)e);
                font = new Font("Serif", style, FontPointSize);
                face = new CFFontFace(font);
            }
            return face;
        }
    }

    static class FontKey {
        String familyName;
        int style;

        FontKey(String family, int style) {
            this.familyName = family;
            this.style = style;
        }

        public int hashCode() {
            return (this.familyName + String.valueOf(this.style)).hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof FontKey) {
                FontKey other = (FontKey)o;
                return this.familyName.equals(other.familyName) && this.style == other.style;
            }
            return false;
        }
    }
}

