/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.DispLine;
import com.adobe.xfa.text.DispMapItem;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextDisplay;
import com.adobe.xfa.text.TextFrame;

class DispRun
extends DispMapItem {
    private TextFrame mpoFrame;
    private TextDisplay mpoDisplay;
    private TextAttr mpoAttr;
    private int mnLanguageID;
    private int meGlyphOrientation = 0;
    private boolean mbIsComb;
    private boolean mbAllowLigatures;
    private boolean mbAllowKerning;
    private boolean mbUsingUnicodeFont;

    DispRun() {
    }

    DispRun(DispRun oSource) {
        super(oSource);
        this.copy(oSource, oSource.mpoAttr);
    }

    DispRun(DispRun oSource, int index, int length) {
        super(index, length);
        this.copy(oSource, oSource.mpoAttr);
    }

    DispRun(DispRun oSource, TextAttr poNewAttr) {
        super(oSource);
        this.copy(oSource, poNewAttr, true);
    }

    DispRun(TextFrame poFrame, TextAttr poAttr) {
        this.mpoFrame = poFrame;
        this.mpoDisplay = poFrame.display();
        this.setAttr(poAttr);
    }

    DispRun(DispRun oSource, int eNewGlyphOrientation) {
        super(oSource);
        this.copy(oSource, oSource.mpoAttr);
        this.meGlyphOrientation = eNewGlyphOrientation;
    }

    TextAttr getAttr() {
        return this.mpoAttr;
    }

    void setAttr(TextAttr poAttr) {
        TextAttr poFlatAttr;
        if (poAttr == this.mpoAttr) {
            return;
        }
        this.mpoAttr = poAttr == null ? null : ((poFlatAttr = poAttr.conditionalFlatten()) != null ? poFlatAttr : poAttr);
    }

    TextFrame getFrame() {
        return this.mpoFrame;
    }

    TextDisplay getDisplay() {
        return this.mpoDisplay;
    }

    int getLanguageID() {
        return this.mnLanguageID;
    }

    void setLanguageID(int nLanguageID) {
        this.mnLanguageID = nLanguageID;
    }

    boolean isRTL() {
        return this.mpoFrame.isRTL(this.mpoAttr);
    }

    boolean isIdeographic() {
        return this.mpoFrame.isIdeographic(this.mpoAttr);
    }

    boolean isComb() {
        return this.mbIsComb;
    }

    void setComb(boolean bIsComb) {
        this.mbIsComb = bIsComb;
    }

    boolean allowLigatures() {
        return this.mbAllowLigatures;
    }

    void setAllowLigatures(boolean bAllowLigatures) {
        this.mbAllowLigatures = bAllowLigatures;
    }

    boolean allowKerning() {
        return this.mbAllowKerning;
    }

    void setAllowKerning(boolean bAllowKerning) {
        this.mbAllowKerning = bAllowKerning;
    }

    int glyphOrientation() {
        return this.meGlyphOrientation;
    }

    void setGlyphOrientation(int eGlyphOrientation) {
        this.meGlyphOrientation = eGlyphOrientation;
    }

    void copyFrom(DispRun oSource) {
        if (this != oSource) {
            super.copyFrom(oSource);
            this.copy(oSource, oSource.mpoAttr);
        }
    }

    void copy(DispRun oSource, TextAttr poAttr, boolean bForceAttr) {
        this.mpoFrame = oSource.mpoFrame;
        this.mpoDisplay = oSource.mpoDisplay;
        this.meGlyphOrientation = oSource.meGlyphOrientation;
        this.mbIsComb = oSource.mbIsComb;
        this.mbAllowLigatures = oSource.mbAllowLigatures;
        this.mbAllowKerning = oSource.mbAllowKerning;
        this.mbUsingUnicodeFont = oSource.mbUsingUnicodeFont;
        this.setAttr(poAttr);
    }

    void copy(DispRun oSource, TextAttr poAttr) {
        this.copy(oSource, poAttr, false);
    }

    @Override
    DispRun r() {
        return this;
    }

    @Override
    void add(DispLine line, int start, int length) {
        line.add(this, start, length);
    }

    @Override
    DispMapItem cloneMapItem() {
        return new DispRun(this);
    }

    @Override
    DispMapItem cloneMapItem(int index, int length) {
        return new DispRun(this, index, length);
    }

    @Override
    void copyFrom(DispMapItem source) {
        assert (source instanceof DispRun);
        this.copyFrom((DispRun)source);
    }
}

