/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.AFEAttrMap;
import com.adobe.xfa.text.AFEAttrSet;
import com.adobe.xfa.ut.Storage;
import java.util.List;

class AFEVarAttr
extends AFEAttrSet {
    private static final int INITIAL_ATTR_SIZE = 8;
    private Storage<Object> mAttrs;

    AFEVarAttr(AFEAttrMap afeAttrMap) {
        super(afeAttrMap);
    }

    AFEVarAttr(AFEVarAttr source) {
        super(source.getAFEAttrMap());
        if (source.mAttrs != null) {
            this.mAttrs = new Storage<Object>((List<Object>)source.mAttrs);
        }
    }

    @Override
    public int compareTo(AFEAttrSet compare) {
        if (this == compare) {
            return 0;
        }
        if (compare == null) {
            throw new NullPointerException();
        }
        if (!(compare instanceof AFEVarAttr)) {
            return -1;
        }
        AFEVarAttr attrSet = (AFEVarAttr)compare;
        int attrCount = this.getAFEAttrMap().getAFEIndexCount();
        block5: for (int i = 0; i < attrCount; ++i) {
            Object value1 = this.getAttr(i);
            Object value2 = attrSet.getAttr(i);
            switch (AFEVarAttr.nullCompare(value1, value2)) {
                case 1: {
                    return -1;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    int h1 = value1.hashCode();
                    int h2 = value2.hashCode();
                    if (h1 < h2) {
                        return -1;
                    }
                    if (h1 > h2) {
                        return 1;
                    }
                    int cmp = value1.toString().compareTo(value2.toString());
                    if (cmp == 0) continue block5;
                    return cmp;
                }
            }
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        AFEVarAttr other = (AFEVarAttr)object;
        int attrCount = this.getAFEAttrMap().getAFEIndexCount();
        block4: for (int i = 0; i < attrCount; ++i) {
            Object value1 = this.getAttr(i);
            Object value2 = other.getAttr(i);
            switch (AFEVarAttr.nullCompare(value1, value2)) {
                case 1: 
                case 2: {
                    return false;
                }
                case 3: {
                    int h1 = value1.hashCode();
                    int h2 = value2.hashCode();
                    if (h1 != h2) {
                        return false;
                    }
                    if (value1.toString().equals(value2.toString())) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 13;
        int attrCount = this.getAFEAttrMap().getAFEIndexCount();
        hash = hash * 31 ^ attrCount;
        for (int i = 0; i < attrCount; ++i) {
            Object value = this.getAttr(i);
            hash = hash * 31 ^ (value == null ? 0 : value.hashCode());
        }
        return hash;
    }

    @Override
    Object getAttr(Object key) {
        return this.getAttr(this.getAFEAttrMap().mapAFEIndex(key));
    }

    Object getAttr(int index) {
        return this.mAttrs != null && index < this.mAttrs.size() ? this.mAttrs.get(index) : null;
    }

    @Override
    boolean matchAttr(AFEAttrSet compare, Object attribute) {
        Object o2;
        assert (compare instanceof AFEVarAttr);
        AFEVarAttr other = (AFEVarAttr)compare;
        int index = this.getAFEAttrMap().mapAFEIndex(attribute);
        Object o1 = this.getAttr(index);
        return AFEVarAttr.nullCompare(o1, o2 = other.getAttr(index)) == 0;
    }

    void setAttr(Object key, Object value) {
        this.setAttr(this.getAFEAttrMap().mapAFEIndex(key), value);
    }

    void setAttr(int index, Object value) {
        if (this.mAttrs == null) {
            this.mAttrs = new Storage(8);
        }
        if (index >= this.mAttrs.size()) {
            this.mAttrs.setSize(index + 1);
        }
        this.mAttrs.set(index, value);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        Object[] afeKeys = this.getAFEAttrMap().getAFEKeys();
        int attrCount = this.mAttrs.size();
        assert (attrCount <= afeKeys.length);
        for (int i = 0; i < attrCount; ++i) {
            Object value = this.mAttrs.get(i);
            if (value == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(afeKeys[i].toString());
            result.append(": ");
            result.append(value.toString());
        }
        return result.toString();
    }
}

