/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.template.containers;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.ut.Angle;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;

public final class Rotate
extends Attribute {
    private final Angle moValue;

    private Rotate(String NS, String localName, String qName, String value, boolean internSymbols) {
        super(NS, localName, qName, value, internSymbols);
        if (StringUtils.isEmpty(value)) {
            this.moValue = Angle.ZERO;
        } else {
            double dValue = 0.0;
            try {
            }
            catch (NumberFormatException n) {
                MsgFormatPos oMessage = new MsgFormatPos(ResId.InvalidPropertyValueException, value);
                oMessage.format("rotate");
                throw new ExFull(oMessage);
            }
            for (dValue = Double.parseDouble(value); dValue < 0.0; dValue += 360.0) {
            }
            while (dValue > 360.0) {
                dValue -= 360.0;
            }
            this.moValue = new Angle(dValue);
        }
    }

    public Rotate(String name, Angle other) {
        super(name, other.toString());
        this.moValue = other;
    }

    public Rotate(Rotate other) {
        super(other.getName(), other.toString());
        this.moValue = other.getAngle();
    }

    public Rotate(String name, String stringValue) {
        super(name, stringValue);
        if (StringUtils.isEmpty(stringValue)) {
            this.moValue = Angle.ZERO;
        } else {
            double dValue = 0.0;
            try {
            }
            catch (NumberFormatException n) {
                throw new ExFull(ResId.ArgumentMismatchException);
            }
            for (dValue = Double.parseDouble(stringValue); dValue < 0.0; dValue += 360.0) {
            }
            while (dValue > 360.0) {
                dValue -= 360.0;
            }
            this.moValue = new Angle(dValue);
        }
    }

    public Angle getAngle() {
        return this.moValue;
    }

    public double getValue() {
        return this.moValue.getAngle();
    }

    @Override
    public Attribute newAttribute(String value) {
        return this.newAttribute(this.getNS(), this.getLocalName(), this.getQName(), value, false);
    }

    @Override
    public Attribute newAttribute(String NS, String localName, String qName, String value) {
        return this.newAttribute(NS, localName, qName, value, true);
    }

    @Override
    public Attribute newAttribute(String NS, String localName, String qName, String value, boolean internSymbols) {
        return new Rotate(NS, localName, qName, value, internSymbols);
    }

    @Override
    public String toString() {
        String sRet = Double.toString(this.moValue.getAngle());
        if (sRet.endsWith(".0")) {
            sRet = sRet.substring(0, sRet.length() - 2);
        }
        return sRet;
    }
}

