/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.layout;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Element;
import com.adobe.xfa.Int;
import com.adobe.xfa.Measurement;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.content.ExDataValue;
import com.adobe.xfa.layout.BoxModelCaptionable;
import com.adobe.xfa.layout.BoxModelLayout;
import com.adobe.xfa.layout.LayoutEnv;
import com.adobe.xfa.layout.LayoutHandler;
import com.adobe.xfa.template.TemplateResolver;
import com.adobe.xfa.template.containers.Draw;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.formatting.Picture;
import com.adobe.xfa.template.ui.UI;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextDisplay;
import com.adobe.xfa.text.TextMeasurement;
import com.adobe.xfa.text.TextPosn;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextRange;
import com.adobe.xfa.text.TextRegion;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.IntegerHolder;
import com.adobe.xfa.ut.LcLocale;
import com.adobe.xfa.ut.LcNum;
import com.adobe.xfa.ut.Margins;
import com.adobe.xfa.ut.ObjectHolder;
import com.adobe.xfa.ut.PictureFmt;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.ut.UnitSpan;
import java.util.List;

class BoxModelContent
extends BoxModelCaptionable {
    protected Rect m_oContentDisplayExtent = Rect.ZERO;
    protected boolean m_bSplitContent = false;
    protected TextPosn m_oStartContentPosn = new TextPosn();
    protected TextPosn m_oEndContentPosn = new TextPosn();
    protected TextAttr m_oAmbientTextAttr = new TextAttr();
    protected boolean m_bEmbeddedContent = false;
    protected boolean m_bKeepContentTextStream = false;
    protected boolean m_bForcedGrowableW = false;
    protected boolean m_bForcedGrowableH = false;

    public BoxModelContent(LayoutEnv oEnv, boolean bAllowRenderProxy) {
        super(oEnv, bAllowRenderProxy);
    }

    @Override
    public void clear() {
        this.m_bKeepContentTextStream = false;
        this.m_bSplitContent = false;
        super.clear();
    }

    @Override
    public void initialize(Element oNode) {
        assert (oNode != null);
        assert (oNode instanceof Field || oNode instanceof Draw);
        if (!this.isBoxModelCompatible(oNode)) {
            return;
        }
        this.checkProxyStatus(oNode);
        if (!this.isProxy()) {
            this.initWidthHeight(oNode, true);
        }
        this.initAnchorPoint(oNode);
        this.initMargins(oNode);
        this.initBorder(oNode);
        if (!this.isProxy()) {
            this.initCaption(oNode);
            this.initContent(oNode);
            this.format(oNode);
        } else {
            this.initContent(oNode);
            if (oNode instanceof Field) {
                this.createDisplay(this.m_oContentExtent.width(), this.m_oContentExtent.width(), this.m_oContentExtent.height(), this.m_oContentExtent.height());
            }
        }
        this.initRotatedContentTopLeft();
        this.respectRotation(oNode);
        this.initVisualExtent(oNode);
    }

    @Override
    public void reinitialize(Element oNode) {
        if (!this.m_bKeepContentTextStream && !this.m_bKeepCaptionTextStream) {
            super.reinitialize(oNode);
            return;
        }
        assert (oNode != null);
        this.initialize(oNode);
    }

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public String getContentByType(String sType, List<TemplateResolver.RGB> colorTable, List<String> fontTable) {
        assert (null != this.getContent());
        if (null != this.getContent()) {
            return this.getStringByType(this.getContent(), this.m_oAmbientTextAttr, sType, this.m_oStartContentPosn, this.m_oEndContentPosn, colorTable, fontTable);
        }
        return "";
    }

    @Override
    public boolean enumerateContent(LayoutHandler pHandler, CoordPair oLocalOrigin, boolean bWrap, boolean bTruncate, Rect oInvalidatedRect) {
        CoordPair oNewOrigin = oLocalOrigin;
        Rect oInvalid = oInvalidatedRect;
        if (oInvalid.width().equals(UnitSpan.ZERO) && oInvalid.height().equals(UnitSpan.ZERO)) {
            oInvalid = Rect.ZERO;
        }
        if (this.m_bSplitContent) {
            oInvalid = this.m_oContentDisplayExtent;
            oNewOrigin = new CoordPair(oNewOrigin.x(), oNewOrigin.y().subtract(this.m_oContentDisplayExtent.top()));
        }
        boolean bSplitContentFits = true;
        if (this.m_oContentDisplayExtent.width().gt(this.getContentExtent().width())) {
            oInvalid = oInvalid.width(this.getContentExtent().width(), false);
            bSplitContentFits = false;
        }
        if (this.m_oContentDisplayExtent.height().gt(this.getContentExtent().height())) {
            oInvalid = oInvalid.height(this.getContentExtent().height(), false);
            bSplitContentFits = false;
        }
        boolean bFits = this.m_oGfxLayoutEnv.renderText(pHandler, this.getContentDisplay(), oNewOrigin, bWrap, bTruncate, this.m_oRotationAngle, oInvalid);
        if (this.m_bSplitContent) {
            return bSplitContentFits;
        }
        return bFits;
    }

    @Override
    public void resizeToNominal(UnitSpan oW, UnitSpan oH, Element oNode) {
        if (this.m_bWasRotated && (this.m_oRotationAngle.degrees() == 90 || this.m_oRotationAngle.degrees() == 270)) {
            this.setGrowableH(oW, oW);
            this.setGrowableW(oH, oH);
        } else {
            this.setGrowableW(oW, oW);
            this.setGrowableH(oH, oH);
        }
        this.format(oNode);
        this.initRotatedContentTopLeft();
        this.respectRotation(oNode);
        this.initVisualExtent(oNode);
    }

    @Override
    public void resizeToNominalWidth(UnitSpan oW, Element oNode) {
        assert (UnitSpan.ZERO.lte(oW));
        if (this.m_bWasRotated) {
            if (this.m_oRotationAngle.degrees() == 90 || this.m_oRotationAngle.degrees() == 270) {
                this.setGrowableH(oW, oW);
            } else {
                this.setGrowableW(oW, oW);
            }
        } else {
            this.setGrowableW(oW, oW);
        }
        this.format(oNode);
        this.initRotatedContentTopLeft();
        this.respectRotation(oNode);
        this.initVisualExtent(oNode);
    }

    @Override
    public void resizeToContent(UnitSpan oW, UnitSpan oH, Element oNode) {
        assert (false);
    }

    @Override
    public boolean splitImpl(UnitSpan oVSplit, BoxModelLayout pNewBM, Element oNode) {
        if (this.m_bWasRotated) {
            return false;
        }
        boolean bSplit = false;
        if (oVSplit.gt(UnitSpan.ZERO) && oVSplit.lt(this.getHeight()) && oVSplit.gte(this.m_oContentExtent.top()) && oVSplit.lte(this.m_oContentExtent.bottom())) {
            if (!this.m_bSplitContent) {
                this.m_oContentDisplayExtent = this.m_oContentDisplayExtent.width(this.getContentExtent().width(), false);
                this.m_oContentDisplayExtent = this.m_oContentDisplayExtent.height(this.getContentExtent().height(), false);
                if (this.m_bHasCaption) {
                    this.m_oCaptionDisplayExtent = this.m_oCaptionDisplayExtent.width(this.getCaptionExtent().width(), false);
                    this.m_oCaptionDisplayExtent = this.m_oCaptionDisplayExtent.height(this.getCaptionExtent().height(), false);
                }
            }
            assert (null != this.getContentDisplay());
            assert (null != this.getCaptionDisplay() || !this.m_bHasCaption);
            UnitSpan oContentDisplayOffset = this.m_oContentDisplayExtent.top();
            assert (UnitSpan.ZERO.lte(oVSplit.subtract(this.m_oContentExtent.top()).add(oContentDisplayOffset)));
            TextPosn oPrevEndContentPosn = this.m_oEndContentPosn;
            boolean bEndsInNewLine = false;
            UnitSpan oContentSplit = UnitSpan.ZERO;
            UnitSpan oContentDisplayBottom = this.m_oContentDisplayExtent.bottom();
            Rect oLineRect = Rect.ZERO;
            if (oLineRect.height().gt(oContentDisplayBottom.subtract(oContentSplit))) assert (oContentSplit.lt(oContentDisplayBottom));
            if (oLineRect.height().gt(oContentSplit.subtract(this.m_oContentDisplayExtent.top()))) {
                if (!this.m_bSplitContent) {
                    this.m_oContentDisplayExtent = Rect.ZERO;
                    if (this.m_bHasCaption) {
                        this.m_oCaptionDisplayExtent = Rect.ZERO;
                    }
                }
                this.m_oEndContentPosn = oPrevEndContentPosn;
                return false;
            }
            Rect oOldNE = this.getNominalExtent();
            if (oContentSplit.gte(oContentDisplayOffset) && oContentSplit.lte(oContentDisplayBottom)) {
                Rect oNewContentDisplayExtent = this.m_oContentDisplayExtent;
                oNewContentDisplayExtent = oNewContentDisplayExtent.topBottom(oContentSplit, oContentDisplayBottom);
                this.m_oContentDisplayExtent = this.m_oContentDisplayExtent.topBottom(oContentDisplayOffset, oContentSplit);
                pNewBM = new BoxModelContent(this.m_oGfxLayoutEnv, false);
                BoxModelContent pBMContent = (BoxModelContent)pNewBM;
                pBMContent.m_bSplitContent = true;
                pBMContent.m_oStartContentPosn = this.m_oEndContentPosn;
                pBMContent.m_oEndContentPosn = oPrevEndContentPosn;
                if (bEndsInNewLine) {
                    this.m_oEndContentPosn.prevUserPosn();
                }
                this.m_bSplitContent = true;
                Rect oNewCaptionDisplayExtent = this.m_oCaptionDisplayExtent;
                if (this.m_bHasCaption) {
                    assert (this.m_eCaptionPlacement != 0x400004);
                    if (this.m_eCaptionPlacement == 0x400003 || this.m_eCaptionPlacement == 0x400001 || this.m_eCaptionPlacement == 0x400002) {
                        pBMContent.m_bHasCaption = true;
                        pBMContent.m_bReserveCaptionSpace = this.m_bReserveCaptionSpace;
                        pBMContent.m_eCaptionPresence = this.m_eCaptionPresence;
                        pBMContent.m_eCaptionPlacement = this.m_eCaptionPlacement;
                        pBMContent.m_oReserveCaptionSpace = this.m_oReserveCaptionSpace;
                        if (this.m_eCaptionPlacement == 0x400002) {
                            this.m_bHasCaption = false;
                        } else {
                            UnitSpan oCaptionDisplayOffset = this.m_oCaptionDisplayExtent.top();
                            assert (UnitSpan.ZERO.lte(oVSplit.subtract(this.m_oCaptionExtent.top()).add(oCaptionDisplayOffset)));
                            TextPosn oPrevEndCaptionPosn = new TextPosn(this.m_oEndCaptionPosn);
                            bEndsInNewLine = false;
                            UnitSpan oCaptionSplit = UnitSpan.ZERO;
                            UnitSpan oCaptionDisplayBottom = this.m_oCaptionDisplayExtent.bottom();
                            oNewCaptionDisplayExtent = oNewCaptionDisplayExtent.topBottom(oCaptionSplit, oCaptionDisplayBottom);
                            this.m_oCaptionDisplayExtent = this.m_oCaptionDisplayExtent.topBottom(oCaptionDisplayOffset, oCaptionSplit);
                            pBMContent.m_bSplitCaption = true;
                            pBMContent.m_oStartCaptionPosn = this.m_oEndCaptionPosn;
                            pBMContent.m_oEndCaptionPosn = oPrevEndCaptionPosn;
                            if (bEndsInNewLine) {
                                this.m_oEndCaptionPosn.prevUserPosn();
                            }
                            this.m_bSplitCaption = true;
                        }
                    }
                }
                pBMContent.initializeSplit(oNode, oNewContentDisplayExtent, oNewCaptionDisplayExtent);
                pBMContent.disableTopMargin();
                pBMContent.disableContentTopMargin();
                if (this.m_bSplitCaption) {
                    pBMContent.disableCaptionTopMargin();
                    this.disableCaptionBottomMargin();
                }
                this.disableBottomMargin();
                this.disableContentBottomMargin();
                boolean bWasHGrowable = this.hasGrowableH();
                this.setGrowableH(UnitSpan.ZERO, new UnitSpan(3, -1));
                this.format(oNode);
                UnitSpan oNewNEHeight = this.getHeight();
                if (!bWasHGrowable) {
                    this.setGrowableH(oNewNEHeight, oNewNEHeight);
                }
                UnitSpan oNEDelta = oOldNE.height().subtract(oNewNEHeight);
                pNewBM.resizeToNominal(oOldNE.width(), oNEDelta, oNode);
                if (bWasHGrowable) {
                    pBMContent.setGrowableH(UnitSpan.ZERO, new UnitSpan(3, -1));
                }
                pBMContent.setForcedGrowableH(this.hasForcedGrowableH());
                pBMContent.setForcedGrowableW(this.hasForcedGrowableW());
                bSplit = true;
            }
        }
        return bSplit;
    }

    @Override
    public boolean hasSplit() {
        return this.m_bSplitContent || this.m_bSplitCaption;
    }

    @Override
    public boolean isFontSubstituted() {
        boolean bIsFontSubstituted = false;
        TextDisplay pDisp = this.getCaptionDisplay();
        if (pDisp != null) {
            bIsFontSubstituted = pDisp.hasFontSubstitution();
        }
        if (!bIsFontSubstituted && (pDisp = this.getContentDisplay()) != null) {
            bIsFontSubstituted = pDisp.hasFontSubstitution();
        }
        return bIsFontSubstituted;
    }

    @Override
    public boolean hasGrowableW() {
        return super.hasGrowableW() || this.m_bForcedGrowableW;
    }

    @Override
    public boolean hasGrowableH() {
        return super.hasGrowableH() || this.m_bForcedGrowableH;
    }

    public void setForcedGrowableW(boolean bForcedGrowableW) {
        this.m_bForcedGrowableW = bForcedGrowableW;
    }

    public void setForcedGrowableH(boolean bForcedGrowableH) {
        this.m_bForcedGrowableH = bForcedGrowableH;
    }

    public boolean hasForcedGrowableW() {
        return this.m_bForcedGrowableW;
    }

    public boolean hasForcedGrowableH() {
        return this.m_bForcedGrowableH;
    }

    public boolean getContentRange(ObjectHolder<TextPosn> oStartPosn, ObjectHolder<TextPosn> oEndPosn) {
        oStartPosn.value = this.m_oStartContentPosn;
        oEndPosn.value = this.m_oEndContentPosn;
        return this.hasSplit();
    }

    public boolean getComb(Element oNode, Element oCurrentUI, IntegerHolder nNumCells) {
        if (oNode == null) {
            return false;
        }
        boolean bIsComb = false;
        nNumCells.value = 0;
        Element oCombNode = oCurrentUI.peekElement(XFA.COMBTAG, false, 0);
        if (oCombNode != null) {
            bIsComb = true;
            Int oCells = (Int)oCombNode.getAttribute(XFA.NUMBEROFCELLSTAG);
            nNumCells.value = oCells.getValue();
            if (nNumCells.value < 1) {
                Int oMaxChars;
                Element oTextNode;
                nNumCells.value = 1;
                Element oValueNode = oNode.peekElement(XFA.VALUETAG, false, 0);
                if (oValueNode != null && (oTextNode = oValueNode.peekElement(XFA.TEXTTAG, false, 0)) != null && (oMaxChars = (Int)oTextNode.getAttribute(XFA.MAXCHARSTAG)) != null) {
                    nNumCells.value = oMaxChars.getValue();
                    if (nNumCells.value < 1) {
                        nNumCells.value = 1;
                    }
                }
            }
        }
        return bIsComb;
    }

    public boolean getKeepContentTextStreamFlag() {
        return this.m_bKeepContentTextStream;
    }

    public void setKeepContentTextStreamFlag(boolean bKeepTextStream) {
        this.m_bKeepContentTextStream = bKeepTextStream;
    }

    @Override
    public void update(Element oNode) {
        assert (!this.m_bWasRotated);
        if (!(this.m_bGrowableW || this.m_bGrowableH || this.m_bForcedGrowableW || this.m_bForcedGrowableH)) {
            return;
        }
        if (this.m_bWasRotated) {
            return;
        }
        this.format(oNode);
        this.initVisualExtent(oNode);
    }

    public TextDisplay getContentDisplay() {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "BoxModelContent#getContentDisplay");
    }

    public TextRegion getContent() {
        return null;
    }

    public TextRange getContentRangeAttrs() {
        return null;
    }

    public UnitSpan calculateSplitPoint(UnitSpan oSuggestedVSplit) {
        if (oSuggestedVSplit.gt(UnitSpan.ZERO) && oSuggestedVSplit.lte(this.getHeight())) {
            if (oSuggestedVSplit.lt(this.m_oContentExtent.top())) {
                return UnitSpan.ZERO;
            }
            if (oSuggestedVSplit.gt(this.m_oContentExtent.bottom())) {
                return this.m_oContentExtent.bottom();
            }
            if (null != this.getContentDisplay()) {
                Rect oLineRect;
                UnitSpan oTextContentSplitPt = UnitSpan.ZERO;
                if (!this.m_bSplitContent) {
                    this.m_oContentDisplayExtent = this.m_oContentDisplayExtent.width(this.getContentExtent().width(), false);
                    this.m_oContentDisplayExtent = this.m_oContentDisplayExtent.height(this.getContentExtent().height(), false);
                }
                if ((oLineRect = Rect.ZERO).height().gt(this.m_oContentDisplayExtent.bottom().subtract(oTextContentSplitPt))) {
                    throw new ExFull(ResId.UNSUPPORTED_OPERATION, "BoxModelContent#calculateSplitPoint");
                }
                if (oLineRect.bottom().gt(this.m_oContentDisplayExtent.top().add(oTextContentSplitPt))) {
                    return UnitSpan.ZERO;
                }
                if (UnitSpan.ZERO.gt(oTextContentSplitPt)) {
                    return UnitSpan.ZERO;
                }
                return oTextContentSplitPt.add(this.m_oContentExtent.top()).subtract(this.m_oContentDisplayExtent.top());
            }
        }
        return UnitSpan.ZERO;
    }

    protected void format(Element oNode) {
        Rect oRuntimeExtent;
        UnitSpan oCapSpaceW = UnitSpan.ZERO;
        UnitSpan oCapSpaceH = UnitSpan.ZERO;
        UnitSpan oCapStreamMinH = UnitSpan.ZERO;
        UnitSpan oCapStreamMaxH = UnitSpan.ZERO;
        UnitSpan oCapStreamMinW = UnitSpan.ZERO;
        UnitSpan oCapStreamMaxW = UnitSpan.ZERO;
        UnitSpan oConStreamMinH = UnitSpan.ZERO;
        UnitSpan oConStreamMaxH = UnitSpan.ZERO;
        UnitSpan oConStreamMinW = UnitSpan.ZERO;
        UnitSpan oConStreamMaxW = UnitSpan.ZERO;
        UnitSpan oCaptionExtentW = UnitSpan.ZERO;
        UnitSpan oCaptionExtentH = UnitSpan.ZERO;
        UnitSpan oContentExtentW = UnitSpan.ZERO;
        UnitSpan oContentExtentH = UnitSpan.ZERO;
        Margins oCapMargins = this.getCaptionExtentMargins();
        Margins oConMargins = this.getContentExtentMargins();
        Margins oNEMargins = this.getNominalExtentMargins();
        UnitSpan oCapLeftRightMargins = oCapMargins.marginLeft().add(oCapMargins.marginRight());
        UnitSpan oCapTopBottomMargins = oCapMargins.marginTop().add(oCapMargins.marginBottom());
        UnitSpan oConLeftRightMargins = oConMargins.marginLeft().add(oConMargins.marginRight());
        UnitSpan oConTopBottomMargins = oConMargins.marginTop().add(oConMargins.marginBottom());
        UnitSpan oNELeftRightMargins = oNEMargins.marginLeft().add(oNEMargins.marginRight());
        UnitSpan oNETopBottomMargins = oNEMargins.marginTop().add(oNEMargins.marginBottom());
        if (this.m_bHasCaption) {
            assert (0x400004 != this.m_eCaptionPlacement);
            if (0x400003 == this.m_eCaptionPlacement || 0x400001 == this.m_eCaptionPlacement) {
                oCapStreamMinH = this.m_oMinH.subtract(oNETopBottomMargins).subtract(oCapTopBottomMargins);
                oCapStreamMaxH = this.m_bGrowableH && this.m_bInfiniteMaxH ? new UnitSpan(3, -1) : this.m_oMaxH.subtract(oNETopBottomMargins).subtract(oCapTopBottomMargins);
                if (this.m_bReserveCaptionSpace) {
                    oCapStreamMaxW = oCapStreamMinW = this.m_oReserveCaptionSpace.subtract(oCapLeftRightMargins);
                } else {
                    oCapStreamMinW = this.m_oMinW.subtract(oNELeftRightMargins).subtract(oCapLeftRightMargins);
                    oCapStreamMaxW = this.m_bGrowableW && this.m_bInfiniteMaxW ? new UnitSpan(3, -1) : this.m_oMaxW.subtract(oNELeftRightMargins).subtract(oCapLeftRightMargins);
                }
            } else if (0x400000 == this.m_eCaptionPlacement || 0x400002 == this.m_eCaptionPlacement) {
                oCapStreamMinW = this.m_oMinW.subtract(oNELeftRightMargins).subtract(oCapLeftRightMargins);
                oCapStreamMaxW = this.m_bGrowableW && this.m_bInfiniteMaxW ? new UnitSpan(3, -1) : this.m_oMaxW.subtract(oNELeftRightMargins).subtract(oCapLeftRightMargins);
                if (this.m_bReserveCaptionSpace) {
                    oCapStreamMaxH = oCapStreamMinH = this.m_oReserveCaptionSpace.subtract(oCapTopBottomMargins);
                } else {
                    oCapStreamMinH = this.m_oMinH.subtract(oNETopBottomMargins.subtract(oCapTopBottomMargins));
                    oCapStreamMaxH = this.m_bGrowableH && this.m_bInfiniteMaxH ? new UnitSpan(3, -1) : this.m_oMaxH.subtract(oNETopBottomMargins).subtract(oCapTopBottomMargins);
                }
            }
            if (oCapStreamMinW.lt(UnitSpan.ZERO)) {
                oCapStreamMinW = UnitSpan.ZERO;
            }
            if (oCapStreamMinH.lt(UnitSpan.ZERO)) {
                oCapStreamMinH = UnitSpan.ZERO;
            }
            if (!this.m_bSplitCaption) {
                // empty if block
            }
            if (0x400003 == this.m_eCaptionPlacement || 0x400001 == this.m_eCaptionPlacement) {
                if (this.m_bReserveCaptionSpace) {
                    assert (oCapStreamMinW.equals(oCapStreamMaxW));
                    oCaptionExtentW = oCapStreamMaxW;
                }
                if (!this.m_bGrowableH) {
                    oCaptionExtentH = oCapStreamMaxH;
                }
                oCapSpaceW = oCaptionExtentW.add(oCapLeftRightMargins);
                oCapSpaceH = UnitSpan.ZERO;
            } else if (0x400000 == this.m_eCaptionPlacement || 0x400002 == this.m_eCaptionPlacement) {
                if (this.m_bReserveCaptionSpace) {
                    assert (oCapStreamMinH.equals(oCapStreamMaxH));
                } else {
                    throw new ExFull(ResId.UNSUPPORTED_OPERATION, "BoxModelContent#format");
                }
                oCaptionExtentH = oCapStreamMaxH;
                if (!this.m_bGrowableW) {
                    oCaptionExtentW = oCapStreamMaxW;
                }
                oCapSpaceH = oCaptionExtentH.add(oCapTopBottomMargins);
                oCapSpaceW = UnitSpan.ZERO;
            }
        }
        oConStreamMinW = this.m_oMinW.subtract(oNELeftRightMargins).subtract(oConLeftRightMargins).subtract(oCapSpaceW);
        oConStreamMaxW = this.m_oMaxW.subtract(oNELeftRightMargins).subtract(oConLeftRightMargins).subtract(oCapSpaceW);
        oConStreamMinH = this.m_oMinH.subtract(oNETopBottomMargins).subtract(oConTopBottomMargins).subtract(oCapSpaceH);
        oConStreamMaxH = this.m_oMaxH.subtract(oNETopBottomMargins).subtract(oConTopBottomMargins).subtract(oCapSpaceH);
        if (oConStreamMinW.lt(UnitSpan.ZERO)) {
            oConStreamMinW = UnitSpan.ZERO;
        }
        if (oConStreamMinH.lt(UnitSpan.ZERO)) {
            oConStreamMinH = UnitSpan.ZERO;
        }
        if (this.m_bGrowableW && this.m_bInfiniteMaxW || this.m_bForcedGrowableW) {
            oConStreamMaxW = new UnitSpan(3, -1);
        } else if (oConStreamMaxW.lt(UnitSpan.ZERO)) {
            oConStreamMaxW = UnitSpan.ZERO;
        }
        if (this.m_bGrowableH && this.m_bInfiniteMaxH || this.m_bForcedGrowableH) {
            oConStreamMaxH = new UnitSpan(3, -1);
        } else if (oConStreamMaxH.lt(UnitSpan.ZERO)) {
            oConStreamMaxH = UnitSpan.ZERO;
        }
        this.createDisplay(oConStreamMinW, oConStreamMaxW, oConStreamMinH, oConStreamMaxH);
        if (this.m_bGrowableW || this.m_bForcedGrowableW) {
            oRuntimeExtent = this.m_bSplitContent ? this.m_oContentDisplayExtent : this.getContentDisplay().runtimeExtent();
            oContentExtentW = oRuntimeExtent.right();
            if (oContentExtentW.lt(oConStreamMinW)) {
                oContentExtentW = oConStreamMinW;
            } else if (!this.m_bForcedGrowableW && oContentExtentW.gt(oConStreamMaxW) && !this.m_bInfiniteMaxW) {
                oContentExtentW = oConStreamMaxW;
            }
            assert (!oContentExtentW.gt(oConStreamMaxW) || this.m_bInfiniteMaxW || this.m_bForcedGrowableW);
        } else {
            assert (oConStreamMinW.equals(oConStreamMaxW));
            oContentExtentW = oConStreamMaxW;
        }
        if (this.m_bGrowableH || this.m_bForcedGrowableH) {
            oRuntimeExtent = this.m_bSplitContent ? this.m_oContentDisplayExtent : this.getContentDisplay().runtimeExtent();
            oContentExtentH = oRuntimeExtent.height();
            if (oContentExtentH.lt(oConStreamMinH)) {
                oContentExtentH = oConStreamMinH;
            } else if (!this.m_bForcedGrowableH && oContentExtentH.gt(oConStreamMaxH) && !this.m_bInfiniteMaxH) {
                oContentExtentH = oConStreamMaxH;
            }
            assert (!oContentExtentH.gt(oConStreamMaxH) || this.m_bInfiniteMaxH || this.m_bForcedGrowableH);
        } else {
            assert (oConStreamMinH.equals(oConStreamMaxH));
            oContentExtentH = oConStreamMaxH;
        }
        if (this.m_bHasCaption) {
            if (0x400003 == this.m_eCaptionPlacement) {
                this.m_oNE = this.m_oNE.width(oNELeftRightMargins.add(oCapLeftRightMargins).add(oCaptionExtentW).add(oConLeftRightMargins).add(oContentExtentW), false);
                if (oContentExtentH.add(oConTopBottomMargins).gt(oCaptionExtentH.add(oCapTopBottomMargins))) {
                    this.m_oNE = this.m_oNE.height(oNETopBottomMargins.add(oContentExtentH).add(oConTopBottomMargins), false);
                    oCaptionExtentH = oContentExtentH.add(oConTopBottomMargins).subtract(oCapTopBottomMargins);
                } else if (this.m_bSplitCaption) {
                    this.m_oNE = this.m_oNE.height(oNETopBottomMargins.add(oContentExtentH).add(oConTopBottomMargins), false);
                    oCaptionExtentH = this.m_oNE.height().subtract(oCapTopBottomMargins).add(oNETopBottomMargins);
                    this.m_oCaptionDisplayExtent = this.m_oCaptionDisplayExtent.height(oCaptionExtentH, false);
                } else {
                    this.m_oNE = this.m_oNE.height(oNETopBottomMargins.add(oCaptionExtentH).add(oCapTopBottomMargins), false);
                    oContentExtentH = oCaptionExtentH.add(oCapTopBottomMargins).subtract(oConTopBottomMargins);
                }
                this.m_oCaptionExtent = this.m_oCaptionExtent.leftWidth(oNEMargins.marginLeft().add(oCapMargins.marginLeft()), oCaptionExtentW);
                this.m_oCaptionExtent = this.m_oCaptionExtent.topHeight(oNEMargins.marginTop().add(oCapMargins.marginTop()), oCaptionExtentH);
                this.m_oContentExtent = this.m_oContentExtent.leftWidth(oNEMargins.marginLeft().add(oCapLeftRightMargins).add(oCaptionExtentW).add(oConMargins.marginLeft()), oContentExtentW);
                this.m_oContentExtent = this.m_oContentExtent.topHeight(oNEMargins.marginTop().add(oConMargins.marginTop()), oContentExtentH);
            } else if (0x400001 == this.m_eCaptionPlacement) {
                this.m_oNE = this.m_oNE.width(oNELeftRightMargins.add(oCapLeftRightMargins).add(oCaptionExtentW).add(oConLeftRightMargins).add(oContentExtentW), false);
                if (oContentExtentH.add(oConTopBottomMargins).gt(oCaptionExtentH.add(oCapTopBottomMargins))) {
                    this.m_oNE = this.m_oNE.height(oNETopBottomMargins.add(oContentExtentH).add(oConTopBottomMargins), false);
                    oCaptionExtentH = oContentExtentH.add(oConTopBottomMargins).subtract(oCapTopBottomMargins);
                } else if (this.m_bSplitCaption) {
                    this.m_oNE = this.m_oNE.height(oNETopBottomMargins.add(oContentExtentH).add(oConTopBottomMargins), false);
                    oCaptionExtentH = this.m_oNE.height().subtract(oCapTopBottomMargins.add(oNETopBottomMargins));
                    this.m_oCaptionDisplayExtent = this.m_oCaptionDisplayExtent.height(oCaptionExtentH, false);
                } else {
                    this.m_oNE = this.m_oNE.height(oNETopBottomMargins.add(oCaptionExtentH).add(oCapTopBottomMargins), false);
                    oContentExtentH = oCaptionExtentH.add(oCapTopBottomMargins).subtract(oConTopBottomMargins);
                }
                this.m_oCaptionExtent = this.m_oCaptionExtent.leftWidth(oNEMargins.marginLeft().add(oConLeftRightMargins).add(oContentExtentW).add(oCapMargins.marginLeft()), oCaptionExtentW);
                this.m_oCaptionExtent = this.m_oCaptionExtent.topHeight(oNEMargins.marginTop().add(oCapMargins.marginTop()), oCaptionExtentH);
                this.m_oContentExtent = this.m_oContentExtent.leftWidth(oNEMargins.marginLeft().add(oConMargins.marginLeft()), oContentExtentW);
                this.m_oContentExtent = this.m_oContentExtent.topHeight(oNEMargins.marginTop().add(oConMargins.marginTop()), oContentExtentH);
            } else if (0x400000 == this.m_eCaptionPlacement) {
                this.m_oNE = this.m_oNE.height(oNETopBottomMargins.add(oCapTopBottomMargins).add(oCaptionExtentH).add(oConTopBottomMargins).add(oContentExtentH), false);
                if (oContentExtentW.add(oConLeftRightMargins).gt(oCaptionExtentW.add(oCapLeftRightMargins))) {
                    this.m_oNE = this.m_oNE.width(oNELeftRightMargins.add(oContentExtentW).add(oConLeftRightMargins), false);
                    oCaptionExtentW = oContentExtentW.add(oConLeftRightMargins).subtract(oCapLeftRightMargins);
                } else {
                    this.m_oNE = this.m_oNE.width(oNELeftRightMargins.add(oCaptionExtentW).add(oCapLeftRightMargins), false);
                    oContentExtentW = oCaptionExtentW.add(oCapLeftRightMargins).subtract(oConLeftRightMargins);
                }
                this.m_oCaptionExtent = this.m_oCaptionExtent.leftWidth(oNEMargins.marginLeft().add(oCapMargins.marginLeft()), oCaptionExtentW);
                this.m_oCaptionExtent = this.m_oCaptionExtent.topHeight(oNEMargins.marginTop().add(oCapMargins.marginTop()), oCaptionExtentH);
                this.m_oContentExtent = this.m_oContentExtent.leftWidth(oNEMargins.marginLeft().add(oConMargins.marginLeft()), oContentExtentW);
                this.m_oContentExtent = this.m_oContentExtent.topHeight(oNEMargins.marginTop().add(oCapTopBottomMargins).add(oCaptionExtentH).add(oConMargins.marginTop()), oContentExtentH);
            } else if (0x400002 == this.m_eCaptionPlacement) {
                this.m_oNE = this.m_oNE.height(oNETopBottomMargins.add(oCapTopBottomMargins).add(oCaptionExtentH).add(oConTopBottomMargins).add(oContentExtentH), false);
                if (oContentExtentW.add(oConLeftRightMargins).gt(oCaptionExtentW.add(oCapLeftRightMargins))) {
                    this.m_oNE = this.m_oNE.width(oNELeftRightMargins.add(oContentExtentW).add(oConLeftRightMargins), false);
                    oCaptionExtentW = oContentExtentW.add(oConLeftRightMargins).subtract(oCapLeftRightMargins);
                } else {
                    this.m_oNE = this.m_oNE.width(oNELeftRightMargins.add(oCaptionExtentW).add(oCapLeftRightMargins), false);
                    oContentExtentW = oCaptionExtentW.add(oCapLeftRightMargins).subtract(oConLeftRightMargins);
                }
                this.m_oCaptionExtent = this.m_oCaptionExtent.leftWidth(oNEMargins.marginLeft().add(oCapMargins.marginLeft()), oCaptionExtentW);
                this.m_oCaptionExtent = this.m_oCaptionExtent.topHeight(oNEMargins.marginTop().add(oConTopBottomMargins).add(oContentExtentH).add(oCapMargins.marginTop()), oCaptionExtentH);
                this.m_oContentExtent = this.m_oContentExtent.leftWidth(oNEMargins.marginLeft().add(oConMargins.marginLeft()), oContentExtentW);
                this.m_oContentExtent = this.m_oContentExtent.topHeight(oNEMargins.marginTop().add(oConMargins.marginTop()), oContentExtentH);
            } else assert (false);
            if (!this.m_bSplitCaption) {
                // empty if block
            }
            if (!this.m_bSplitContent) {
                // empty if block
            }
        } else {
            this.m_oCaptionExtent = Rect.ZERO;
            this.m_oContentExtent = this.m_oContentExtent.leftWidth(oNEMargins.marginLeft().add(oConMargins.marginLeft()), oContentExtentW);
            this.m_oContentExtent = this.m_oContentExtent.topHeight(oNEMargins.marginTop().add(oConMargins.marginTop()), oContentExtentH);
            if (!this.m_bSplitContent) {
                // empty if block
            }
            this.m_oNE = this.m_oNE.height(oNETopBottomMargins.add(oConTopBottomMargins).add(oContentExtentH), false);
            this.m_oNE = this.m_oNE.width(oNELeftRightMargins.add(oContentExtentW).add(oConLeftRightMargins), false);
        }
        if (!this.m_bGrowableW && !this.m_bForcedGrowableW) {
            assert (this.m_oMaxW.equals(this.m_oMinW));
            this.m_oNE = this.m_oNE.width(this.m_oMaxW, false);
        }
        if (!this.m_bGrowableH && !this.m_bForcedGrowableH) {
            assert (this.m_oMaxH.equals(this.m_oMinH));
            this.m_oNE = this.m_oNE.height(this.m_oMaxH, false);
        }
    }

    protected void initContent(Element oNode) {
        assert (oNode instanceof Draw || oNode instanceof Field);
        if (this.isProxy() && oNode instanceof Draw) {
            return;
        }
        Element oValue = oNode.peekElement(XFA.VALUETAG, true, 0);
        Content oContent = (Content)oValue.getOneOfChild(true, true);
        UI oUI = (UI)oNode.peekElement(XFA.UITAG, true, 0);
        Element oCurrentUI = oUI.getUIElement(false);
        boolean bRichContent = false;
        boolean bIsField = oNode instanceof Field;
        boolean bPasswordEdit = false;
        char uPasswordChar = '\u0000';
        String sLang = oNode.getInstalledLocale();
        boolean bIsLocaleSpecified = !StringUtils.isEmpty(sLang);
        int oCurrentUITag = oCurrentUI.getClassTag();
        if (oCurrentUITag == XFA.PASSWORDEDITTAG && bIsField) {
            String sPasswordChar;
            bPasswordEdit = true;
            String oPasswordChar = oCurrentUI.peekAttribute(XFA.PASSWORDCHARTAG).toString();
            if (oPasswordChar != null && !StringUtils.isEmpty(sPasswordChar = oPasswordChar)) {
                uPasswordChar = sPasswordChar.charAt(0);
            }
            if (uPasswordChar == '\u0000') {
                uPasswordChar = '*';
            }
        }
        if (oContent instanceof ExDataValue) {
            String sContentType = oContent.getAttribute(XFA.CONTENTTYPETAG).toString();
            bRichContent = "text/html".equals(sContentType);
        }
        if (!this.m_bKeepContentTextStream) {
            TextPosnBase oPosn;
            AppModel appModel;
            boolean bLegacy;
            String sRichText;
            this.m_oAmbientTextAttr.transparent(true);
            this.m_oAmbientTextAttr.fontService(this.m_oGfxLayoutEnv.fontService());
            Element oPara = oNode.peekElement(XFA.PARATAG, true, 0);
            int eVAlign = oPara.getEnum(XFA.VALIGNTAG);
            this.setVertAlign(eVAlign, this.m_oAmbientTextAttr);
            int eHAlign = oPara.getEnum(XFA.HALIGNTAG);
            if (1441796 == eHAlign && this.hasGrowableW()) {
                eHAlign = 1441795;
            }
            this.setHorizAlign(eHAlign, this.m_oAmbientTextAttr);
            if (1441797 == eHAlign) {
                UnitSpan oRO = new Measurement(oPara.getAttribute(XFA.RADIXOFFSETTAG)).getUnitSpan();
                this.m_oAmbientTextAttr.radixOffset(new TextMeasurement(oRO));
            }
            if (bIsLocaleSpecified) {
                this.m_oAmbientTextAttr.locale(sLang);
            }
            this.setFont(oNode.peekElement(XFA.FONTTAG, true, 0), oPara, true, this.m_oAmbientTextAttr, sLang);
            if (bIsField) {
                StringBuilder sSub;
                StringBuilder sLoc;
                StringBuilder sCat;
                Element oFormat = oNode.peekElement(XFA.FORMATTAG, false, 0);
                Picture oPicture = null;
                if (oFormat != null) {
                    oPicture = (Picture)oFormat.peekElement(XFA.PICTURETAG, false, 0);
                }
                String sPicture = "";
                if (oPicture != null) {
                    sPicture = oPicture.getValue();
                }
                if (!StringUtils.isEmpty(sPicture) && (PictureFmt.isSubPicture(sPicture, 0, sCat = new StringBuilder(), sLoc = new StringBuilder(), sSub = new StringBuilder()) && sCat.toString().equals("num") || PictureFmt.isNumericPicture(sPicture))) {
                    if (StringUtils.isEmpty(sSub)) {
                        sSub.append(sPicture);
                    }
                    if (StringUtils.isEmpty(sLoc)) {
                        sLoc.append(sLang);
                    }
                    LcLocale oLocale = new LcLocale(sLoc.toString());
                    this.m_oAmbientTextAttr.locale(oLocale.getIsoName());
                    String sRawTextContent = ((Field)oNode).getRawValue();
                    LcNum oNum = new LcNum(sRawTextContent, sLoc.toString());
                    IntegerHolder oRadixPos = new IntegerHolder();
                    String sRes = oNum.format(sSub.toString(), oRadixPos);
                    if (!StringUtils.isEmpty(sRes)) {
                        this.m_oAmbientTextAttr.radixPos(oRadixPos.value);
                    }
                }
                this.setTabs(oPara.getAttribute(XFA.TABSDEFAULTTAG), oPara.getAttribute(XFA.TABSTOPSTAG), this.m_oAmbientTextAttr);
            }
            if (bPasswordEdit) {
                this.m_oAmbientTextAttr.invisible(true);
                this.m_oAmbientTextAttr.invisChar(uPasswordChar);
            }
            if (!bRichContent || StringUtils.isEmpty(sRichText = ((ExDataValue)oContent).getValue(true, false, bLegacy = (appModel = oContent.getAppModel()).getLegacySetting(AppModel.XFA_LEGACY_V27_XHTMLVERSIONPROCESSING))) || null != this.m_oGfxLayoutEnv.getTextResolver()) {
                // empty if block
            }
            if (this.hasInlineCaption() && null != this.getCaption()) {
                oPosn = new TextPosnBase(this.getContent());
                oPosn.first();
            }
            oPosn = new TextPosnBase(this.getContent());
            this.m_oStartContentPosn = new TextPosn(oPosn);
            this.m_oEndContentPosn = new TextPosn(oPosn);
            this.m_oStartContentPosn.first();
            this.m_oEndContentPosn.last();
        }
    }

    @Override
    public boolean hasEmbeddedContent() {
        return this.m_bEmbeddedContent;
    }

    protected void createDisplay(UnitSpan minW, UnitSpan maxW, UnitSpan minH, UnitSpan maxH) {
        if (!this.m_bSplitContent) {
            // empty if block
        }
    }

    private void initializeSplit(Element oNode, Rect oContentRect, Rect oCaptionRect) {
        assert (oNode != null);
        assert (this.isBoxModelCompatible(oNode));
        if (!this.isBoxModelCompatible(oNode)) {
            return;
        }
        this.initWidthHeight(oNode, true);
        this.initAnchorPoint(oNode);
        this.initMargins(oNode);
        this.initBorder(oNode);
        this.initSplitCaption(oNode, oCaptionRect);
        this.initSplitContent(oNode, oContentRect);
        this.format(oNode);
        this.initVisualExtent(oNode);
    }

    private void initSplitContent(Element oNode, Rect oRect) {
        if (!this.m_bHasCaption) {
            return;
        }
        this.m_oCaptionDisplayExtent = oRect;
        assert (null != this.getCaption());
        assert (null != this.getCaptionDisplay());
    }

    private void initSplitCaption(Element oNode, Rect oRect) {
        this.m_oContentDisplayExtent = oRect;
        assert (null != this.getContent());
        assert (null != this.getContentDisplay());
    }

    @Override
    public boolean hasOverflowingContentText() {
        return false;
    }
}

