/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.gfx;

import com.adobe.xfa.gfx.GFXMapping;
import com.adobe.xfa.ut.Storage;
import java.util.Collections;
import java.util.Comparator;

public class GFXMappingList {
    public static final int MAPPING_ERR_CHAR_OVERLAP = 0;
    public static final int MAPPING_ERR_CHAR_UNMAPPED = 1;
    public static final int MAPPING_ERR_CHAR_MAP_RANGE = 2;
    public static final int MAPPING_ERR_GLYPH_OVERLAP = 3;
    public static final int MAPPING_ERR_GLYPH_UNMAPPED = 4;
    public static final int MAPPING_ERR_GLYPH_MAP_RANGE = 5;
    private final Storage<GFXMapping> moMappings = new Storage();

    public GFXMappingList() {
    }

    public GFXMappingList(int nSizeHint, boolean bAutoMap) {
        if (bAutoMap) {
            this.autoMap(nSizeHint);
        } else {
            this.moMappings.ensureCapacity(nSizeHint);
        }
    }

    public GFXMappingList(int nSizeHint) {
        this(nSizeHint, false);
    }

    public GFXMappingList(GFXMappingList source) {
        this.copyFrom(source);
    }

    public void reset() {
        this.moMappings.setSize(0);
    }

    public void autoMap(int nMappings) {
        this.moMappings.setSize(nMappings);
        for (int i = 0; i < nMappings; ++i) {
            this.moMappings.set(i, new GFXMapping(i, i));
        }
    }

    public void addMapping(GFXMapping oMapping) {
        this.moMappings.add(oMapping);
    }

    public void addMapping(int nCharStart, int nGlyphStart, int nCharLength, int nGlyphLength) {
        this.moMappings.add(new GFXMapping(nCharStart, nGlyphStart, nCharLength, nGlyphLength));
    }

    public void addMapping(int nCharStart, int nGlyphStart, int nCharLength) {
        this.addMapping(nCharStart, nGlyphStart, nCharLength, 1);
    }

    public void addMapping(int nCharStart, int nGlyphStart) {
        this.addMapping(nCharStart, nGlyphStart, 1, 1);
    }

    public int getMappingCount() {
        return this.moMappings.size();
    }

    public GFXMapping getMapping(int nIndex) {
        return (GFXMapping)this.moMappings.get(nIndex);
    }

    public void validate(int pnExpectedChars, int pnExpectedGlyphs) {
        this.validateMappings(false, pnExpectedChars, 0, 1, 2);
        this.validateMappings(true, pnExpectedGlyphs, 3, 4, 5);
    }

    public void validate(int pnExpectedChars) {
        this.validate(pnExpectedChars, -1);
    }

    public void validate() {
        this.validate(-1, -1);
    }

    public void orderByCharacter() {
        this.sortMappings(false);
    }

    public void orderByGlyph() {
        this.sortMappings(true);
    }

    public void copyFrom(GFXMappingList source) {
        int size = source.moMappings.size();
        this.moMappings.setSize(size);
        for (int i = 0; i < size; ++i) {
            this.moMappings.set(i, new GFXMapping(source.getMapping(i)));
        }
    }

    private void validateMappings(boolean bGlyph, int pnExpected, int nErrorDuplicate, int nErrorMissing, int nErrorOverflow) {
        int i;
        int nMinIndex = 0;
        int nIndexCount = 0;
        if (pnExpected < 0) {
            nMinIndex = Integer.MAX_VALUE;
            int nMaxIndex = 0;
            for (i = 0; i < this.moMappings.size(); ++i) {
                GFXMapping oMapping = this.getMapping(i);
                int nLow = oMapping.getLowestIndex(bGlyph);
                int nHigh = oMapping.getHighestIndex(bGlyph);
                if (nLow < nMinIndex) {
                    nMinIndex = nLow;
                }
                if (nHigh <= nMaxIndex) continue;
                nMaxIndex = nHigh;
            }
            if (nMinIndex <= nMaxIndex) {
                nIndexCount = nMaxIndex + nMinIndex + 1;
            }
        } else {
            nMinIndex = 0;
            nIndexCount = pnExpected;
        }
        boolean[] oVisited = null;
        if (nIndexCount > 0) {
            oVisited = new boolean[nIndexCount];
            for (i = 0; i < nIndexCount; ++i) {
                oVisited[i] = false;
            }
        }
        int nIndexLimit = nMinIndex + nIndexCount;
        for (i = 0; i < this.moMappings.size(); ++i) {
            GFXMapping oMapping = this.getMapping(i);
            int nCount = oMapping.getCount(bGlyph);
            for (int j = 0; j < nCount; ++j) {
                int nIndex = oMapping.getIndex(bGlyph, j);
                if (nIndex >= nIndexLimit) {
                    GFXMappingList.throwError(nErrorOverflow, nIndex);
                }
                int nVisitedIndex = nIndex - nMinIndex;
                if (oVisited != null && oVisited[nVisitedIndex]) {
                    GFXMappingList.throwError(nErrorDuplicate, nIndex);
                }
                oVisited[nVisitedIndex] = true;
            }
        }
        if (pnExpected >= 0) {
            for (i = 0; i < nIndexCount; ++i) {
                if (oVisited[i]) continue;
                GFXMappingList.throwError(nErrorMissing, i);
            }
        }
    }

    private void sortMappings(final boolean bGlyph) {
        Collections.sort(this.moMappings, new Comparator<GFXMapping>(){

            @Override
            public int compare(GFXMapping mapping1, GFXMapping mapping2) {
                int lowestIndex2;
                int lowestIndex1 = mapping1.getLowestIndex(bGlyph);
                return lowestIndex1 < (lowestIndex2 = mapping2.getLowestIndex(bGlyph)) ? -1 : (lowestIndex1 > lowestIndex2 ? 1 : 0);
            }
        });
    }

    private static void throwError(int nError, int nValue) {
        assert (false);
    }
}

