/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Arg;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.EventManager;
import com.adobe.xfa.Int;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.ScriptDispatcher;
import com.adobe.xfa.XFA;
import com.adobe.xfa.form.FormDependencyTracker;
import com.adobe.xfa.form.FormExclGroup;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.form.FormSubform;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.Numeric;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;

class CalculateDispatcher
extends ScriptDispatcher {
    private final int meRunAt;

    CalculateDispatcher(Element scriptContextNode, String sEventContext, int nEventID, EventManager eventManager, String sScript, String sContentType, int eRunAt) {
        super(scriptContextNode, sEventContext, nEventID, eventManager, sScript, sContentType);
        this.meRunAt = eRunAt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch() {
        Container container;
        int ePresence;
        TemplateModel templateModel;
        Element node = this.getActionContextNode();
        if (node == null) {
            return;
        }
        String sScript = this.getScript();
        String sContentType = this.getContentType();
        assert (node instanceof FormField || node instanceof FormSubform || node instanceof FormExclGroup);
        FormModel formModel = (FormModel)node.getModel();
        if (formModel.isActivityExcluded("calculate")) {
            return;
        }
        AppModel appModel = node.getAppModel();
        if (appModel != null && (templateModel = TemplateModel.getTemplateModel(appModel, false)) != null && templateModel.getOriginalXFAVersion() >= 30 && node instanceof Container && 1076494339 == (ePresence = (container = (Container)node).getRuntimePresence(0))) {
            return;
        }
        int eModelRunAtSetting = formModel.getRunScripts();
        int eRunAt = this.getRunAt();
        if (eModelRunAtSetting == 1080754179) {
            return;
        }
        if (eModelRunAtSetting == 1080754177 && eRunAt == 1079836672) {
            return;
        }
        if (eModelRunAtSetting == 1080754176 && eRunAt == 1079836673) {
            return;
        }
        int nNumErrorsBefore = formModel.getErrorList().size();
        formModel.removeDependency(node, true);
        FormDependencyTracker tracker = new FormDependencyTracker(node, true);
        try {
            int nNumErrorsOccurred;
            Arg returnCode = new Arg();
            boolean bCalcEnabled = formModel.getCalculationsEnabled();
            if (bCalcEnabled && node instanceof FormField) {
                FormField field = (FormField)node;
                Element value = field.getElement(XFA.VALUETAG, true, 0, false, false);
                if (value != null && value.getEnum(XFA.OVERRIDETAG) == 0x40040001 && !node.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_CALCOVERRIDE)) {
                    return;
                }
                returnCode = field.evaluate(sScript, sContentType, 1, true);
                String sReturnValue = null;
                if (8 != returnCode.getArgType() && 1 != returnCode.getArgType()) {
                    Node pContentNode;
                    if (2 != returnCode.getArgType()) {
                        sReturnValue = returnCode.getAsString(false);
                    }
                    String sRawValueOld = field.getRawValue();
                    boolean doContinueSettingNewRawValue = true;
                    Element pValueNode = field.getElement(XFA.VALUETAG, true, 0, false, false);
                    if (pValueNode != null && (pContentNode = pValueNode.getOneOfChild()) != null && (pContentNode.isSameClass(XFA.DECIMALTAG) || pContentNode.isSameClass(XFA.FLOATTAG)) && !StringUtils.isEmpty(sReturnValue) && !StringUtils.isEmpty(sRawValueOld)) {
                        double dReturnValue = Numeric.stringToDouble(sReturnValue, true);
                        double dRawValueOld = Numeric.stringToDouble(sRawValueOld, true);
                        if (!(Double.isInfinite(dReturnValue) || Double.isNaN(dReturnValue) || Double.isInfinite(dRawValueOld) || Double.isNaN(dRawValueOld))) {
                            String sRawValueOldNormalized;
                            String sReturnValueNormalized;
                            int fracDigits = 8;
                            if (pContentNode.isSameClass(XFA.DECIMALTAG)) {
                                Attribute fracDigitAttr = ((Element)pContentNode).getAttribute(XFA.FRACDIGITSTAG);
                                fracDigits = ((Int)fracDigitAttr).getValue();
                            }
                            boolean bl = doContinueSettingNewRawValue = !(sReturnValueNormalized = Numeric.doubleToStringUsingBigDecimal(dReturnValue, fracDigits, false)).equals(sRawValueOldNormalized = Numeric.doubleToStringUsingBigDecimal(dRawValueOld, fracDigits, false));
                        }
                    }
                    if (doContinueSettingNewRawValue && sReturnValue != null && !sReturnValue.equals(sRawValueOld)) {
                        field.setRawValue(sReturnValue);
                        String sRawValueNew = field.getRawValue();
                        if (!(null == sRawValueNew && null == sRawValueOld || null != sRawValueNew && sRawValueNew.equals(sRawValueOld) || node.checkAncestorPerms())) {
                            field.setRawValue(sRawValueOld);
                            MsgFormatPos message = new MsgFormatPos(ResId.PermissionsViolationExceptionMethod);
                            message.format("calculate");
                            throw new ExFull(message);
                        }
                    }
                }
            }
            if (bCalcEnabled && node instanceof FormExclGroup) {
                FormExclGroup exclGroup = (FormExclGroup)node;
                for (Node child = exclGroup.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    FormField formField;
                    Element value;
                    if (!(child instanceof FormField) || (value = (formField = (FormField)child).getElement(XFA.VALUETAG, true, 0, false, false)) == null || value.getEnum(XFA.OVERRIDETAG) != 0x40040001 || node.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_CALCOVERRIDE)) continue;
                    return;
                }
                returnCode = exclGroup.evaluate(sScript, sContentType, 1, true);
                String sReturnValue = "";
                if (8 != returnCode.getArgType() && 1 != returnCode.getArgType()) {
                    if (2 != returnCode.getArgType()) {
                        sReturnValue = returnCode.getAsString(false);
                    }
                    if (sReturnValue != null && !sReturnValue.equals(exclGroup.getRawValue())) {
                        if (!node.checkAncestorPerms()) {
                            MsgFormatPos message = new MsgFormatPos(ResId.PermissionsViolationExceptionMethod);
                            message.format("calculate");
                            throw new ExFull(message);
                        }
                        exclGroup.setRawValue(sReturnValue);
                    }
                }
            } else if (bCalcEnabled && node instanceof FormSubform) {
                FormSubform subform = (FormSubform)node;
                returnCode = subform.evaluate(sScript, sContentType, 1, true);
            }
            if (8 == returnCode.getArgType() && 0 < (nNumErrorsOccurred = formModel.getErrorList().size() - nNumErrorsBefore) && formModel.queueCalculate((ProtoableNode)node)) {
                for (int e = 0; e < nNumErrorsOccurred; ++e) {
                    formModel.removeLastError();
                }
                assert (nNumErrorsBefore == formModel.getErrorList().size());
            }
        }
        finally {
            tracker.dispose();
        }
    }

    int getRunAt() {
        return this.meRunAt;
    }

    @Override
    public void updateFromPeer(Object peerNode, int eventType, String arg1, Object arg2) {
        Element node = this.getActionContextNode();
        if (node == null) {
            return;
        }
        if (peerNode == node && node instanceof Container && eventType == 1 && arg1.equals("presence")) {
            FormModel formModel = (FormModel)node.getModel();
            formModel.queueCalculatesAndValidates(node, true);
        }
    }
}

