/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Arg;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.io.IOException;
import java.io.OutputStream;

public final class ProcessingInstruction
extends Node {
    private static final String mClassName = "processingInstruction";
    private String mData;
    private final String mName;
    private final Document mDoc;

    public ProcessingInstruction(Element parent, Node prevSibling, String name, String data) {
        super(parent, prevSibling);
        this.mName = name;
        this.mData = data;
        this.mDoc = null;
    }

    public ProcessingInstruction(Document doc, String name, String data) {
        super(null, null);
        this.mName = name;
        this.mData = data;
        this.mDoc = doc;
        if (doc != null) {
            this.mDoc.appendChild(this);
        }
    }

    @Override
    public Node clone(Element parent) {
        return new ProcessingInstruction(parent, null, this.mName, this.mData);
    }

    @Override
    public String getClassAtom() {
        return mClassName;
    }

    @Override
    public String getClassName() {
        return mClassName;
    }

    @Override
    public String getData() {
        return this.mData;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void postSave() {
    }

    @Override
    public void preSave(boolean bSaveXMLScript) {
    }

    @Override
    public void serialize(OutputStream outStream, DOMSaveOptions options, int level, Node prevSibling) throws IOException {
        if (level != 0 || prevSibling != null) {
            if (options.getDisplayFormat() == 2) {
                options.writeIndent(outStream, level);
            } else if (level == 0 && (options.getFormatOutside() || options.getDisplayFormat() == 1)) {
                outStream.write(Document.MarkupReturn);
            }
        }
        outStream.write(Document.MarkupPIStart);
        outStream.write(this.getName().getBytes("UTF-8"));
        String sData = this.getData();
        if (!StringUtils.isEmpty(sData)) {
            outStream.write(Document.MarkupSpace);
            outStream.write(sData.getBytes("UTF-8"));
        }
        outStream.write(Document.MarkupPIEnd);
    }

    public void setData(String data) {
        this.mData = data;
        this.setDirty();
    }

    public void setScriptProperty(String sPropertyName, Arg propertyValue) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "ProcessingInstruction#setScriptProperty");
    }
}

