/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xmp;

import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.XMPMetaFactory;
import com.adobe.internal.xmp.XMPSchemaRegistry;
import com.adobe.internal.xmp.options.ParseOptions;
import com.adobe.internal.xmp.options.SerializeOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class XMPMetaFactoryMonitor {
    private static Map<PDFDocument, Map<String, String>> docVsNameSpaces = new WeakHashMap<PDFDocument, Map<String, String>>();
    private static PDFDocument currentDoc = null;
    private static XMPMetaFactoryMonitor instance = null;
    static final int WAIT_REASONABLE_TIME = 60;
    private static final Lock myLock = new ReentrantLock();
    private static PDFDocument lockingDoc = null;

    private XMPMetaFactoryMonitor() {
    }

    @Deprecated
    public static synchronized XMPMetaFactoryMonitor getInstance(PDFDocument pdfDoc) {
        if (pdfDoc != null) {
            XMPMetaFactoryMonitor.setDoc(pdfDoc);
        }
        return XMPMetaFactoryMonitor.getMonitor();
    }

    private static void setDoc(PDFDocument pdfDoc) {
        if (currentDoc == null) {
            if (docVsNameSpaces.containsKey(pdfDoc)) {
                XMPMetaFactoryMonitor.pushNStoSchemaRegistry(pdfDoc);
            }
            currentDoc = pdfDoc;
            return;
        }
        if (pdfDoc.equals(currentDoc)) {
            return;
        }
        Map nameSpacesofCurrentDoc = XMPMetaFactory.getSchemaRegistry().getNamespaces();
        docVsNameSpaces.put(currentDoc, nameSpacesofCurrentDoc);
        if (docVsNameSpaces.get(pdfDoc) == null) {
            currentDoc = pdfDoc;
            return;
        }
        XMPMetaFactoryMonitor.pushNStoSchemaRegistry(pdfDoc);
        currentDoc = pdfDoc;
    }

    private static void pushNStoSchemaRegistry(PDFDocument pdfDoc) {
        for (Map.Entry<String, String> nsEntry : docVsNameSpaces.get(pdfDoc).entrySet()) {
            String namespace = nsEntry.getKey();
            if (XMPMetaFactory.getSchemaRegistry().getNamespacePrefix(namespace) != null) continue;
            try {
                XMPMetaFactory.getSchemaRegistry().registerNamespace(namespace, nsEntry.getValue());
                if (!PDFUtil.logDebugMessages()) continue;
                PDFUtil.logDebug("XMPMetaFactory.register namespace: " + namespace + ", val: " + nsEntry.getValue());
            }
            catch (XMPException e) {
                System.out.println("Exception in using XMP " + e.getMessage());
            }
        }
    }

    private static XMPMetaFactoryMonitor getMonitor() {
        if (instance == null) {
            instance = new XMPMetaFactoryMonitor();
        }
        return instance;
    }

    @Deprecated
    public XMPSchemaRegistry getSchemaRegistry() {
        return XMPMetaFactory.getSchemaRegistry();
    }

    public static synchronized XMPSchemaRegistry getSchemaRegistry(PDFDocument doc) {
        XMPMetaFactoryMonitor.setDoc(doc);
        return XMPMetaFactory.getSchemaRegistry();
    }

    @Deprecated
    public XMPMeta parse(InputStream in, ParseOptions options) throws XMPException {
        return XMPMetaFactory.parse(in, options);
    }

    public static synchronized XMPMeta parse(InputStream in, ParseOptions options, PDFDocument doc) throws XMPException {
        XMPMetaFactoryMonitor.setDoc(doc);
        return XMPMetaFactory.parse(in, options);
    }

    @Deprecated
    public XMPMeta parseFromString(String packet, ParseOptions options) throws XMPException {
        return XMPMetaFactory.parseFromString(packet, options);
    }

    public static synchronized XMPMeta parseFromString(String packet, ParseOptions options, PDFDocument doc) throws XMPException {
        XMPMetaFactoryMonitor.setDoc(doc);
        return XMPMetaFactory.parseFromString(packet, options);
    }

    @Deprecated
    public XMPMeta parseFromBuffer(byte[] buffer, ParseOptions options) throws XMPException {
        return XMPMetaFactory.parseFromBuffer(buffer, options);
    }

    public static synchronized XMPMeta parseFromBuffer(byte[] buffer, ParseOptions options, PDFDocument doc) throws XMPException {
        XMPMetaFactoryMonitor.setDoc(doc);
        return XMPMetaFactory.parseFromBuffer(buffer, options);
    }

    @Deprecated
    public void serialize(XMPMeta xmp, OutputStream out, SerializeOptions options) throws XMPException {
        XMPMetaFactory.serialize(xmp, out, options);
    }

    public static synchronized void serialize(XMPMeta xmp, OutputStream out, SerializeOptions options, PDFDocument doc) throws XMPException {
        XMPMetaFactoryMonitor.setDoc(doc);
        XMPMetaFactory.serialize(xmp, out, options);
    }

    @Deprecated
    public byte[] serializeToBuffer(XMPMeta xmp, SerializeOptions options) throws XMPException {
        return XMPMetaFactory.serializeToBuffer(xmp, options);
    }

    public static synchronized byte[] serializeToBuffer(XMPMeta xmp, SerializeOptions options, PDFDocument doc) throws XMPException {
        XMPMetaFactoryMonitor.setDoc(doc);
        return XMPMetaFactory.serializeToBuffer(xmp, options);
    }

    @Deprecated
    public String serializeToString(XMPMeta xmp, SerializeOptions options) throws XMPException {
        return XMPMetaFactory.serializeToString(xmp, options);
    }

    public static synchronized String serializeToString(XMPMeta xmp, SerializeOptions options, PDFDocument doc) throws XMPException {
        XMPMetaFactoryMonitor.setDoc(doc);
        return XMPMetaFactory.serializeToString(xmp, options);
    }

    @Deprecated
    public void reset() {
    }

    public static synchronized void reset(PDFDocument doc) {
        XMPMetaFactoryMonitor.setDoc(doc);
    }

    @Deprecated
    public synchronized void clear() {
        docVsNameSpaces.remove(currentDoc);
        currentDoc = null;
    }

    public static void clearNonSynchro(PDFDocument doc) {
        boolean isLockAcquired = false;
        try {
            isLockAcquired = myLock.tryLock(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            PDFUtil.logFailure("Failed to acquire lock: " + e.toString());
            e.printStackTrace();
        }
        try {
            XMPMetaFactoryMonitor.clear(doc);
        }
        finally {
            if (isLockAcquired) {
                myLock.unlock();
            }
        }
    }

    public static synchronized void clear(PDFDocument doc) {
        XMPMetaFactoryMonitor.setDoc(doc);
        docVsNameSpaces.remove(currentDoc);
        currentDoc = null;
    }

    public static boolean takeLock(PDFDocument doc) {
        boolean isLockAcquired = false;
        try {
            isLockAcquired = myLock.tryLock(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            PDFUtil.logFailure("Failed to acquire lock: " + e.toString());
            e.printStackTrace();
        }
        if (!isLockAcquired) {
            PDFUtil.logFailure("Assert condition. Unable to acquire lock");
            return false;
        }
        PDFUtil.logDebug("locked from document: " + doc);
        lockingDoc = doc;
        return true;
    }

    public static void releaseLock(PDFDocument doc) {
        boolean isLockAcquired = false;
        try {
            isLockAcquired = myLock.tryLock(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            PDFUtil.logFailure("Failed to acquire lock: " + e.toString());
            e.printStackTrace();
        }
        try {
            if (!doc.equals(lockingDoc)) {
                return;
            }
            myLock.unlock();
            lockingDoc = null;
            PDFUtil.logDebug("unlocked from document: " + doc);
        }
        finally {
            if (isLockAcquired) {
                myLock.unlock();
            }
        }
    }
}

