/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListener;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerProperties;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.LeanDocGenerator;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptHandler;
import com.adobe.internal.pdftoolkit.services.permissions.PermissionsManager;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFAProcessingOptions;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAUtils;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDFields;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.PDDoc2CPDFields;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.internal.pdftoolkit.services.xfa.form.Protocol;
import com.adobe.internal.pdftoolkit.services.xfa.form.XFAPlugin;
import com.adobe.xfa.template.containers.Field;
import java.util.HashMap;
import java.util.HashSet;

public class XFADOMServiceListener
implements DocumentListener {
    private XFADOM xfaDOM;
    private XFAProcessingOptions xfaOptions;
    private DocumentContext docContext = null;
    private CPDFields cpdFields = null;
    private Protocol protocol = null;
    private HashSet<String> generatedSignatureFields = null;
    private HashMap<String, SignatureFieldHolder> iteratedSigFields = null;
    private boolean leanDocGenerationEnabled = false;
    private boolean mergeIncrementalSectionsDuringLeanDoc = false;
    private PDFDocument pdfDoc = null;

    public XFADOMServiceListener(PDFDocument pdfDoc, XFADOM xfaDOM, XFAProcessingOptions xfaProcessingOptions) {
        this.pdfDoc = pdfDoc;
        this.xfaDOM = xfaDOM;
        this.xfaOptions = xfaProcessingOptions == null ? XFADOMServiceListener.createDefaultXFAProcessingOptions() : new XFAProcessingOptions(xfaProcessingOptions);
        if (this.xfaOptions.acrobatJavaScriptExecutionEnabled() && this.xfaOptions.getJavaScriptHandler() == null) {
            JavaScriptHandler jsHandler = JavaScriptHandler.getRegisteredInstance(pdfDoc);
            if (jsHandler == null) {
                try {
                    jsHandler = JavaScriptHandler.getInstance(pdfDoc, null, null, PermissionsManager.newInstance(pdfDoc), false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.xfaOptions.registerJavaScriptHandler(jsHandler);
        }
        boolean holdListenerStrongly = true;
        pdfDoc.getListenerRegistry().deregisterListener(XFADOMServiceListener.class);
        pdfDoc.getListenerRegistry().registerListener(XFADOMServiceListener.class, this);
        if (xfaProcessingOptions != null) {
            holdListenerStrongly = xfaProcessingOptions.xfaDOMCachingEnabled();
        }
        pdfDoc.getListenerRegistry().holdStrongly(XFADOMServiceListener.class, holdListenerStrongly);
    }

    private boolean shouldSaveXFA() {
        return this.xfaDOM != null && this.xfaDOM.getXFADocument() != null && this.xfaDOM.getXFADocument().isDirty();
    }

    @Override
    public void message(DocumentMessage message) throws PDFUnableToCompleteOperationException {
        DocumentMessage.MessageType messageType = message.getMessageType();
        if (messageType == DocumentMessage.CLOSE) {
            XFAPlugin.docClose(message.getDocument());
        } else {
            if (messageType == DocumentMessage.FINISH) {
                try {
                    if (this.shouldSaveXFA()) {
                        XFAUtils.saveXFA(this.pdfDoc);
                    }
                    PDDoc2CPDFields.DeleteCPDFieldsOnDidCloseProc(this.pdfDoc);
                }
                catch (PDFInvalidDocumentException e) {
                    throw new PDFUnableToCompleteOperationException("PDFInvalidDoc exception encountered when serializing XFA on the finish message", e);
                }
                catch (PDFIOException e) {
                    throw new PDFUnableToCompleteOperationException("PDFIO exception encountered when serializing XFA on the finish message", e);
                }
                catch (PDFSecurityException e) {
                    throw new PDFUnableToCompleteOperationException("PDFSecurity exception encountered when serializing XFA on the finish message", e);
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFUnableToCompleteOperationException("PDFInvalidParameter exception encountered when serializing XFA on the finish message", e);
                }
                finally {
                    XFAPlugin.docClose(message.getDocument());
                }
            }
            if (messageType == DocumentMessage.SAVE) {
                try {
                    if (this.leanDocGenerationEnabled && XFAService.getDocumentType(this.pdfDoc).isDynamic()) {
                        LeanDocGenerator.generateLeanDocument(this.pdfDoc, this.mergeIncrementalSectionsDuringLeanDoc);
                    }
                    if (this.shouldSaveXFA()) {
                        XFAUtils.saveXFA(this.pdfDoc, null);
                    }
                }
                catch (PDFInvalidDocumentException e) {
                    throw new PDFUnableToCompleteOperationException("PDFInvalidDoc exception encountered when serializing XFA on save", e);
                }
                catch (PDFIOException e) {
                    throw new PDFUnableToCompleteOperationException("PDFIO exception encountered when serializing XFA on save", e);
                }
                catch (PDFSecurityException e) {
                    throw new PDFUnableToCompleteOperationException("PDFSecurity exception encountered when serializing XFA on save", e);
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFUnableToCompleteOperationException("PDFInvalidParameter exception encountered when serializing XFA on save", e);
                }
                catch (PDFSignatureException e) {
                    throw new PDFUnableToCompleteOperationException("PDFSignature exception encountered when serializing XFA on save", e);
                }
                message.getDocument().getListenerRegistry().markDirty(this.getClass(), false);
            }
        }
    }

    @Override
    public DocumentListenerProperties getProperties() {
        return null;
    }

    public XFADOM getXFADOM() {
        return this.xfaDOM;
    }

    public void setXFADOM(XFADOM xfaDOM) {
        this.xfaDOM = xfaDOM;
    }

    public void setDocumentContext(DocumentContext docContext) {
        this.docContext = docContext;
    }

    public DocumentContext getDocumentContext() {
        return this.docContext;
    }

    public void setCPDFields(CPDFields cpdFields) {
        this.cpdFields = cpdFields;
    }

    public CPDFields getCPDFields() {
        return this.cpdFields;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public XFAProcessingOptions getXFAProcessingOptions() {
        return this.xfaOptions;
    }

    public boolean isSignatureFieldGenerated(String qualifiedName) {
        return this.generatedSignatureFields != null ? this.generatedSignatureFields.contains(qualifiedName) : false;
    }

    public void setGeneratedSignatureFieldList(String qualifiedName) {
        if (this.generatedSignatureFields == null) {
            this.generatedSignatureFields = new HashSet();
        }
        this.generatedSignatureFields.add(qualifiedName);
    }

    public boolean isSignatureFieldIterated(String qualifiedName) {
        return this.iteratedSigFields != null ? this.iteratedSigFields.containsKey(qualifiedName) : false;
    }

    public PDFFieldSignature getIteratedPDFFieldSignature(String qualifiedName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.iteratedSigFields == null) {
            return null;
        }
        SignatureFieldHolder sigHolder = this.iteratedSigFields.get(qualifiedName);
        return sigHolder == null ? null : sigHolder.getPDFFieldSignature();
    }

    public Field getIteratedXFAField(String qualifiedName) {
        if (this.iteratedSigFields == null) {
            return null;
        }
        SignatureFieldHolder sigHolder = this.iteratedSigFields.get(qualifiedName);
        return sigHolder == null ? null : sigHolder.getXFAFieldSignature();
    }

    public void setIteratedSignatureField(String qualifiedName, PDFFieldSignature pdfFieldSignature, Field xfaField) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.iteratedSigFields == null) {
            this.iteratedSigFields = new HashMap();
        }
        if (this.isSignatureFieldIterated(qualifiedName)) {
            SignatureFieldHolder sigHolder = this.iteratedSigFields.get(qualifiedName);
            if (sigHolder.getPDFFieldSignature() == null && pdfFieldSignature != null) {
                sigHolder.setPDFFieldSignature(pdfFieldSignature);
            }
            if (sigHolder.getXFAFieldSignature() == null && xfaField != null) {
                sigHolder.setXFAFieldSignature(xfaField);
            }
        } else {
            SignatureFieldHolder sigHolder = new SignatureFieldHolder(pdfFieldSignature, xfaField);
            this.iteratedSigFields.put(qualifiedName, sigHolder);
        }
    }

    public void clearIteratedSignatureFieldsList() {
        this.iteratedSigFields = null;
    }

    private static XFAProcessingOptions createDefaultXFAProcessingOptions() {
        return new XFAProcessingOptions(false, false);
    }

    public void setXfaOptions(XFAProcessingOptions xfaOptions) {
        this.xfaOptions = xfaOptions;
    }

    public void setLeanDocGenerationEnabled(boolean leanDocGenerationEnabled) {
        this.leanDocGenerationEnabled = leanDocGenerationEnabled;
    }

    public void setMergeIncrSectionsDuringLeanDoc(boolean mergeIncrementalSectionsDuringLeanDoc) {
        this.mergeIncrementalSectionsDuringLeanDoc = mergeIncrementalSectionsDuringLeanDoc;
    }

    private class SignatureFieldHolder {
        private int pdfSigObjectNumber = 0;
        private Field xfaField = null;

        SignatureFieldHolder(PDFFieldSignature pdfFieldSignature, Field xfaField) {
            if (pdfFieldSignature != null) {
                this.pdfSigObjectNumber = pdfFieldSignature.getCosObject().getObjNum();
            }
            this.xfaField = xfaField;
        }

        public PDFFieldSignature getPDFFieldSignature() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            return PDFFieldSignature.getInstance(XFADOMServiceListener.this.pdfDoc.getCosDocument().getIndirectObjectByNumber(this.pdfSigObjectNumber));
        }

        public Field getXFAFieldSignature() {
            return this.xfaField;
        }

        void setPDFFieldSignature(PDFFieldSignature pdfFieldSignature) {
            if (pdfFieldSignature != null) {
                this.pdfSigObjectNumber = pdfFieldSignature.getCosObject().getObjNum();
            }
        }

        void setXFAFieldSignature(Field xfaField) {
            this.xfaField = xfaField;
        }
    }
}

