/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.swf.utils;

import flash.swf.types.CXFormWithAlpha;
import flash.swf.types.Rect;

public class TypeHelper {
    public static final double GRADIENT_DIMENSION = 1638.4;

    public static Rect rect(double minX, double minY, double maxX, double maxY) {
        Rect rect = new Rect();
        rect.xMin = (int)(minX * 20.0);
        rect.yMin = (int)(minY * 20.0);
        rect.xMax = (int)(maxX * 20.0);
        rect.yMax = (int)(maxY * 20.0);
        return rect;
    }

    public static Rect rect(double width, double height) {
        Rect rect = new Rect();
        rect.xMax = (int)(width * 20.0);
        rect.yMax = (int)(height * 20.0);
        return rect;
    }

    public static CXFormWithAlpha cxFormWithAlpha(double alphaMultiplier) {
        CXFormWithAlpha c = new CXFormWithAlpha();
        c.hasMult = true;
        c.alphaMultTerm = TypeHelper.fixed8(alphaMultiplier);
        return c;
    }

    public static CXFormWithAlpha cxFormWithAlpha(double alphaMultiplier, double redMultiplier, double greenMultiplier, double blueMultiplier, double alphaOffset, double redOffset, double greenOffset, double blueOffset) {
        CXFormWithAlpha c = new CXFormWithAlpha();
        c.alphaMultTerm = TypeHelper.fixed8(alphaMultiplier);
        c.redMultTerm = TypeHelper.fixed8(redMultiplier);
        c.greenMultTerm = TypeHelper.fixed8(greenMultiplier);
        c.blueMultTerm = TypeHelper.fixed8(blueMultiplier);
        c.alphaAddTerm = (int)alphaOffset;
        c.redAddTerm = (int)redOffset;
        c.greenAddTerm = (int)greenOffset;
        c.blueAddTerm = (int)blueOffset;
        if (c.alphaAddTerm > 0 || c.redAddTerm > 0 || c.greenAddTerm > 0 || c.blueAddTerm > 0) {
            c.hasAdd = true;
        }
        if (c.alphaMultTerm > 0 || c.redMultTerm > 0 || c.greenMultTerm > 0 || c.blueMultTerm > 0) {
            c.hasMult = true;
        }
        return c;
    }

    public static int gradientRatio(double ratio) {
        return (int)StrictMath.rint(ratio * 255.0);
    }

    public static int fixed(double value) {
        return (int)(value * 65536.0);
    }

    public static int fixed8(double value) {
        return (int)(value * 256.0) & 0xFFFF;
    }
}

