/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamReader;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.InstructionModifier;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.PDFOptimizer;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.SanitizationContext;
import java.io.IOException;

class ContentStreamSanitizer {
    private ContentStreamSanitizer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PDFContents sanitize(PDFContents pdfContents, ContentWriter contentWriter, PDFResources pdfResources, SanitizationContext context, PDFPage pdfPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        if (pdfResources != null) {
            context.addResource(pdfResources.getCosObject(), null, null);
        }
        if (pdfContents == null) {
            return null;
        }
        ContentStreamWriter contentStreamWriter = null;
        ContentStreamReader contentStreamReader = null;
        InstructionModifier instructionModifier = null;
        ContentReader reader = null;
        PDFContents newContents = null;
        try {
            contentWriter = contentWriter == null ? ContentWriter.newInstance(ModifiableContent.getInstance(PDFContents.newInstance(pdfContents.getPDFDocument()), pdfResources)) : contentWriter;
            PDFOptimizer.addContentDelimiter(contentWriter);
            contentStreamWriter = new ContentStreamWriter(contentWriter);
            contentStreamReader = new ContentStreamReader();
            Content content = Content.getInstance(pdfContents, pdfResources);
            instructionModifier = new InstructionModifier(contentStreamWriter, contentStreamReader, pdfResources, context, pdfPage);
            reader = ContentReader.newInstance(content);
            instructionModifier.parse(reader);
        }
        finally {
            try {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                finally {
                    if (contentWriter != null) {
                        newContents = contentWriter.close().getContents();
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
        return newContents;
    }
}

