/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfport.impl;

import com.adobe.internal.agm.AGMException;
import com.adobe.internal.agm.AGMPath;
import com.adobe.internal.agm.AGMPort;
import com.adobe.internal.agm.AGMText;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.services.pdfport.impl.PDFPortFillPath;
import com.adobe.internal.pdftoolkit.services.pdfport.impl.PDFPortGState;
import com.adobe.internal.pdftoolkit.services.pdfport.impl.PDFPortShowText;
import com.adobe.internal.pdftoolkit.services.pdfport.impl.PDFPortStrokePath;

public class PDFPortMultipleWriters
implements AGMPort {
    private ContentWriter[] portContentWriters;
    private PDFResources portResources;
    private PDFPortShowText currentPortShowText;
    private PDFPortFillPath currentPortFillPath;
    private PDFPortStrokePath currentPortStrokePath;
    private ContentWriter currentPortContentWriter;
    private int count;

    public PDFPortMultipleWriters(ContentWriter[] contentWriters, PDFResources resources) {
        this.portContentWriters = contentWriters;
        this.portResources = resources;
        this.count = contentWriters.length;
    }

    public void processWriterStart(int index) {
        if (index >= this.count || index < 0) {
            throw new IllegalArgumentException("Index should lie between 0 and " + (this.count - 1) + " .");
        }
        this.currentPortContentWriter = this.portContentWriters[index];
        PDFPortGState currentPortGState = new PDFPortGState();
        this.currentPortFillPath = new PDFPortFillPath(currentPortGState);
        this.currentPortStrokePath = new PDFPortStrokePath(currentPortGState);
        this.currentPortShowText = index == 0 ? new PDFPortShowText(currentPortGState, null, this.portResources.getPDFDocument()) : new PDFPortShowText(this.currentPortShowText);
    }

    @Override
    public void fill(AGMPath path) throws AGMException {
        try {
            this.currentPortFillPath.pdfPortFillPath(path, this.currentPortContentWriter);
        }
        catch (PDFException e) {
            throw new AGMException(e);
        }
    }

    @Override
    public void stroke(AGMPath path) throws AGMException {
        try {
            this.currentPortStrokePath.pdfPortStrokePath(path, this.currentPortContentWriter);
        }
        catch (PDFException e) {
            throw new AGMException(e);
        }
    }

    @Override
    public void show(AGMText text) throws AGMException {
        try {
            this.currentPortShowText.showText(text, this.currentPortContentWriter, this.portResources);
        }
        catch (Exception e) {
            throw new AGMException(e);
        }
    }

    public void closePDFPort() throws PDFIOException, PDFFontException, PDFInvalidDocumentException, PDFSecurityException {
        this.currentPortShowText.finalizeFonts(this.portResources);
    }
}

