/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.metadata.PDFMetadata;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2InvalidNamespaceUsage;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2XMPSchema;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.SchemaCollector;
import com.adobe.internal.pdftoolkit.services.xmp.DocumentMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.PDFDictionaryMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.XMPService;
import com.adobe.internal.pdftoolkit.xml.XMLNamespaceUsage;
import com.adobe.internal.pdftoolkit.xml.XMLNamespaceUsageCollector;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import com.adobe.internal.xmp.XMPException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

final class XMPProcessor {
    private static final String[] PREDEFINED_SCHEMAS = new String[]{"schemas/AdobePDFSchema.pxs", "schemas/CameraRawSchema.pxs", "schemas/DublinCoreSchema.pxs", "schemas/EXIFAdditionalSchema.pxs", "schemas/EXIFSchema.pxs", "schemas/PDFAExtensionSchemaSchema.pxs", "schemas/PDFAIdentificationSchema.pxs", "schemas/PhotoshopSchema.pxs", "schemas/RDFSchema.pxs", "schemas/RDFSSchema.pxs", "schemas/TIFFSchema.pxs", "schemas/XMPBasicJobTicketSchema.pxs", "schemas/XMPBasicSchema.pxs", "schemas/XMPDynamicMediaSchema.pxs", "schemas/XMPMediaManagementSchema.pxs", "schemas/XMPMetaSchema.pxs", "schemas/XMPPagedTextSchema.pxs", "schemas/XMPRightsManagementSchema.pxs"};
    private static Map<String, PDFA2XMPSchema> implicitSchemas;
    private XMLNamespaceUsageCollector usageCollector;
    private SchemaCollector schemaCollector;
    private Map<String, PDFA2XMPSchema> explicitSchemas;
    private Map<String, PDFA2XMPSchema> referenceSchemas;
    private Map<String, XMLNamespaceUsage> namespaceUsage;
    private Set<PDFA2InvalidNamespaceUsage> invalidNamespaceUsage;

    private void init() throws PDFConfigurationException {
        try {
            this.loadImplicitSchemas();
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("Unable to load schemas for PDF/A specification.", e);
        }
        catch (TransformerException e) {
            throw new PDFConfigurationException("Unable to load schemas for PDF/A specification.", e);
        }
        this.usageCollector = new XMLNamespaceUsageCollector();
        try {
            this.schemaCollector = new SchemaCollector();
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("Unable to set namespace features on XML Reader.", e);
        }
    }

    public XMPProcessor(PDFDocument pdfDocument, boolean useInternalXMP) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        this.init();
        InputStream xmpStream = null;
        try {
            xmpStream = useInternalXMP ? XMPProcessor.getStreamFromInternalXMP(pdfDocument) : XMPProcessor.getStreamFromExternalXMP(pdfDocument);
            this.processMetadata(xmpStream, null);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
        finally {
            if (xmpStream != null) {
                try {
                    xmpStream.close();
                }
                catch (IOException e) {
                    throw new PDFIOException("Error during stream close.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMPProcessor(PDFCosDictionary pdfDict, Map<String, PDFA2XMPSchema> globalSchemas, boolean useInternalXMP) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFInvalidXMLException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        this.init();
        InputStream xmpStream = null;
        try {
            xmpStream = useInternalXMP ? XMPProcessor.getStreamFromInternalXMP(pdfDict) : XMPProcessor.getStreamFromExternalXMP(pdfDict);
            this.processMetadata(xmpStream, globalSchemas);
        }
        finally {
            if (xmpStream != null) {
                try {
                    xmpStream.close();
                }
                catch (IOException e) {
                    throw new PDFIOException("Error during stream close.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImplicitSchemas() throws PDFConfigurationException, SAXException, TransformerException {
        Class<XMPProcessor> clazz = XMPProcessor.class;
        synchronized (XMPProcessor.class) {
            if (implicitSchemas != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            HashMap<String, PDFA2XMPSchema> internalImplicitSchemas = new HashMap<String, PDFA2XMPSchema>();
            try {
                for (String schemaFile : PREDEFINED_SCHEMAS) {
                    InputStream schemaStream = this.getClass().getResourceAsStream(schemaFile);
                    if (schemaStream == null) {
                        Path currentRelativePath = Paths.get("", new String[0]);
                        String s = currentRelativePath.toAbsolutePath().toString();
                        PDFUtil.logInfo("FAIL. Could not  load schemaFile: " + schemaFile + ", currentRelativePath: " + s + ", user Directory: " + System.getProperty("user.dir"));
                        continue;
                    }
                    ObjectInputStream ois = new ObjectInputStream(schemaStream);
                    PDFA2XMPSchema schema = (PDFA2XMPSchema)ois.readObject();
                    ois.close();
                    internalImplicitSchemas.put(schema.getURI(), schema);
                }
            }
            catch (IOException e) {
                throw new PDFConfigurationException("Bad configuration - unable to load predefine PDF/A XMP schemas.", e);
            }
            catch (ClassNotFoundException e) {
                throw new PDFConfigurationException("Bad configuration - unable to load predefine PDF/A XMP schemas.", e);
            }
            implicitSchemas = Collections.unmodifiableMap(internalImplicitSchemas);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Set<PDFA2InvalidNamespaceUsage> getInvalidNamespaceUsage(Map<String, Set<String>> nsQualifierSet) throws PDFUnableToCompleteOperationException, PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, XMPException {
        if (this.invalidNamespaceUsage == null) {
            this.invalidNamespaceUsage = this.generateInvalidNamespaceUsage(nsQualifierSet);
        }
        return this.invalidNamespaceUsage;
    }

    public Map<String, PDFA2XMPSchema> getEmbeddedSchemas() {
        if (this.explicitSchemas == null) {
            this.explicitSchemas = new HashMap<String, PDFA2XMPSchema>();
        }
        return this.explicitSchemas;
    }

    public Map<String, PDFA2XMPSchema> getReferenceSchemas() {
        if (this.referenceSchemas == null) {
            this.referenceSchemas = new HashMap<String, PDFA2XMPSchema>();
        }
        return this.referenceSchemas;
    }

    private Set<PDFA2InvalidNamespaceUsage> generateInvalidNamespaceUsage(Map<String, Set<String>> nsQualifierSet) throws PDFUnableToCompleteOperationException, PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, XMPException {
        HashSet<PDFA2InvalidNamespaceUsage> invalidUsage = new HashSet<PDFA2InvalidNamespaceUsage>();
        if (this.namespaceUsage == null) {
            return invalidUsage;
        }
        for (XMLNamespaceUsage currentNamespaceUsage : this.namespaceUsage.values()) {
            PDFA2InvalidNamespaceUsage currentInvalidUsage = new PDFA2InvalidNamespaceUsage(currentNamespaceUsage);
            for (PDFA2XMPSchema predefinedSchema : implicitSchemas.values()) {
                if (!currentInvalidUsage.removeSchema(predefinedSchema)) continue;
                currentInvalidUsage.addNamespaceDefinitionLocation(PDFA2InvalidNamespaceUsage.DefinitionLocation.PDFA2_SPECIFICATON);
            }
            for (PDFA2XMPSchema embeddedSchema : this.referenceSchemas.values()) {
                if (!currentInvalidUsage.removeSchema(embeddedSchema)) continue;
                currentInvalidUsage.addNamespaceDefinitionLocation(PDFA2InvalidNamespaceUsage.DefinitionLocation.PDFA2_SCHEMA);
            }
            currentInvalidUsage.removeQualifiers(nsQualifierSet);
            if (currentInvalidUsage.areErrorsCleared()) continue;
            invalidUsage.add(currentInvalidUsage);
        }
        return invalidUsage;
    }

    private boolean processMetadata(InputStream metadataIS, Map<String, PDFA2XMPSchema> globalSchemas) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException, PDFConfigurationException {
        if (metadataIS == null) {
            return false;
        }
        try {
            Source source = XMLUtils.createSource(new InputSource(metadataIS), new XMLFilter[]{this.schemaCollector, this.usageCollector}, false);
            Result result = XMLUtils.createNullResult();
            XMLUtils.transformToXML(source, result, false);
            this.namespaceUsage = this.usageCollector.getNamespaceUsage();
            this.explicitSchemas = this.schemaCollector.getSchemas();
            this.referenceSchemas = new HashMap<String, PDFA2XMPSchema>();
            for (Map.Entry<String, PDFA2XMPSchema> entry : this.explicitSchemas.entrySet()) {
                String nsURI = entry.getKey();
                PDFA2XMPSchema explicitSchema = entry.getValue();
                PDFA2XMPSchema referenceSchema = new PDFA2XMPSchema(explicitSchema);
                PDFA2XMPSchema implicitSchema = implicitSchemas.get(nsURI);
                if (implicitSchema != null) {
                    referenceSchema.mergeSchema(implicitSchema);
                }
                this.referenceSchemas.put(nsURI, referenceSchema);
            }
            for (Map.Entry<String, PDFA2XMPSchema> entry : implicitSchemas.entrySet()) {
                String nsURI = entry.getKey();
                if (this.referenceSchemas.get(nsURI) != null) continue;
                PDFA2XMPSchema implicitSchema = entry.getValue();
                this.referenceSchemas.put(nsURI, new PDFA2XMPSchema(implicitSchema));
            }
            if (globalSchemas != null) {
                for (Map.Entry<String, PDFA2XMPSchema> entry : globalSchemas.entrySet()) {
                    String nsURI = entry.getKey();
                    PDFA2XMPSchema globalSchema = entry.getValue();
                    PDFA2XMPSchema globalSchemaCopy = new PDFA2XMPSchema(globalSchema);
                    PDFA2XMPSchema referenceSchema = this.referenceSchemas.get(nsURI);
                    if (referenceSchema != null) {
                        referenceSchema.mergeSchema(globalSchemaCopy);
                        this.referenceSchemas.put(nsURI, referenceSchema);
                        continue;
                    }
                    this.referenceSchemas.put(nsURI, globalSchemaCopy);
                }
            }
        }
        catch (SAXException e) {
            throw new PDFConfigurationException(e);
        }
        catch (TransformerException e) {
            throw new PDFInvalidXMLException("PDF metadata XML may be invalid.", e);
        }
        return true;
    }

    static InputStream getStreamFromExternalXMP(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCatalog catalog = pdfDocument.requireCatalog();
        return XMPProcessor.getStreamFromExternalXMP(catalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static InputStream getStreamFromExternalXMP(PDFCosDictionary pdfCosDict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDocument pdfDocument = pdfCosDict.getPDFDocument();
        PDFMetadata metadata = pdfCosDict.getMetadata();
        if (metadata == null) {
            return null;
        }
        ByteArrayOutputStream metadataOS = null;
        InputByteStream metadataIBS = null;
        InputStream metadataIS = null;
        try {
            try {
                metadataOS = new ByteArrayOutputStream(metadata.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)metadata.getLength());
                metadata.getStreamData(metadataOS);
                metadataIBS = pdfDocument.getStreamManager().getInputByteStream(metadataOS.toByteArray());
                if (metadataIBS == null || metadataIBS.length() == 0L) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                metadataIS = metadataIBS.toInputStream();
                return metadataIS;
            }
            finally {
                try {
                    if (metadataIBS != null) {
                        metadataIBS.close();
                    }
                }
                finally {
                    if (metadataOS != null) {
                        metadataOS.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    static InputStream getStreamFromInternalXMP(PDFDocument pdfDocument) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        DocumentMetadata metadata = XMPService.getDocumentMetadata(pdfDocument);
        return XMPProcessor.getStreamFromInternalXMP(metadata, pdfDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InputStream getStreamFromInternalXMP(PDFDictionaryMetadata metadata, PDFDocument pdfDocument) throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        OutputByteStream metadataOBS = null;
        OutputStream metadataOS = null;
        InputByteStream metadataIBS = null;
        InputStream metadataIS = null;
        try {
            if (metadata == null) {
                return null;
            }
            try {
                metadataOBS = pdfDocument.getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, 1024L);
                metadataOS = metadataOBS.toOutputStream();
                metadata.exportXMP(metadataOS);
                metadataIBS = metadataOBS.closeAndConvert();
                metadataOBS = null;
                if (metadataIBS == null || metadataIBS.length() == 0L) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                metadataIS = metadataIBS.toInputStream();
                return metadataIS;
            }
            finally {
                if (metadataOBS != null) {
                    metadataOBS.close();
                }
                if (metadataOS != null) {
                    metadataOS.close();
                }
                if (metadataIBS != null) {
                    metadataIBS.close();
                }
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    static InputStream getStreamFromInternalXMP(PDFCosDictionary pdfDict) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        PDFDictionaryMetadata metadata = XMPService.getPDFDictionaryMetadata(pdfDict, null);
        return XMPProcessor.getStreamFromInternalXMP(metadata, pdfDict.getPDFDocument());
    }
}

