/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fdf;

import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFDocumentImpl;

public class FDFDocument {
    private FDFDocumentImpl realFDFDocument;

    FDFDocument(FDFDocumentImpl fdfDoc) {
        this.realFDFDocument = fdfDoc;
    }

    public static FDFDocument newInstance(ByteReader src) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new FDFDocument(new FDFDocumentImpl(src, PDFOpenOptions.newInstance()));
    }

    public static FDFDocument newInstance(ByteReader src, PDFOpenOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new FDFDocument(new FDFDocumentImpl(src, options));
    }

    FDFDocumentImpl getFDFDocument() {
        return this.realFDFDocument;
    }

    public void save(ByteWriter byteWriter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getFDFDocument().save(byteWriter);
    }

    public boolean isEmpty() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getFDFDocument().requireFDFCatalog().requireContent().isEmpty();
    }

    public void close() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        this.realFDFDocument.close();
        this.realFDFDocument = null;
    }
}

