/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureUtils;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.BCUtilities;
import com.adobe.internal.pdftoolkit.services.digsig.spi.TimeStampProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;

public class DocumentTimestampProviderImpl
implements TimeStampProvider {
    InputStream dataStreamToTimeStamp;
    String digestAlgorithm = "SHA";
    String tsaURL = "http://adobe-timestamp.geotrust.com";
    private static final int TIME_STAMP_TOKEN_SIZE = 6144;
    private int maxSleepTimeBeforeRetry = 2000;
    private int MAX_RETRY_COUNTER = 10;
    private int retryCounter = 0;

    @Override
    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    @Override
    public String getTSAURL() {
        return this.tsaURL;
    }

    @Override
    public void setDataToTimestamp(byte[] dataToTimestamp) {
        this.dataStreamToTimeStamp = new ByteArrayInputStream(dataToTimestamp);
    }

    @Override
    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    @Override
    public void setTSAURL(String tsaURL) {
        this.tsaURL = tsaURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getTimestampToken() throws PDFSignatureException {
        try {
            if (this.dataStreamToTimeStamp == null) {
                throw new PDFInvalidParameterException("Data To Be Time Stamp can not be null");
            }
            byte[] messageImprintDigest = this.getDigestOfDataToBeTimeStamped();
            TimeStampRequestGenerator requestGenerator = new TimeStampRequestGenerator();
            requestGenerator.setCertReq(true);
            TimeStampRequest request = requestGenerator.generate(SignatureUtils.getAlgorithmId(this.digestAlgorithm), messageImprintDigest);
            byte[] requestData = request.getEncoded();
            URL tsUrl = new URL(this.tsaURL);
            HttpURLConnection connection = (HttpURLConnection)tsUrl.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-type", "application/timestamp-query");
            connection.setRequestProperty("Content-length", String.valueOf(requestData.length));
            OutputStream out = connection.getOutputStream();
            out.write(requestData);
            out.flush();
            if (connection.getResponseCode() != 200) {
                throw new IOException("Received HTTP error: " + connection.getResponseCode() + " - " + connection.getResponseMessage());
            }
            TimeStampResponse response = new TimeStampResponse(connection.getInputStream());
            int status = response.getStatus();
            if (status == 0 || status == 1) {
                byte[] token = response.getTimeStampToken().toCMSSignedData().getEncoded();
                if (token.length > 6144) {
                    throw new PDFSignatureException("Time Stamp Token Size (" + token.length + ") found greater than Max size supported (" + 6144 + ")");
                }
                byte[] byArray = token;
                return byArray;
            }
            try {
                throw new PDFSignatureException("Time Stamp Token Not found. " + response.getFailInfo().toString() + ", Status: " + response.getStatusString());
            }
            catch (Exception e) {
                if (this.retryCounter == this.MAX_RETRY_COUNTER) {
                    throw new PDFSignatureException("Error fetching Time Stamp from server with url: " + this.tsaURL, e);
                }
                ++this.retryCounter;
                try {
                    Thread.sleep(this.maxSleepTimeBeforeRetry);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                byte[] byArray = this.getTimestampToken();
                return byArray;
            }
        }
        finally {
            this.retryCounter = 0;
        }
    }

    @Override
    public int getTimestampTokenSize() throws PDFSignatureException {
        return 6144;
    }

    private byte[] getDigestOfDataToBeTimeStamped() throws NoSuchAlgorithmException, IOException {
        MessageDigest digester = MessageDigest.getInstance(this.digestAlgorithm, BCUtilities.provider);
        byte[] chunk = new byte[8192];
        while (this.dataStreamToTimeStamp.available() > 0) {
            int numBytesRead = this.dataStreamToTimeStamp.read(chunk);
            digester.update(chunk, 0, numBytesRead);
        }
        return digester.digest();
    }

    @Override
    public void setDataToTimestamp(InputStream dataToTimestamp) {
        this.dataStreamToTimeStamp = dataToTimestamp;
    }
}

