/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.io.stream.IO;
import com.adobe.internal.pdftoolkit.core.credentials.impl.RSACredentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsCADES;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.CryptoContext;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.AbstractDigester;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.PKCS7Signer;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSAPKCS7SignedDataBuilder;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSASigningUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CADESDetachedSigner
extends PKCS7Signer {
    private SignatureOptionsCADES sigOptionsCADES = SignatureOptionsCADES.newInstance();

    public CADESDetachedSigner(RSACredentials credentials, CryptoContext ctx, AbstractDigester digester, RSAPKCS7SignedDataBuilder pkcs7PacketBuilder, SignatureOptionsCADES sigOptionsCADES) {
        super(credentials, ctx, true, digester, pkcs7PacketBuilder);
        if (sigOptionsCADES != null) {
            this.sigOptionsCADES = sigOptionsCADES;
        }
    }

    @Override
    public byte[] sign(InputStream contents) throws PDFSignatureException {
        byte[] signatureBytes = null;
        if (this.isDetached && "DSA".equals(this.cryptoContext.getSignatureAlgorithm())) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                IO.copy(contents, (OutputStream)bos);
            }
            catch (IOException e) {
                throw new PDFSignatureException("unable to copy contents");
            }
            signatureBytes = bos.toByteArray();
        } else {
            signatureBytes = this.getSignatureBytes(contents);
        }
        return this.pkcs7PacketBuilder.buildPacketForCADES(signatureBytes, (RSACredentials)this.credentials, this.cryptoContext, false, this.sigOptionsCADES);
    }

    @Override
    public int getSignatureSize() throws PDFSignatureException {
        return RSASigningUtils.estimatePacketSizeUsingRSAForCADES((RSACredentials)this.credentials, this.cryptoContext, this.digester, this.sigOptionsCADES);
    }
}

