/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.annot;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSquare;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderEffects;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotationAppearanceGenerator;
import com.adobe.internal.pdftoolkit.services.ap.annot.CloudUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class SquareAnnotApGenerator
extends AnnotationAppearanceGenerator<PDFAnnotationSquare> {
    SquareAnnotApGenerator() {
    }

    @Override
    protected void generateAppearanceInternal(PDFAnnotationSquare annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        ASName style;
        super.generateAppearanceInternal(annot);
        PDFRectangle rectOrig = this.getRect(annot, annot.getFringe());
        PDFAnnotationRotationEnum rotationEnum = this.writer.getRotationType();
        boolean isRotate = false;
        ASMatrix fm = ASMatrix.createIdentityMatrix();
        if ((rotationEnum == PDFAnnotationRotationEnum.OnlyAnnotationRotation || rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) && annot.getRotation() != 0) {
            isRotate = true;
        }
        if (isRotate) {
            fm = this.applyRotation(Math.toRadians(annot.getRotation()), rectOrig);
            this.writer.contentWriter.write(InstructionFactory.newGSave());
            this.writer.contentWriter.write(InstructionFactory.newConcatMatrix(fm.geta(), fm.getb(), fm.getc(), fm.getd(), fm.getx(), fm.gety()));
        }
        this.writer.writeGraphicsInfo(annot, true, annot.getColor(), annot.getInteriorColor(), annot.getOpacity(), null);
        PDFRectangle rect = rectOrig;
        rect = PDFRectangle.newInstance(annot.getPDFDocument(), rectOrig.left() + this.writer.lineWidth / 2.0, rectOrig.bottom() + this.writer.lineWidth / 2.0, rectOrig.right() - this.writer.lineWidth / 2.0, rectOrig.top() - this.writer.lineWidth / 2.0);
        PDFBorderEffects borderEffects = annot.getBorderEffects();
        double cloudIntensity = borderEffects != null ? borderEffects.getIntensity() : 0.0;
        ASName aSName = style = borderEffects != null ? borderEffects.getStyle() : ASName.k_S;
        if (style == ASName.k_C && cloudIntensity > 0.0) {
            PDFRectangle rectCopy = PDFRectangle.newInstance(annot.getPDFDocument(), rect.getRectangle());
            ArrayList<ASCoordinate> vVertex = new ArrayList<ASCoordinate>();
            ASCoordinate vertex = new ASCoordinate(rect.left(), rect.top());
            vVertex.add(vertex);
            vertex = new ASCoordinate(rectCopy.right(), vertex.y());
            vVertex.add(vertex);
            vertex = new ASCoordinate(vertex.x(), rectCopy.bottom());
            vVertex.add(vertex);
            vertex = new ASCoordinate(rectCopy.left(), vertex.y());
            vVertex.add(vertex);
            vertex = new ASCoordinate(vertex.x(), rectCopy.top());
            vVertex.add(vertex);
            List<AnnotationAppearanceGenerator.Arc> vArc = CloudUtils.cloudifyPolyLine(cloudIntensity, this.writer.lineWidth, vVertex);
            Iterator<AnnotationAppearanceGenerator.Arc> itr = vArc.iterator();
            AnnotationAppearanceGenerator.Arc arc = null;
            boolean first = true;
            while (itr.hasNext()) {
                arc = itr.next();
                this.writer.arcto(arc.m_center.x(), arc.m_center.y(), arc.m_radius, arc.t2 - 0.39269908169872414, arc.t1, true, first);
                this.writer.arcto(arc.m_center.x(), arc.m_center.y(), arc.m_radius, arc.t2 - 0.39269908169872414, arc.t2, false, false);
                first = false;
            }
            this.writer.contentWriter.write(InstructionFactory.newClosePath());
            this.writer.fillStroke(this.writer.fill, this.writer.stroke);
        } else {
            this.writer.writeRect(rect.getRectangle());
            this.writer.fillStroke(this.writer.fill, this.writer.stroke);
        }
        PDFRectangle rectAfter = this.writer.getAdjustedBBox(annot.getPDFDocument());
        if (isRotate) {
            this.writer.contentWriter.write(InstructionFactory.newGRestore());
            if (rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) {
                annot.setRotation(annot.getRotation() - annot.getPage().getRotation().getValue());
            }
            this.setRect(annot, annot.getPage().getCropBox(), null);
            this.createAndSetAppearance(annot, rectAfter, annot.getPage().getCropBox());
        } else {
            this.setRect(annot, rectOrig, rectAfter);
            this.createAndSetAppearance(annot, rectAfter);
        }
    }
}

