/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;

public class PaletteBox
extends Jpeg2000Box {
    private int numberOfEntries;
    private int numberOfPaletteColumns;
    private byte[] bitDepths;
    private InputByteStream[][] valuesTable;

    PaletteBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public int getNumberOfEntries() throws IOException {
        this.lazilyPopulateFields();
        return this.numberOfEntries;
    }

    public int getNumberOfPaletteColumns() throws IOException {
        this.lazilyPopulateFields();
        return this.numberOfPaletteColumns;
    }

    public byte[] getBitDepths() throws IOException {
        this.lazilyPopulateFields();
        return this.bitDepths;
    }

    public InputByteStream[][] getValues() throws IOException {
        this.lazilyPopulateFields();
        return this.valuesTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            int i;
            this.numberOfEntries = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.numberOfPaletteColumns = Jpeg2000Utils.bytesToInteger(boxContents, 1);
            this.bitDepths = new byte[this.numberOfPaletteColumns];
            int[] sizeOfValuesInColumns = new int[this.numberOfPaletteColumns];
            for (i = 0; i < this.numberOfPaletteColumns; ++i) {
                this.bitDepths[i] = (byte)boxContents.read();
                sizeOfValuesInColumns[i] = this.bitDepths[i] % 8 != 0 ? this.bitDepths[i] / 8 + 1 : 0;
            }
            this.valuesTable = new InputByteStream[this.numberOfEntries][];
            for (i = 0; i < this.numberOfEntries; ++i) {
                this.valuesTable[i] = new InputByteStream[this.numberOfPaletteColumns];
                for (int j = 0; j < this.numberOfPaletteColumns; ++j) {
                    this.valuesTable[i][j] = boxContents.slice(boxContents.getPosition(), sizeOfValuesInColumns[j]);
                    boxContents.seek(boxContents.getPosition() + (long)sizeOfValuesInColumns[j]);
                }
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        IOException exceptionOccured = null;
        try {
            for (int i = 0; i < this.numberOfEntries; ++i) {
                for (int j = 0; j < this.numberOfPaletteColumns; ++j) {
                    try {
                        if (this.valuesTable[i][j] == null) continue;
                        this.valuesTable[i][j].close();
                        continue;
                    }
                    catch (IOException e) {
                        exceptionOccured = e;
                    }
                }
            }
            if (exceptionOccured != null) {
                throw exceptionOccured;
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }
}

