/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.page;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsPage;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTreeList;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.util.ArrayListStack;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class PDFPageTreeNode
extends PDFCosDictionary {
    static final int MAX_NODES = 5;

    protected PDFPageTreeNode(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    PDFPageTreeNode next() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTreeNode parent = this.getParent();
        if (parent == null) {
            return null;
        }
        PDFPageTreeList kids = parent.getKids();
        if (kids == null) {
            return null;
        }
        int thisInd = kids.indexOf(this) + 1;
        return thisInd < kids.size() ? (PDFPageTreeNode)kids.get(thisInd) : null;
    }

    public static PDFPageTreeNode getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFPageTreeNode pdfObject = (PDFPageTreeNode)PDFCosObject.getCachedInstance(cosObject, PDFPageTreeNode.class);
        if (pdfObject == null) {
            pdfObject = new PDFPageTreeNode(cosObject);
        }
        return pdfObject;
    }

    static PDFPageTreeNode newInstance(PDFDocument pdfDocument, PDFPageTreeNode parent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary nodeDict = PDFCosObject.newCosDictionary(pdfDocument);
        PDFPageTreeNode node = PDFPageTreeNode.getInstance(nodeDict);
        node.setDictionaryNameValue(ASName.k_Type, ASName.k_Pages);
        node.setCount(0);
        PDFPageTreeList kids = PDFPageTreeList.newInstance(pdfDocument);
        node.setKids(kids);
        if (parent != null) {
            node.setParent(parent);
        }
        return node;
    }

    public Iterator<PDFPage> iterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PageIterator(this);
    }

    public PDFPageTreePagesIterator oldIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFPageTreePagesIterator(this, null);
    }

    public Iterator<PDFPage> iterator(int index) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PageIterator iter = new PageIterator(this);
        while (iter.hasNext() && index-- > 0) {
            iter.next();
        }
        return iter;
    }

    public Iterator<PDFPage> iterator(PDFPageTreeNode startingNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PageIterator iter;
        block1: {
            iter = new PageIterator(this);
            if (startingNode == null) break block1;
            while (iter.hasNext() && !PDFUtil.isPDFCosObjectRefEqual(startingNode, (PDFCosObject)iter.next())) {
            }
        }
        return iter;
    }

    public PDFPageTreePagesIterator pagesIterator(PDFPageTreeNode startingNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTreeNode parentNode = startingNode == null ? this : startingNode.getParent();
        return new PDFPageTreePagesIterator(parentNode, startingNode);
    }

    public PDFAnnotationIterator getAnnotationsIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFPagesAnnotationIterator(this);
    }

    public int getCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Count);
    }

    void setCount(int count) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Count, count);
    }

    void incrementCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int count = this.getCount();
        this.setCount(count + 1);
        PDFPageTreeNode parentNode = this.getParent();
        if (parentNode != null) {
            parentNode.incrementCount();
        }
    }

    void decrementCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int count = this.getCount();
        this.setCount(count - 1);
        PDFPageTreeNode parentNode = this.getParent();
        if (parentNode != null) {
            parentNode.decrementCount();
        }
    }

    public int getPageIndex() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int pageCount = 0;
        PDFPageTreeNode parent = this.getParent();
        if (parent != null && parent.getKids() != null) {
            PDFPageTreeNode nextNode;
            Iterator parentIter = parent.getKids().iterator();
            while (parentIter.hasNext() && !PDFUtil.isPDFCosObjectRefEqual(this, nextNode = (PDFPageTreeNode)parentIter.next())) {
                if (nextNode instanceof PDFPage) {
                    ++pageCount;
                    continue;
                }
                pageCount += nextNode.getCount();
            }
            pageCount += parent.getPageIndex();
        }
        return pageCount;
    }

    PDFPageTreeNode getParent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPageTreeNode.getInstance(this.getDictionaryCosObjectValue(ASName.k_Parent));
    }

    void setParent(PDFPageTreeNode parent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Parent, parent);
    }

    public boolean appendKid(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTreeList kids = this.getKids();
        kids.add(page);
        page.setDictionaryValue(ASName.k_Parent, this);
        this.incrementCount();
        return true;
    }

    PDFPageTreeList getKids() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPageTreeList.getInstance(this.getDictionaryCosObjectValue(ASName.k_Kids));
    }

    void setKids(PDFPageTreeList kids) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_Kids, kids.getCosArray());
    }

    public void removeKids() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_Kids);
    }

    public void removeKid(PDFPageTreeNode kid) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTreeList kids = this.getKids();
        Iterator kidsIter = kids.iterator();
        while (kidsIter.hasNext()) {
            PDFPageTreeNode currentKid = (PDFPageTreeNode)kidsIter.next();
            if (!PDFUtil.isPDFCosObjectRefEqual(currentKid, kid)) continue;
            kidsIter.remove();
            if (kid instanceof PDFPage) {
                this.decrementCount();
            } else {
                this.setCount(this.getCount() - kid.getCount());
            }
            return;
        }
    }

    public void treeRemoveKid(PDFPageTreeNode kid) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeKid(kid);
        if (this.getCount() == 0) {
            this.getParent().treeRemoveKid(this);
        }
    }

    public void balancePages() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTreeNode newRoot;
        int pageCount = this.getCount();
        if (pageCount < 10) {
            return;
        }
        PDFPageTreeNode curNode = newRoot = PDFPageTreeNode.newInstance(this.getPDFDocument(), null);
        while (pageCount > 0) {
            PDFPageTreeNode childNode = PDFPageTreeNode.newInstance(this.getPDFDocument(), curNode);
            curNode.getKids().add(childNode);
            curNode = childNode;
            if ((pageCount /= 5) >= 10) continue;
            break;
        }
        Iterator<PDFPage> pagesIterator = this.iterator();
        while (pagesIterator.hasNext()) {
            PDFPage curPage = pagesIterator.next();
            PDFResources curPageResources = curPage.getResources();
            if (curPageResources == null) {
                curPageResources = PDFResources.newInstance(this.getPDFDocument());
            }
            curPage.setResources(curPageResources);
            curNode = this.addBalancedNode(curPage, curNode, true);
        }
        this.optimizeResources(curNode);
        PDFPageTreeList kids = newRoot.getKids();
        Iterator kidsIterator = kids.iterator();
        while (kidsIterator.hasNext()) {
            ((PDFPageTreeNode)kidsIterator.next()).setParent(this);
        }
        this.setKids(newRoot.getKids());
        this.optimizeResources(this);
    }

    private PDFPageTreeNode addBalancedNode(PDFPageTreeNode node, PDFPageTreeNode parent, boolean counting) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTreeNode parentsParent = parent.getParent();
        PDFPageTreeList kids = parent.getKids();
        if (kids.size() < 5 || parentsParent == null) {
            kids.add(node);
            node.setParent(parent);
            if (counting) {
                parent.incrementCount();
            }
            return parent;
        }
        this.optimizeResources(parent);
        PDFPageTreeNode newParent = PDFPageTreeNode.newInstance(this.getPDFDocument(), parentsParent);
        this.addBalancedNode(newParent, parentsParent, false);
        this.addBalancedNode(node, newParent, counting);
        return newParent;
    }

    private void optimizeResources(PDFPageTreeNode parent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTreeList kids = parent.getKids();
        if (kids == null) {
            return;
        }
        HashMap<PDFResources, int[]> resources = new HashMap<PDFResources, int[]>(5, 1.0f);
        for (PDFPageTreeNode curNode : kids) {
            PDFResources curResources = curNode.getResources();
            if (curResources == null) continue;
            if (resources.containsKey(curResources)) {
                int[] nArray = (int[])resources.get(curResources);
                nArray[0] = nArray[0] + 1;
                continue;
            }
            int[] count = new int[]{1};
            resources.put(curResources, count);
        }
        PDFResources parentResources = null;
        int maxCount = 0;
        for (Map.Entry curEntry : resources.entrySet()) {
            int curCount = ((int[])curEntry.getValue())[0];
            if (curCount <= maxCount) continue;
            parentResources = (PDFResources)curEntry.getKey();
            maxCount = curCount;
        }
        if (maxCount > 2) {
            parent.setResources(parentResources);
            for (PDFPageTreeNode curNode : kids) {
                if (parentResources == null || !parentResources.equals(curNode.getResources())) continue;
                curNode.setResources(null);
            }
        }
    }

    public PDFResources getResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.containsKey(ASName.k_Resources)) {
            return PDFResources.getInstance(this.getDictionaryCosObjectValue(ASName.k_Resources));
        }
        PDFPageTreeNode parent = this.getParent();
        if (parent != null) {
            return parent.getResources();
        }
        return null;
    }

    public void setResources(PDFResources resources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Resources, resources);
    }

    public PDFRectangle getMediaBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.containsKey(ASName.k_MediaBox)) {
            return PDFRectangle.getInstance(this.getDictionaryCosObjectValue(ASName.k_MediaBox));
        }
        PDFPageTreeNode parent = this.getParent();
        if (parent != null) {
            return parent.getMediaBox();
        }
        return null;
    }

    public PDFRectangle getCropBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.containsKey(ASName.k_CropBox)) {
            return PDFRectangle.getInstance(this.getDictionaryCosObjectValue(ASName.k_CropBox));
        }
        PDFPageTreeNode parent = this.getParent();
        if (parent != null) {
            return parent.getCropBox();
        }
        return null;
    }

    public PDFAdditionalActionsPage getAdditionalActions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAdditionalActionsPage.getInstance(this.getDictionaryCosObjectValue(ASName.k_AA));
    }

    public PDFAdditionalActions procureAdditionalActions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFAdditionalActionsPage.getInstance(PDFCosUtils.getInheritableValue(ASName.k_AA, ASName.k_Parent, this)) != null) {
            return PDFAdditionalActionsPage.getInstance(PDFCosUtils.getInheritableValue(ASName.k_AA, ASName.k_Parent, this));
        }
        PDFAdditionalActionsPage page = PDFAdditionalActionsPage.newInstance(this.getPDFDocument());
        this.setAdditionalActions(page);
        return page;
    }

    public void setAdditionalActions(PDFAdditionalActionsPage additionalActions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_AA, additionalActions);
    }

    public PDFRotation getRotation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.containsKey(ASName.k_Rotate)) {
            try {
                return PDFRotation.getInstance(this.getDictionaryIntValue(ASName.k_Rotate));
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Invalid page rotation", e);
            }
        }
        PDFPageTreeNode parent = this.getParent();
        if (parent != null) {
            return parent.getRotation();
        }
        return null;
    }

    public void setRotation(PDFRotation angle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Rotate, angle.getValue());
    }

    private boolean containsKey(ASName key, boolean inheritable) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.containsKey(key)) {
            return true;
        }
        if (inheritable) {
            PDFPageTreeNode parent = this.getParent();
            if (parent != null) {
                return parent.containsKey(key, inheritable);
            }
            return false;
        }
        return false;
    }

    protected boolean containsResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.containsKey(ASName.k_Resources, true);
    }

    protected boolean containsMediaBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.containsKey(ASName.k_MediaBox, true);
    }

    protected boolean containsCropBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.containsKey(ASName.k_CropBox, true);
    }

    protected boolean containsRotation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.containsKey(ASName.k_Rotate, true);
    }

    private void debugPrint(PrintWriter o) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getKids() == null) {
            this.debugPrintLeaf(o);
        } else {
            this.debugPrintTree(o);
        }
    }

    private void debugPrintLeaf(PrintWriter o) {
        PrintStream out = System.out;
        out.println("--Begin PDFPageTreeNode(Leaf)--:" + this.hashCode());
        out.println("mCosObject:" + this.getCosObject().toString());
        out.println("--End PDFPageTreeNode(Leaf)--" + this.hashCode());
    }

    private void debugPrintTree(PrintWriter o) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PrintStream out = System.out;
        int kSize = this.getKids().size();
        out.println("--Begin PDFPageTreeNode(Tree)--" + this.hashCode() + " has " + kSize + " kids");
        out.println("mCosObject:" + this.getCosObject().toString());
        Iterator iter = this.getKids().iterator();
        int i = 0;
        while (iter.hasNext()) {
            PDFPageTreeNode node = (PDFPageTreeNode)iter.next();
            out.println("Kid:" + node.hashCode() + "(" + ++i + "of" + kSize + ") Of Obj:" + this.hashCode());
            node.debugPrint(o);
        }
        out.println("--End PDFPageTreeNode(Tree)--" + this.hashCode());
    }

    int indexOfParent(PDFPageTreeNode node) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTreeList kids = this.getKids();
        int i = 0;
        Iterator iter = kids.iterator();
        while (iter.hasNext() && !PDFUtil.isPDFCosObjectRefEqual(node, (PDFCosObject)iter.next())) {
            ++i;
        }
        return i;
    }

    static class PDFPagesAnnotationIterator
    implements PDFAnnotationIterator {
        Iterator<PDFPage> mPagesIterator = null;
        PDFAnnotationIterator mAnnotsIterator = null;

        PDFPagesAnnotationIterator(PDFPageTreeNode root) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            this.mPagesIterator = root.iterator();
            if (this.mPagesIterator == null && root instanceof PDFPage) {
                PDFPage nextPage = (PDFPage)root;
                PDFAnnotationList annots = nextPage.getAnnotationList();
                this.mAnnotsIterator = annots == null ? null : annots.iterator();
            }
        }

        @Override
        public void remove() throws PDFUnsupportedFeatureException {
            this.mAnnotsIterator.remove();
        }

        @Override
        public boolean hasNext() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (this.mAnnotsIterator != null && this.mAnnotsIterator.hasNext()) {
                return true;
            }
            if (this.mPagesIterator == null) {
                return false;
            }
            while (this.mAnnotsIterator == null || !this.mAnnotsIterator.hasNext()) {
                this.mAnnotsIterator = this.getNextAnnotsIterator();
                if (this.mAnnotsIterator != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public PDFAnnotation next() {
            return this.mAnnotsIterator.next();
        }

        private PDFAnnotationIterator getNextAnnotsIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFAnnotationIterator nextAnnotsIterator = null;
            while (nextAnnotsIterator == null && this.mPagesIterator.hasNext()) {
                PDFPage nextPage = this.mPagesIterator.next();
                PDFAnnotationList annots = nextPage.getAnnotationList();
                if (annots == null) continue;
                nextAnnotsIterator = annots.iterator();
            }
            return nextAnnotsIterator;
        }
    }

    public class PDFPageTreePagesIterator {
        PDFPageTreeNode mParentNode;
        Iterator<PDFPageTreeNode> mParentKidsIter;
        Iterator<PDFPage> mNodeIterator;
        private Set<Integer> visitedSet;
        private Integer lastVisitedPage;

        private PDFPageTreePagesIterator(PDFPageTreeNode parentNode, PDFPageTreeNode startingNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFPageTreeNode curParent = parentNode;
            PDFPageTreeList parentKids = null;
            this.mParentKidsIter = null;
            int kidsInd = 0;
            this.mParentNode = curParent != null ? curParent.getParent() : null;
            this.visitedSet = new HashSet<Integer>();
            if (this.mParentNode != null) {
                parentKids = this.mParentNode.getKids();
            }
            if (parentKids != null) {
                kidsInd = parentKids.indexOf(curParent) + 1;
                this.mParentKidsIter = parentKids.iterator(kidsInd);
            }
            if (parentNode != null) {
                if (startingNode != null) {
                    this.mNodeIterator = parentNode.iterator(startingNode);
                    this.lastVisitedPage = startingNode.getCosObject().getObjNum();
                    this.visitedSet.add(this.lastVisitedPage);
                } else {
                    this.mNodeIterator = parentNode.iterator();
                }
            }
        }

        public boolean hasNext() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFPageTreeNode curNode;
            if (this.mNodeIterator != null && this.mNodeIterator.hasNext()) {
                if (!this.visitedSet.contains(this.mNodeIterator.next().getCosObject().getObjNum())) {
                    return true;
                }
                throw new RuntimeException("Cycle has been detected in page tree");
            }
            if (this.mParentKidsIter != null && this.mParentKidsIter.hasNext()) {
                curNode = this.mParentKidsIter.next();
            } else {
                curNode = this.mParentNode;
                this.mParentNode = this.mParentNode.getParent();
                if (this.mParentNode == null) {
                    return false;
                }
                PDFPageTreeList parentKids = this.mParentNode.getKids();
                if (parentKids == null) {
                    this.mParentKidsIter = null;
                } else {
                    int kidsInd = parentKids.indexOf(curNode) + 1;
                    this.mParentKidsIter = parentKids.iterator(kidsInd);
                }
                curNode = this.mParentKidsIter != null && this.mParentKidsIter.hasNext() ? this.mParentKidsIter.next() : null;
            }
            this.mNodeIterator = curNode != null ? curNode.iterator() : null;
            return this.hasNext();
        }

        public PDFPage next() {
            if (this.mNodeIterator != null) {
                PDFPage page = this.mNodeIterator.next();
                if (page != null) {
                    this.lastVisitedPage = page.getCosObject().getObjNum();
                }
                this.visitedSet.add(this.lastVisitedPage);
                return page;
            }
            return null;
        }

        public void remove() {
            if (this.mNodeIterator != null) {
                this.mNodeIterator.remove();
                this.visitedSet.remove(this.lastVisitedPage);
            }
        }
    }

    protected static class PageIterator
    implements Iterator<PDFPage> {
        private final ArrayListStack nodeStack = new ArrayListStack();
        private PDFPage currentPage;
        private PDFPage nextPage;
        private Set<Integer> vistedSet;

        protected PageIterator(PDFPageTreeNode rootNode) {
            this.nodeStack.push(rootNode);
            this.vistedSet = new HashSet<Integer>();
        }

        @Override
        public boolean hasNext() {
            boolean retValue = false;
            if (this.nextPage == null) {
                try {
                    this.nextPage = this.getNext();
                }
                catch (PDFException pDFException) {
                    // empty catch block
                }
            }
            if (this.nextPage != null) {
                if (!this.vistedSet.contains(this.nextPage.getCosObject().getObjNum())) {
                    retValue = true;
                } else {
                    throw new RuntimeException("Cycle has been detected in page tree");
                }
            }
            return retValue;
        }

        @Override
        public PDFPage next() {
            if (this.nextPage == null) {
                try {
                    this.currentPage = this.getNext();
                }
                catch (PDFException e) {
                    return null;
                }
            } else {
                this.currentPage = this.nextPage;
                Integer value = this.currentPage.getCosObject().getObjNum();
                if (value != 0) {
                    this.vistedSet.add(value);
                }
                this.nextPage = null;
            }
            return this.currentPage;
        }

        @Override
        public void remove() {
            if (this.currentPage == null) {
                throw new IllegalStateException("Can't remove page.");
            }
            try {
                PDFPageTreeNode parent = this.currentPage.getParent();
                this.vistedSet.remove(this.currentPage.getCosObject().getObjNum());
                parent.removeKid(this.currentPage);
                this.currentPage = null;
            }
            catch (PDFException e) {
                IllegalStateException ise = new IllegalStateException("Can't remove page.");
                ise.initCause(e);
                throw ise;
            }
        }

        private PDFPage getNext() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFPageTreeNode top = null;
            PDFPage next = null;
            while (!this.nodeStack.empty()) {
                top = (PDFPageTreeNode)this.nodeStack.pop();
                if (top instanceof PDFPage) {
                    next = (PDFPage)top;
                    break;
                }
                PDFPageTreeList nodeList = top.getKids();
                for (int i = nodeList.size() - 1; i >= 0; --i) {
                    this.nodeStack.push(nodeList.get(i));
                }
            }
            return next;
        }
    }

    class PDFPageTreeNodeIterator
    implements Iterator<PDFPage> {
        private PDFPageTreeNode mCurNode;
        private PDFPageTreeNodeIterator mCurNodeSubtreeIterator;
        private PDFPageTreeNodeListIterator mRootsChildrenIterator;
        private PDFPageTreeNode mRoot;
        private Set<Integer> visitedSet;

        private void initialize(PDFPageTreeNode root) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            this.mRoot = root;
            this.mCurNode = null;
            this.mCurNodeSubtreeIterator = null;
            this.mRootsChildrenIterator = null;
            this.visitedSet = new HashSet<Integer>();
            this.visitedSet.add(root.getCosObject().getObjNum());
            PDFPageTreeList kids = root.getKids();
            if (kids != null) {
                this.mRootsChildrenIterator = new PDFPageTreeNodeListIterator(kids, this.visitedSet);
            }
        }

        PDFPageTreeNodeIterator(PDFPageTreeNode root) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            this.initialize(root);
        }

        PDFPageTreeNodeIterator(PDFPageTreeNode parent, int index) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            this(parent);
            while (this.hasNext() && index > 0) {
                this.next();
                --index;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.mRootsChildrenIterator == null) {
                return false;
            }
            if (this.mCurNode == null) {
                return this.mRootsChildrenIterator.hasNext();
            }
            if (this.mCurNode instanceof PDFPage) {
                return this.mRootsChildrenIterator.hasNext();
            }
            if (this.mCurNodeSubtreeIterator.hasNext()) {
                return true;
            }
            return this.mRootsChildrenIterator.hasNext();
        }

        @Override
        public PDFPage next() {
            try {
                if (this.mRootsChildrenIterator == null) {
                    return null;
                }
                if (this.mCurNode == null) {
                    this.mCurNode = (PDFPageTreeNode)this.mRootsChildrenIterator.next();
                } else if (this.mCurNode instanceof PDFPage) {
                    this.mCurNode = (PDFPageTreeNode)this.mRootsChildrenIterator.next();
                }
                if (this.mCurNode == null) {
                    return null;
                }
                if (this.mCurNode instanceof PDFPage) {
                    this.mCurNodeSubtreeIterator = null;
                    this.visitedSet.add(((PDFPage)this.mCurNode).getCosObject().getObjNum());
                    return (PDFPage)this.mCurNode;
                }
                if (this.mCurNodeSubtreeIterator == null) {
                    this.mCurNodeSubtreeIterator = (PDFPageTreeNodeIterator)this.mCurNode.iterator();
                }
                PDFPage ret_obj = null;
                if (this.mCurNodeSubtreeIterator.hasNext()) {
                    ret_obj = this.mCurNodeSubtreeIterator.next();
                    if (ret_obj == null) {
                        throw new RuntimeException("Assumption Violation in PDFPageTreeNode : TreeNode has no leaf pages");
                    }
                    return ret_obj;
                }
                this.initCurNode();
                return this.next();
            }
            catch (PDFException e) {
                NoSuchElementException newException = new NoSuchElementException("Error during PDFPageTreeNodeIterator.next().");
                newException.initCause(e);
                throw newException;
            }
        }

        @Override
        public void remove() {
            try {
                if (this.mCurNode instanceof PDFPage) {
                    this.mRoot.decrementCount();
                    this.mRootsChildrenIterator.remove();
                    this.visitedSet.remove(((PDFPage)this.mCurNode).getCosObject().getObjNum());
                    if (this.mRoot.getCount() == 0) {
                        this.initCurNode();
                    }
                } else if (this.mCurNodeSubtreeIterator.subremove()) {
                    this.mRootsChildrenIterator.remove();
                    if (this.mRoot.getCount() == 0) {
                        this.initCurNode();
                    }
                }
            }
            catch (PDFException e) {
                IllegalStateException newException = new IllegalStateException("Error during PDFPageTreeNodeIterator.remove().");
                newException.initCause(e);
                throw newException;
            }
        }

        private boolean subremove() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (this.mCurNode instanceof PDFPage) {
                this.mRoot.decrementCount();
                this.mRootsChildrenIterator.remove();
                if (this.mRoot.getCount() == 0) {
                    this.mRoot.removeKids();
                    return true;
                }
                return false;
            }
            if (this.mCurNodeSubtreeIterator.subremove()) {
                this.mRootsChildrenIterator.remove();
                return this.mRoot.getCount() == 0;
            }
            return false;
        }

        private void initCurNode() {
            this.mCurNode = null;
            this.mCurNodeSubtreeIterator = null;
        }
    }

    class PDFPageTreeNodeListIterator
    extends PDFCosArrayList.PDFCosArrayListIterator {
        private Set<Integer> visitedSet;

        PDFPageTreeNodeListIterator(PDFPageTreeList kids, Set<Integer> visitedSet) {
            PDFPageTreeList pDFPageTreeList = kids;
            pDFPageTreeList.getClass();
            super(kids.getCosArray());
            this.visitedSet = visitedSet;
        }

        @Override
        public boolean hasNext() {
            if (!super.hasNext()) {
                return false;
            }
            PDFPageTreeNode curNode = (PDFPageTreeNode)super.next();
            if (!(curNode instanceof PDFPage)) {
                PDFPageTreeList kids = null;
                try {
                    kids = curNode.getKids();
                }
                catch (PDFException e) {
                    throw new RuntimeException("PDF error in Page Tree iterator", e);
                }
                if (kids != null && kids.isEmpty()) {
                    return this.hasNext();
                }
            }
            super.previous();
            if (!this.visitedSet.contains(curNode.getCosObject().getObjNum())) {
                throw new RuntimeException("Cycle has been detected in page tree");
            }
            return true;
        }

        @Override
        public boolean hasPrevious() {
            if (!super.hasPrevious()) {
                return false;
            }
            Object curNode = super.previous();
            if (!(curNode instanceof PDFPage)) {
                PDFPageTreeList kids = null;
                try {
                    kids = ((PDFPageTreeNode)curNode).getKids();
                }
                catch (PDFException e) {
                    throw new RuntimeException("PDF error in Page Tree iterator", e);
                }
                if (kids != null && kids.isEmpty()) {
                    return this.hasPrevious();
                }
            }
            super.next();
            return true;
        }
    }
}

