/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFieldLock;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureFieldSeedValue;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearanceCharacteristics;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;

public class PDFFieldSignature
extends PDFField {
    static final String DEFAULT_SIGNATURENAME = "SignatureField";
    private static final int ROTATE_360 = 360;

    protected PDFFieldSignature(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFieldSignature getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFieldSignature pdfObject = (PDFFieldSignature)PDFCosObject.getCachedInstance(cosObject, PDFFieldSignature.class);
        if (pdfObject == null) {
            pdfObject = new PDFFieldSignature(cosObject);
        }
        return pdfObject;
    }

    public PDFSignature getSignature() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject vObject = PDFCosUtils.getInheritableValue(ASName.k_V, ASName.k_Parent, this);
        if (vObject != null && vObject.getType() == 6) {
            return PDFFieldUtils.getSignature((CosDictionary)vObject);
        }
        return null;
    }

    public void setSignature(PDFSignature signature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_V, signature);
    }

    public PDFFieldLock getPDFFieldLock() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFieldLock.getInstance(PDFCosUtils.getInheritableValue(ASName.k_Lock, ASName.k_Parent, this));
    }

    public void setPDFFieldLock(PDFFieldLock fieldLock) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Lock, fieldLock);
    }

    public PDFSignatureFieldSeedValue getFieldSeedValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSignatureFieldSeedValue.getInstance(PDFCosUtils.getInheritableValue(ASName.k_SV, ASName.k_Parent, this));
    }

    public void setFieldSeedValue(PDFSignatureFieldSeedValue seedValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_SV, seedValue);
    }

    public void setRotationAngle(PDFRotation annotRotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        int pageRotationAngle;
        int widgetRotationAngle;
        PDFAppearanceCharacteristics apCharacteristics = this.getAnnotation().getAppearanceCharacteristics();
        if (apCharacteristics == null) {
            apCharacteristics = PDFAppearanceCharacteristics.newInstance(this.getPDFDocument());
        }
        if ((widgetRotationAngle = (pageRotationAngle = this.getAnnotation().getPage().getRotation().getValue()) + annotRotationAngle.getValue()) >= 360) {
            widgetRotationAngle -= 360;
        }
        apCharacteristics.setRotation(PDFRotation.getInstance(widgetRotationAngle));
        this.getAnnotation().setAppearanceCharacteristics(apCharacteristics);
    }

    public int getRotationAngle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAppearanceCharacteristics apCharacteristics = this.getAnnotation().getAppearanceCharacteristics();
        if (apCharacteristics == null) {
            return 0;
        }
        return apCharacteristics.getRotation().getValue();
    }

    public PDFAnnotationWidget getAnnotation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationIterator iter = this.getAnnotationsIterator();
        if (iter.hasNext()) {
            return (PDFAnnotationWidget)iter.next();
        }
        return null;
    }
}

