/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;

public class PDFActionNamed
extends PDFAction {
    private PDFActionNamed(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFActionNamed(PDFDocument pdfDocument, ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_Named);
        this.setName(name);
    }

    public static PDFActionNamed getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionNamed pdfObject = (PDFActionNamed)PDFCosObject.getCachedInstance(cosObject, PDFActionNamed.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionNamed(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionNamed newSkeletonInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosActionGoTo = PDFCosObject.newCosDictionary(pdfDocument);
        cosActionGoTo.put(ASName.k_Type, ASName.k_Action);
        cosActionGoTo.put(ASName.k_S, ASName.k_Named);
        return new PDFActionNamed(cosActionGoTo);
    }

    public static PDFActionNamed newInstance(PDFDocument pdfDocument, ASName name) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return new PDFActionNamed(pdfDocument, name);
    }

    public boolean hasName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_N);
    }

    public ASName getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_N);
    }

    public void setName(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (name == null) {
            throw new PDFInvalidDocumentException("Name can't be null, it's a required key");
        }
        this.setDictionaryNameValue(ASName.k_N, name);
    }
}

