/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.pdftoolkit.color.ColorManager;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.cmykresources.ResourcesBuilder;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.io.IOException;
import java.io.InputStream;

public class PDFColorSpaceDeviceCMYK
extends PDFColorSpace {
    private static final double[] defaultColor = new double[]{0.0, 0.0, 0.0, 1.0};
    private static final double[] componentsRange = new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0};
    private static volatile ICC_Profile iccProfile = null;

    public static PDFColorSpaceDeviceCMYK newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException {
        CosName cosObject = PDFCosObject.newCosName(pdfDocument, ASName.k_DeviceCMYK);
        return new PDFColorSpaceDeviceCMYK(cosObject);
    }

    private PDFColorSpaceDeviceCMYK(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFColorSpaceDeviceCMYK getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFColorSpaceDeviceCMYK pdfObject = (PDFColorSpaceDeviceCMYK)PDFCosObject.getCachedInstance(cosObject, PDFColorSpaceDeviceCMYK.class);
        if (pdfObject == null) {
            pdfObject = new PDFColorSpaceDeviceCMYK(cosObject);
        }
        return pdfObject;
    }

    @Override
    public ASName getName() {
        return ASName.k_DeviceCMYK;
    }

    @Override
    public int getNumberOfComponents() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ColorSpace createColorSpace() {
        if (iccProfile == null) {
            try {
                Class<ICC_Profile> clazz = ICC_Profile.class;
                synchronized (ICC_Profile.class) {
                    if (iccProfile == null) {
                        InputStream is = ResourcesBuilder.loadCMYKResources();
                        iccProfile = ICC_Profile.getInstance(is);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (IOException e) {
                throw new PDFRuntimeException(null, e);
            }
        }
        {
            return new ICC_ColorSpace(iccProfile);
        }
    }

    @Override
    public ColorModel createColorModel(int bpc, int transferType) {
        int[] nbBits = new int[]{bpc, bpc, bpc, bpc};
        ComponentColorModel componentColorModel = new ComponentColorModel(this.createColorSpace(), nbBits, false, false, 1, transferType);
        return componentColorModel;
    }

    @Override
    public double[] getRange() {
        return componentsRange;
    }

    @Override
    public double[] toRGB(double[] colorValues) {
        colorValues = super.toRGB(colorValues);
        return ColorManager.convertICCToDeviceRGB(colorValues, this.createColorSpace());
    }

    @Override
    public double[] getDefaultColor() {
        return defaultColor;
    }
}

