/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationExplicit;

public class PDFOpenAction
extends PDFCosObject {
    private final boolean isAction;

    private PDFOpenAction(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
        this.isAction = cosObject instanceof CosDictionary;
    }

    public static PDFOpenAction getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOpenAction pdfObject = (PDFOpenAction)PDFCosObject.getCachedInstance(cosObject, PDFOpenAction.class);
        if (pdfObject == null) {
            pdfObject = new PDFOpenAction(cosObject);
        }
        return pdfObject;
    }

    public static PDFOpenAction newInstance(PDFDocument pdfDocument, PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (action == null) {
            return null;
        }
        return new PDFOpenAction(action.getCosObject());
    }

    public static PDFOpenAction newInstance(PDFDocument pdfDocument, PDFDestinationExplicit destination) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (destination == null) {
            return null;
        }
        return new PDFOpenAction(destination.getCosObject());
    }

    public boolean isAction() {
        return this.isAction;
    }

    public boolean isDestination() {
        return !this.isAction;
    }

    public PDFAction getAction() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isAction) {
            return PDFActionFactory.getInstance(this.getCosObject());
        }
        return null;
    }

    public PDFDestinationExplicit getDestination() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.isAction) {
            return PDFDestinationExplicit.getInstance(this.getCosObject());
        }
        return null;
    }
}

