/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;

public class PDFTimeStampSeed
extends PDFCosDictionary {
    private static final int kTimeStampRequired = 1;
    public static final ASName k_URL = ASName.create("URL");
    public static final ASName k_Ff = ASName.create("Ff");

    private PDFTimeStampSeed(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFTimeStampSeed getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFTimeStampSeed pdfObject = (PDFTimeStampSeed)PDFCosObject.getCachedInstance(cosObject, PDFTimeStampSeed.class);
        if (pdfObject == null) {
            pdfObject = new PDFTimeStampSeed(cosObject);
        }
        return pdfObject;
    }

    public static PDFTimeStampSeed newInstance(PDFDocument pdfDocument, String url) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFTimeStampSeed pdfObject = new PDFTimeStampSeed(cosObject);
        pdfObject.setURL(url);
        return pdfObject;
    }

    public String getURL() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(k_URL)) {
            return this.getDictionaryStringValue(k_URL).asString();
        }
        return null;
    }

    public void setURL(String url) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (url == null) {
            throw new PDFInvalidParameterException("A URL is required in the time stamp seed dictionary.");
        }
        this.setDictionaryStringValue(k_URL, url);
    }

    public void setURL(String url, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (url == null) {
            throw new PDFInvalidParameterException("A URL is required in the time stamp seed dictionary.");
        }
        this.setDictionaryStringValue(k_URL, url, unicode);
    }

    public boolean requiresTimeStamp() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getCosDictionary().get(k_Ff);
        if (cosObject != null) {
            return cosObject.intValue() == 1;
        }
        return false;
    }

    public void setRequiresTimeStamp(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(k_Ff, value ? 1L : 0L);
    }
}

