/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption;

import com.adobe.internal.pdftoolkit.core.encryption.StandardCipherSecurityManager;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityManager;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityLockPasswordInterface;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityProvidersImpl;
import java.util.Map;

public class SecurityLockPasswordImpl
implements SecurityLockPasswordInterface {
    private SecurityManager mSecurityMgr;
    private Map mEncryptParams;

    public SecurityLockPasswordImpl() {
    }

    protected SecurityLockPasswordImpl(byte[] owner, byte[] user, Map encryptParams, PermissionProvider encryptionPermissions, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        this.mSecurityMgr = StandardCipherSecurityManager.newInstance(owner, user, encryptParams, encryptionPermissions, providers);
    }

    @Override
    public SecurityLockPasswordInterface makeSecurityLock(byte[] owner, byte[] user, Map encryptParams, PermissionProvider encryptionPermissions, SecurityProvidersImpl providers) throws PDFSecurityException {
        this.mEncryptParams = encryptParams;
        return new SecurityLockPasswordImpl(owner, user, encryptParams, encryptionPermissions, providers);
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.mSecurityMgr;
    }

    @Override
    public Map getEncryptParameters() {
        return this.mEncryptParams;
    }

    @Override
    public void setEncryptParameters(Map encryptParams) {
        this.mEncryptParams = encryptParams;
    }

    @Override
    public boolean shouldEncrypt() {
        return true;
    }
}

