/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import com.adobe.internal.io.ByteWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.NonWritableChannelException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemoryMappedByteWriter
implements ByteWriter {
    private boolean closed = false;
    private long fileLength = -1L;
    private static final int DEFAULT_BUFFERSIZE = 4096;
    private static final int DEFAULT_NUMBERBUFFERS = 4;
    private int numberOfBuffers;
    private int bufferSize;
    private RandomAccessFile file;
    private Buffer[] buffers;
    private long counter;
    private Buffer mru;
    private List<MappedBufferReference> mmBuffers = new ArrayList<MappedBufferReference>();
    private long mmBuffersLimit;
    private boolean disableMMBuffers;
    private static final int MM_THRESHOLD = 409600;
    private static final int MM_RELOAD_CHUNK_SIZE = 262144;
    private static final int MM_SIZE_LIMIT = 0x4000000;

    public MemoryMappedByteWriter(RandomAccessFile file, int numberOfBuffers, int bufferSize) {
        if (numberOfBuffers < 1 || bufferSize < 1) {
            throw new IllegalArgumentException("Invalid buffer size or number of buffers.");
        }
        this.numberOfBuffers = numberOfBuffers;
        this.bufferSize = bufferSize;
        this.file = file;
        this.buffers = new Buffer[this.numberOfBuffers];
        for (int i = 0; i < this.numberOfBuffers; ++i) {
            this.buffers[i] = new Buffer();
        }
        this.mru = this.buffers[0];
        try {
            this.refreshMappedBuffers(false, 409600);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public MemoryMappedByteWriter(RandomAccessFile file) {
        this(file, 4, 4096);
    }

    @Override
    public void write(long position, int b) throws IOException {
        if (this.closed) {
            throw new IOException("ByteReader was closed");
        }
        boolean bufFound = false;
        if (this.fileLength == -1L) {
            this.fileLength = this.file.length();
        }
        if (position < 0L) {
            throw new IOException("Position is less than zero.");
        }
        if (position >= this.mru.base && position < this.mru.base + (long)this.bufferSize) {
            bufFound = true;
        } else {
            for (int bufferIndex = 0; bufferIndex < this.numberOfBuffers; ++bufferIndex) {
                Buffer currentBuffer = this.buffers[bufferIndex];
                if (position < currentBuffer.base || position >= currentBuffer.base + (long)this.bufferSize) continue;
                this.mru = currentBuffer;
                bufFound = true;
                break;
            }
        }
        if (!bufFound) {
            try {
                byte[] data = new byte[]{(byte)(b & 0xFF)};
                this.writeToMappedBuffer(position, data, 0, 0, true);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.mru = this.loadLRU(position);
            bufFound = true;
        }
        this.mru.references = ++this.counter;
        ((Buffer)this.mru).data[(int)(position - ((Buffer)this.mru).base)] = (byte)(b & 0xFF);
        this.mru.bytesUsed = (int)Math.max((long)this.mru.bytesUsed, position - this.mru.base + 1L);
        this.mru.isDirty = true;
        this.fileLength = Math.max(this.fileLength, position + 1L);
    }

    @Override
    public void write(long position, byte[] b, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("ByteReader was closed");
        }
        boolean bufFound = false;
        if (this.fileLength == -1L) {
            this.fileLength = this.file.length();
        }
        if (position < 0L) {
            throw new IOException("Position is less than zero.");
        }
        if (position >= this.mru.base && position + (long)length <= this.mru.base + (long)this.bufferSize) {
            bufFound = true;
        } else {
            for (int bufferIndex = 0; bufferIndex < this.numberOfBuffers; ++bufferIndex) {
                Buffer currentBuffer = this.buffers[bufferIndex];
                if (position < currentBuffer.base || position + (long)length > currentBuffer.base + (long)this.bufferSize) continue;
                this.mru = currentBuffer;
                bufFound = true;
                break;
            }
        }
        if (!bufFound) {
            this.writeToMappedBuffer(position, b, offset, length, false);
            if (this.mru.buffersRequiredForRequest(position, length) != 1) {
                this.flush();
                this.file.seek(position);
                this.file.write(b, offset, length);
                this.fileLength = this.file.length();
                return;
            }
            this.mru = this.loadLRU(position);
            bufFound = true;
        }
        this.mru.references = ++this.counter;
        System.arraycopy(b, offset, this.mru.data, (int)(position - this.mru.base), length);
        this.mru.bytesUsed = (int)Math.max((long)this.mru.bytesUsed, position - this.mru.base + (long)length);
        this.mru.isDirty = true;
        this.fileLength = Math.max(this.fileLength, position + (long)length);
    }

    @Override
    public long length() throws IOException {
        if (this.closed) {
            throw new IOException("ByteReader was closed");
        }
        if (this.fileLength == -1L) {
            this.fileLength = this.file.length();
        }
        return this.fileLength;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("ByteReader was closed");
        }
        for (int bufferIndex = 0; bufferIndex < this.numberOfBuffers; ++bufferIndex) {
            if (this.buffers[bufferIndex].isDirty) {
                this.buffers[bufferIndex].flushBuffer();
            }
            this.buffers[bufferIndex].resetBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        this.closed = true;
        this.file.close();
    }

    @Override
    public int read(long position) throws IOException {
        if (this.closed) {
            throw new IOException("ByteReader was closed");
        }
        boolean bufFound = false;
        if (this.fileLength == -1L) {
            this.fileLength = this.file.length();
        }
        if (position < 0L || position >= this.fileLength) {
            return -1;
        }
        if (position >= this.mru.base && position < this.mru.base + (long)this.bufferSize) {
            bufFound = true;
        } else {
            for (int bufferIndex = 0; bufferIndex < this.numberOfBuffers; ++bufferIndex) {
                Buffer currentBuffer = this.buffers[bufferIndex];
                if (position < currentBuffer.base || position >= currentBuffer.base + (long)this.bufferSize) continue;
                this.mru = currentBuffer;
                bufFound = true;
                break;
            }
        }
        if (!bufFound) {
            this.mru = this.loadLRU(position);
            bufFound = true;
        }
        this.mru.references = ++this.counter;
        return this.mru.data[(int)(position - this.mru.base)] & 0xFF;
    }

    @Override
    public int read(long position, byte[] b, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("ByteReader was closed");
        }
        boolean bufFound = false;
        if (this.fileLength == -1L) {
            this.fileLength = this.file.length();
        }
        if (position < 0L || position >= this.fileLength) {
            return -1;
        }
        length = (int)Math.min((long)length, this.fileLength - position);
        if (position >= this.mru.base && position + (long)length <= this.mru.base + (long)this.bufferSize) {
            bufFound = true;
        } else {
            for (int bufferIndex = 0; bufferIndex < this.numberOfBuffers; ++bufferIndex) {
                Buffer currentBuffer = this.buffers[bufferIndex];
                if (position < currentBuffer.base || position + (long)length > currentBuffer.base + (long)this.bufferSize) continue;
                this.mru = currentBuffer;
                bufFound = true;
                break;
            }
        }
        if (!bufFound) {
            if (this.mru.buffersRequiredForRequest(position, length) != 1) {
                this.flush();
                int alreadyReadLength = 0;
                ArrayList<Integer> lengthList = new ArrayList<Integer>();
                lengthList.add(length);
                lengthList = this.readFromMappedBuffer(position, b, position, offset, lengthList);
                length = lengthList.get(0);
                alreadyReadLength = lengthList.get(1);
                if (lengthList.size() == 3) {
                    return alreadyReadLength + length;
                }
                if (length > 0) {
                    this.file.seek(position);
                    return this.file.read(b, offset, length);
                }
                return alreadyReadLength + length;
            }
            this.mru = this.loadLRU(position);
            bufFound = true;
        }
        this.mru.references = ++this.counter;
        System.arraycopy(this.mru.data, (int)(position - this.mru.base), b, offset, length);
        return length;
    }

    private Buffer loadLRU(long position) throws IOException {
        Buffer lru = null;
        long minCounter = Long.MAX_VALUE;
        for (int bufferIndex = 0; bufferIndex < this.numberOfBuffers; ++bufferIndex) {
            if (this.buffers[bufferIndex].references >= minCounter) continue;
            lru = this.buffers[bufferIndex];
            minCounter = lru.references;
        }
        if (lru.isDirty) {
            lru.flushBuffer();
        }
        lru.loadBuffer(position);
        return lru;
    }

    private void refreshMappedBuffers(boolean doFlush, int threshold) throws IOException {
        long extra;
        if (!this.disableMMBuffers && (extra = this.length() - this.mmBuffersLimit) > (long)threshold) {
            if (doFlush) {
                this.flush();
            }
            if (this.mmBuffers.size() > 0) {
                MappedBufferReference mbRef = this.mmBuffers.get(this.mmBuffers.size() - 1);
                int mbRefLimit = mbRef.mappedByteBuffer.limit();
                if ((long)mbRefLimit < 0x4000000L - extra) {
                    this.mmBuffers.remove(this.mmBuffers.size() - 1);
                    this.mmBuffersLimit -= (long)mbRefLimit;
                    this.addMappedBuffer(mbRef.base, (long)mbRefLimit + extra);
                } else {
                    this.addMappedBuffer(this.mmBuffersLimit, extra);
                }
            } else {
                this.addMappedBuffer(0L, extra);
            }
        }
    }

    private void addMappedBuffer(long offset, long size) {
        for (long i = offset; i < size; i += 0x4000000L) {
            long bufSize = size < i + 0x4000000L ? size : i + 0x4000000L;
            try {
                this.mmBuffers.add(new MappedBufferReference(this.file.getChannel().map(FileChannel.MapMode.READ_WRITE, i, bufSize), i, true));
                this.mmBuffersLimit += size;
                continue;
            }
            catch (NonWritableChannelException ex) {
                try {
                    this.mmBuffers.add(new MappedBufferReference(this.file.getChannel().map(FileChannel.MapMode.READ_ONLY, i, bufSize), i, false));
                }
                catch (IOException e) {
                    this.disableMMBuffers = true;
                }
                this.mmBuffersLimit += size;
                continue;
            }
            catch (IOException e) {
                this.disableMMBuffers = true;
            }
        }
    }

    private void writeToMappedBuffer(long position, byte[] data, int offset, int length, boolean isSingleByte) throws IOException {
        this.refreshMappedBuffers(true, 262144);
        if (!this.disableMMBuffers && position < this.mmBuffersLimit) {
            for (MappedBufferReference mbRef : this.mmBuffers) {
                int bufPosition = mbRef.getPosition(position);
                if (mbRef.isWritable && bufPosition > 0) {
                    mbRef.mappedByteBuffer.position(bufPosition);
                    if (isSingleByte) {
                        mbRef.mappedByteBuffer.put(data[0]);
                    } else {
                        int size = bufPosition + length > mbRef.mappedByteBuffer.limit() ? mbRef.mappedByteBuffer.limit() - bufPosition : length;
                        mbRef.mappedByteBuffer.put(data, offset, size);
                        if (size < length) {
                            position += (long)size;
                            offset += size;
                            length -= size;
                        }
                    }
                    return;
                }
                if (mbRef.base <= position) continue;
                break;
            }
        }
    }

    private ArrayList<Integer> readFromMappedBuffer(long position, byte[] data, long startingBufferPosition, int offset, ArrayList<Integer> lengthList) throws IOException {
        int length = lengthList.get(0);
        int alreadyReadLength = 0;
        this.refreshMappedBuffers(false, 262144);
        for (int i = 0; i < this.mmBuffers.size(); ++i) {
            MappedBufferReference bufRef = this.mmBuffers.get(i);
            int bufferPosition = bufRef.getPosition(position);
            if (bufferPosition < 0) continue;
            int modifiedLength = Math.min(bufRef.mappedByteBuffer.limit() - bufferPosition, length);
            bufRef.mappedByteBuffer.position(bufferPosition);
            bufRef.mappedByteBuffer.get(data, offset, modifiedLength);
            if (modifiedLength == length) {
                lengthList.set(0, length);
                lengthList.add(1, alreadyReadLength);
                lengthList.add(2, alreadyReadLength + length);
                return lengthList;
            }
            startingBufferPosition += (long)modifiedLength;
            offset += modifiedLength;
            length -= modifiedLength;
            alreadyReadLength += modifiedLength;
        }
        lengthList.set(0, length);
        lengthList.add(1, alreadyReadLength);
        return lengthList;
    }

    public String toString() {
        return this.file.toString();
    }

    private class Buffer {
        private long base = Long.MAX_VALUE;
        private long references;
        private boolean isDirty = false;
        private int bytesUsed;
        private byte[] data;

        Buffer() {
            this.data = new byte[MemoryMappedByteWriter.this.bufferSize];
        }

        void loadBuffer(long position) throws IOException {
            this.base = this.calculateBufferBase(position);
            this.references = ++MemoryMappedByteWriter.this.counter;
            this.bytesUsed = (int)Math.min((long)MemoryMappedByteWriter.this.bufferSize, Math.max(MemoryMappedByteWriter.this.fileLength - this.base, 0L));
            if (this.base >= MemoryMappedByteWriter.this.fileLength) {
                return;
            }
            long startingBufferPosition = this.base;
            int offset = 0;
            int length = this.bytesUsed = (int)Math.min((long)MemoryMappedByteWriter.this.bufferSize, Math.max(MemoryMappedByteWriter.this.fileLength - this.base, 0L));
            ArrayList lengthList = new ArrayList();
            lengthList.add(length);
            lengthList = MemoryMappedByteWriter.this.readFromMappedBuffer(this.base, this.data, startingBufferPosition, offset, lengthList);
            int n = length = lengthList.size() == 3 ? 0 : (Integer)lengthList.get(0);
            if (length > 0) {
                MemoryMappedByteWriter.this.file.seek(startingBufferPosition);
                long bytesRead = MemoryMappedByteWriter.this.file.read(this.data, 0, this.bytesUsed);
                if (bytesRead != (long)this.bytesUsed && (bytesRead != -1L || this.bytesUsed != 0)) {
                    throw new IOException("Didn't read enough bytes from the file.  Expected = " + this.bytesUsed + ", Actual = " + bytesRead);
                }
            }
        }

        void flushBuffer() throws IOException {
            MemoryMappedByteWriter.this.file.seek(this.base);
            MemoryMappedByteWriter.this.file.write(this.data, 0, this.bytesUsed);
            this.isDirty = false;
        }

        void resetBuffer() {
            this.base = Long.MAX_VALUE;
        }

        int buffersRequiredForRequest(long position, int length) {
            long base = this.calculateBufferBase(position);
            long initialBufferSpace = (long)MemoryMappedByteWriter.this.bufferSize - (position - base);
            long overage = Math.max((long)length - initialBufferSpace, 0L);
            int extraBuffers = (int)Math.ceil((float)overage / (float)MemoryMappedByteWriter.this.bufferSize);
            return (length != 0 ? 1 : 0) + extraBuffers;
        }

        private long calculateBufferBase(long position) {
            return position / (long)MemoryMappedByteWriter.this.bufferSize * (long)MemoryMappedByteWriter.this.bufferSize;
        }
    }

    private class MappedBufferReference {
        private MappedByteBuffer mappedByteBuffer;
        private long base;
        private boolean isWritable;

        MappedBufferReference(MappedByteBuffer buf, long base, boolean isWritable) {
            this.mappedByteBuffer = buf;
            this.base = base;
            this.isWritable = isWritable;
        }

        public int getPosition(long position) {
            if (this.base <= position && position < this.base + (long)this.mappedByteBuffer.limit()) {
                return (int)(position - this.base);
            }
            return -1;
        }
    }
}

