/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement.platform;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.FontDescription;
import com.adobe.fontengine.fontmanagement.Platform;

public final class PlatformFontDescription
extends FontDescription {
    static final long serialVersionUID = 1L;
    private final Platform platform;
    private final ULocale locale;
    private final String platformFamilyName;

    public PlatformFontDescription(Platform platform, ULocale locale, String platformFamilyName) {
        if (platform == null || locale == null || platformFamilyName == null) {
            throw new NullPointerException("Platform, Locale, and Platform Name must not be null");
        }
        this.platform = platform;
        this.locale = locale;
        this.platformFamilyName = platformFamilyName;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public String getPlatformName() {
        return this.platformFamilyName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.locale.hashCode();
        result = 31 * result + this.platform.hashCode();
        result = 31 * result + this.platformFamilyName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformFontDescription)) {
            return false;
        }
        PlatformFontDescription other = (PlatformFontDescription)obj;
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        if (this.platform == null ? other.platform != null : !this.platform.equals(other.platform)) {
            return false;
        }
        return !(this.platformFamilyName == null ? other.platformFamilyName != null : !this.platformFamilyName.equals(other.platformFamilyName));
    }

    public String toString() {
        return new String("[" + this.platform + ", " + this.locale + "] - " + this.platformFamilyName);
    }
}

