/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import coldfusion.pdf.PDFFormException;
import coldfusion.pdf.core.PDFException;
import coldfusion.runtime.Array;
import coldfusion.runtime.Struct;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.jdom2.input.SAXBuilder;

public class XFAXMLtoCFStruct {
    private static final String BR = "Br";

    public static Map parseXMLtoCF(String xml) {
        boolean fromDataDescription = false;
        int i = ((String)xml).lastIndexOf("<xfa:data");
        if (i != -1) {
            int j = ((String)xml).indexOf(">", i + 9);
            if ((i = ((String)(xml = ((String)xml).substring(j + 1))).indexOf("</xfa:data>")) == -1) {
                i = ((String)xml).lastIndexOf("<dd:dataDescription");
                if (i != -1) {
                    i = ((String)xml).indexOf("</dd:dataDescription>");
                }
                if (i == -1) {
                    return new HashMap();
                }
                i += 21;
                fromDataDescription = true;
            }
            xml = ((String)xml).substring(0, i).trim();
        }
        int dataNodeStartLeftBracket = ((String)xml).indexOf("<");
        int dataNodeStartRightBracket = ((String)xml).indexOf(">");
        int dataNodeNameSpaceStartIndex = ((String)xml).indexOf(" ");
        if (dataNodeNameSpaceStartIndex != -1 && dataNodeNameSpaceStartIndex < dataNodeStartRightBracket) {
            dataNodeStartRightBracket = dataNodeNameSpaceStartIndex;
        }
        if (dataNodeStartRightBracket == -1 || ((String)xml).charAt(dataNodeStartRightBracket - 1) != '/') {
            if (dataNodeStartRightBracket < dataNodeStartLeftBracket) {
                throw new PDFException.InvalidDataXMLException();
            }
            String rootDataNodeName = ((String)xml).substring(dataNodeStartLeftBracket + 1, dataNodeStartRightBracket);
            int dataNodeEndLeftBracket = ((String)xml).indexOf("</" + rootDataNodeName + ">");
            if (dataNodeEndLeftBracket != -1) {
                xml = ((String)xml).substring(dataNodeStartLeftBracket, dataNodeEndLeftBracket + rootDataNodeName.length() + 3);
            }
        }
        String rootStart = "<xfa:datasets xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\">";
        String rootEnd = "</xfa:datasets>";
        if (fromDataDescription) {
            rootStart = "<dd:datasets xmlns:dd=\"http://www.xfa.org/schema/xfa-data/1.0/\">";
            rootEnd = "</dd:datasets>";
        }
        xml = rootStart + (String)xml + rootEnd;
        StringReader stringStream = new StringReader((String)xml);
        SAXBuilder builder = new SAXBuilder();
        Object returnMap = null;
        try {
            Document doc = builder.build((Reader)stringStream);
            if (fromDataDescription) {
                List children = ((Element)doc.getRootElement().getChildren().get(0)).getChildren();
                if (children == null || children.size() == 0) {
                    returnMap = new HashMap();
                }
                returnMap = XFAXMLtoCFStruct.visitNodes(children.get(0));
            } else {
                returnMap = XFAXMLtoCFStruct.visitNodes(((Element)doc.getContent().get(0)).getContent().get(0));
            }
        }
        catch (JDOMException e) {
            throw new PDFException.InvalidDataXMLException();
        }
        catch (IOException ioex) {
            throw new PDFFormException(ioex);
        }
        return (Map)returnMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object visitNodes(Object o) {
        if (o instanceof Element) {
            Struct nodeValueMap = new Struct(5);
            Element element = (Element)o;
            List children = element.getContent();
            Iterator iterator = children.iterator();
            Array translatedChildrenList = new Array(1);
            int i = 0;
            while (iterator.hasNext()) {
                Object child = iterator.next();
                Object transformeChild = XFAXMLtoCFStruct.visitNodes(child);
                if (transformeChild != null && transformeChild instanceof Map && ((Map)transformeChild).size() != 0) {
                    translatedChildrenList.add(transformeChild);
                } else if (transformeChild instanceof String && transformeChild != null && !"".equals(transformeChild)) {
                    translatedChildrenList.add(transformeChild);
                }
                ++i;
            }
            if (i > 1) {
                Map allChildren = XFAXMLtoCFStruct.convertToMap((List)translatedChildrenList);
                nodeValueMap.put((Object)element.getName(), (Object)allChildren);
                return nodeValueMap;
            } else if (i == 1) {
                if (translatedChildrenList.size() == 0) return nodeValueMap;
                Object firstElement = translatedChildrenList.get(0);
                nodeValueMap.put((Object)element.getName(), firstElement);
                return nodeValueMap;
            } else {
                if (i != 0) return nodeValueMap;
                String name = element.getName();
                if (BR.equalsIgnoreCase(name)) {
                    if (!Boolean.getBoolean("coldfusion.pdfform.acceptbrasnode")) return "<" + name + "/>";
                    nodeValueMap.put((Object)element.getName(), (Object)"");
                    return nodeValueMap;
                } else {
                    nodeValueMap.put((Object)element.getName(), (Object)"");
                }
            }
            return nodeValueMap;
        }
        if (o instanceof Document) {
            Document doc = (Document)o;
            List children = doc.getContent();
            Iterator iterator = children.iterator();
            if (!iterator.hasNext()) return "";
            Object child = iterator.next();
            return XFAXMLtoCFStruct.visitNodes(child);
        }
        if (!(o instanceof Text)) return "";
        Text t = (Text)o;
        return t.getText();
    }

    private static Map convertToMap(List elements) {
        Struct transformed = new Struct();
        Array a = (Array)elements;
        Collections.sort(elements, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof Map && o2 instanceof Map) {
                    String k1 = null;
                    Iterator i1 = ((Map)o1).keySet().iterator();
                    if (i1.hasNext()) {
                        k1 = (String)i1.next();
                    }
                    String k2 = null;
                    Iterator i2 = ((Map)o2).keySet().iterator();
                    if (i2.hasNext()) {
                        k2 = (String)i2.next();
                    }
                    if (k1 != null && k2 != null) {
                        return k1.compareTo(k2);
                    }
                }
                return 0;
            }
        });
        String previouskey = null;
        Object previousvalue = null;
        String k1 = null;
        Object value = null;
        for (Object element : a) {
            if (!(element instanceof Map)) continue;
            Iterator i1 = ((Map)element).keySet().iterator();
            if (i1.hasNext()) {
                k1 = (String)i1.next();
            }
            if (k1 == null) continue;
            value = ((Map)element).get(k1);
            if (k1.equals(previouskey)) {
                Object oldValue = transformed.get((Object)k1);
                if (oldValue != null && oldValue instanceof List) {
                    ((List)oldValue).add(value);
                } else {
                    Array valueList = new Array();
                    valueList.add(oldValue);
                    valueList.add(value);
                    transformed.remove((Object)k1);
                    transformed.put((Object)k1, (Object)valueList);
                }
            } else {
                transformed.put((Object)k1, value);
            }
            previouskey = k1;
            previousvalue = value;
        }
        return transformed;
    }
}

