/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.smscsim;

import java.io.IOException;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.Request;
import org.smpp.pdu.Response;
import org.smpp.smscsim.PDUProcessorGroup;

public abstract class PDUProcessor {
    private PDUProcessorGroup group = null;
    private boolean active = true;

    public PDUProcessor() {
    }

    public PDUProcessor(PDUProcessorGroup group) {
        this.setGroup(group);
    }

    public abstract void clientRequest(Request var1);

    public abstract void clientResponse(Response var1);

    public abstract void serverRequest(Request var1) throws IOException, PDUException;

    public abstract void serverResponse(Response var1) throws IOException, PDUException;

    public abstract void stop();

    public void setGroup(PDUProcessorGroup g) {
        if (this.group != null) {
            this.group.remove(this);
        }
        this.group = g;
        if (this.group != null) {
            this.group.add(this);
        }
    }

    public PDUProcessorGroup getGroup() {
        return this.group;
    }

    public boolean isActive() {
        return this.active;
    }

    protected void exit() {
        if (this.group != null) {
            this.group.remove(this);
        }
        this.active = false;
        this.stop();
    }
}

