/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import org.smpp.Data;
import org.smpp.pdu.ByteData;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class AddressRange
extends ByteData {
    private byte ton = Data.getDefaultTon();
    private byte npi = Data.getDefaultNpi();
    private String addressRange = "";

    public AddressRange() {
        this.setTon(Data.getDefaultTon());
        this.setNpi(Data.getDefaultNpi());
    }

    public AddressRange(String addressRange) throws WrongLengthOfStringException {
        this.setTon(Data.getDefaultTon());
        this.setNpi(Data.getDefaultNpi());
        this.setAddressRange(addressRange);
    }

    public AddressRange(byte ton, byte npi, String addressRange) throws WrongLengthOfStringException {
        this.setTon(ton);
        this.setNpi(npi);
        this.setAddressRange(addressRange);
    }

    public void setData(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, WrongLengthOfStringException {
        byte ton = buffer.removeByte();
        byte npi = buffer.removeByte();
        String addressRange = buffer.removeCString();
        this.setAddressRange(addressRange);
        this.setTon(ton);
        this.setNpi(npi);
    }

    public ByteBuffer getData() {
        ByteBuffer addressBuf = new ByteBuffer();
        addressBuf.appendByte(this.getTon());
        addressBuf.appendByte(this.getNpi());
        addressBuf.appendCString(this.getAddressRange());
        return addressBuf;
    }

    public void setTon(byte t) {
        this.ton = t;
    }

    public void setNpi(byte n) {
        this.npi = n;
    }

    public void setAddressRange(String a) throws WrongLengthOfStringException {
        AddressRange.checkCString(a, 41);
        this.addressRange = a;
    }

    public byte getTon() {
        return this.ton;
    }

    public byte getNpi() {
        return this.npi;
    }

    public String getAddressRange() {
        return this.addressRange;
    }

    public String debugString() {
        String dbgs = "(addrrang: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + Integer.toString(this.getTon());
        dbgs = dbgs + " ";
        dbgs = dbgs + Integer.toString(this.getNpi());
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getAddressRange();
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

