/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import org.smpp.Data;
import org.smpp.pdu.ByteData;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class Address
extends ByteData {
    private byte ton = 0;
    private byte npi = 0;
    private String address = "";
    private static int defaultMaxAddressLength = 21;
    private int maxAddressLength = defaultMaxAddressLength;

    public Address() {
        this(Data.getDefaultTon(), Data.getDefaultNpi(), defaultMaxAddressLength);
    }

    public Address(int maxAddressLength) {
        this(Data.getDefaultTon(), Data.getDefaultNpi(), maxAddressLength);
    }

    public Address(byte ton, byte npi, int maxAddressLength) {
        this.setTon(ton);
        this.setNpi(npi);
        try {
            this.setAddress("", maxAddressLength);
        }
        catch (WrongLengthOfStringException e) {
            throw new Error("Default address value was longer than default max address length.");
        }
    }

    public Address(String address) throws WrongLengthOfStringException {
        this(Data.getDefaultTon(), Data.getDefaultNpi(), address, defaultMaxAddressLength);
    }

    public Address(String address, int maxAddressLength) throws WrongLengthOfStringException {
        this(Data.getDefaultTon(), Data.getDefaultNpi(), address, maxAddressLength);
    }

    public Address(byte ton, byte npi, String address) throws WrongLengthOfStringException {
        this(ton, npi, address, defaultMaxAddressLength);
    }

    public Address(byte ton, byte npi, String address, int maxAddressLength) throws WrongLengthOfStringException {
        this.setTon(ton);
        this.setNpi(npi);
        this.setAddress(address, maxAddressLength);
    }

    public void setData(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, WrongLengthOfStringException {
        byte ton = buffer.removeByte();
        byte npi = buffer.removeByte();
        String address = buffer.removeCString();
        this.setAddress(address);
        this.setTon(ton);
        this.setNpi(npi);
    }

    public ByteBuffer getData() {
        ByteBuffer addressBuf = new ByteBuffer();
        addressBuf.appendByte(this.getTon());
        addressBuf.appendByte(this.getNpi());
        addressBuf.appendCString(this.getAddress());
        return addressBuf;
    }

    public void setTon(byte ton) {
        this.ton = ton;
    }

    public void setNpi(byte npi) {
        this.npi = npi;
    }

    public void setAddress(String address) throws WrongLengthOfStringException {
        this.setAddress(address, this.maxAddressLength);
    }

    public void setAddress(String address, int maxAddressLength) throws WrongLengthOfStringException {
        Address.checkCString(address, maxAddressLength);
        this.maxAddressLength = maxAddressLength;
        this.address = address;
    }

    public byte getTon() {
        return this.ton;
    }

    public byte getNpi() {
        return this.npi;
    }

    public String getAddress() {
        return this.address;
    }

    public String debugString() {
        String dbgs = "(addr: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + Integer.toString(this.getTon());
        dbgs = dbgs + " ";
        dbgs = dbgs + Integer.toString(this.getNpi());
        dbgs = dbgs + " ";
        dbgs = dbgs + this.getAddress();
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

