/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.StormBase;
import ice.storm.Viewport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Detour
implements PropertyChangeListener {
    public static final String TEMPLATE = "resources/detour_template.html";
    public static final String PLACEHOLDER = "[[ORIG_DEST]]";
    private static Detour instance = new Detour();
    private static boolean shouldDetour = true;
    private static StormBase base;
    private static boolean LOCAL_DEBUG;
    static /* synthetic */ Class class$ice$browser$Detour;

    protected Detour() {
    }

    public static Detour getInstance(StormBase base) {
        if (instance == null) {
            instance = new Detour();
        }
        Detour.base = base;
        base.addPropertyChangeListener((PropertyChangeListener)instance, null);
        return instance;
    }

    public static boolean firstExternalRequest() {
        if (!shouldDetour) {
            Detour.trace("Detour has already been taken");
        }
        return shouldDetour;
    }

    public static boolean isHTTPRequest(String destination) {
        if (destination.indexOf("http") < 0) {
            Detour.trace("Detour not required for non-http request");
            return false;
        }
        return true;
    }

    public static boolean shouldDetour(String destination) {
        return Detour.firstExternalRequest() && Detour.isHTTPRequest(destination);
    }

    public static void go(String destination, String viewport) {
        if (!Detour.shouldDetour(destination)) {
            base.renderContent(destination, null, viewport);
            return;
        }
        Detour.trace("Making a detour. Original destination: " + destination);
        try {
            base.renderContent(Detour.getDetourPage(destination), viewport);
        }
        catch (IOException e) {
            base.renderContent(destination, null, viewport);
        }
        shouldDetour = false;
    }

    private static void trace(String message) {
        if (Debug.trace) {
            Debug.trace((String)message);
        } else if (LOCAL_DEBUG) {
            System.out.println("[ICEreader Detour]\n  " + message);
        }
    }

    private static ContentLoader getDetourPage(String destination) throws IOException {
        String tmp;
        (class$ice$browser$Detour == null ? (class$ice$browser$Detour = Detour.class$("ice.browser.Detour")) : class$ice$browser$Detour).getClassLoader();
        InputStream templateStream = ClassLoader.getSystemResourceAsStream(TEMPLATE);
        StringBuffer buff = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(templateStream));
        while (reader.ready() && (tmp = reader.readLine()) != null) {
            buff.append(tmp + "\n");
        }
        reader.close();
        String modifiedPage = Detour.replace(buff.toString(), PLACEHOLDER, destination);
        ByteArrayInputStream in = new ByteArrayInputStream(modifiedPage.getBytes());
        return new ContentLoader(null, (InputStream)in, "text/html");
    }

    private static String replace(String orig, String oldString, String newString) {
        int startIndex = orig.indexOf(oldString);
        while (startIndex >= 0) {
            StringBuffer buff = new StringBuffer();
            buff.append(orig.substring(0, startIndex));
            buff.append(newString);
            buff.append(orig.substring(startIndex + oldString.length()));
            orig = buff.toString();
            startIndex = orig.indexOf(oldString);
        }
        return orig;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name == "location") {
            Viewport v = (Viewport)e.getSource();
            String loc = v.getLocation();
            Detour.trace("Location: " + loc);
            if (!Detour.shouldDetour(loc)) {
                return;
            }
            Detour.go(v.getLocation(), v.getId());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LOCAL_DEBUG = false;
    }
}

